/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.rating;

import java.io.IOException;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.application.FacesMessage;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.convert.ConverterException;
import javax.faces.event.PhaseId;
import org.primefaces.component.rating.Rating;
import org.primefaces.event.RateEvent;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;

public class RatingRenderer
extends CoreRenderer {
    public void decode(FacesContext facesContext, UIComponent component) {
        Rating rating = (Rating)component;
        Map params = facesContext.getExternalContext().getRequestParameterMap();
        String clientId = rating.getClientId(facesContext);
        String rateValue = (String)params.get(clientId + "_input");
        if (rating.getRateListener() != null) {
            RateEvent rateEvent = this.isValueBlank(rateValue) ? new RateEvent((UIComponent)rating, null) : new RateEvent((UIComponent)rating, Double.valueOf(rateValue));
            if (rating.isImmediate()) {
                rateEvent.setPhaseId(PhaseId.APPLY_REQUEST_VALUES);
            } else {
                rateEvent.setPhaseId(PhaseId.INVOKE_APPLICATION);
            }
            rating.queueEvent(rateEvent);
        } else {
            rating.setSubmittedValue(rateValue);
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        Rating rating = (Rating)component;
        this.encodeMarkup(facesContext, rating);
        this.encodeScript(facesContext, rating);
    }

    private void encodeScript(FacesContext facesContext, Rating rating) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = rating.getClientId(facesContext);
        String ratingVar = this.createUniqueWidgetVar(facesContext, (UIComponent)rating);
        UIComponent form = ComponentUtils.findParentForm(facesContext, (UIComponent)rating);
        if (form == null) {
            throw new FacesException("Rating:" + clientId + " needs to be enclosed in a form when using an rateListener");
        }
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write(ratingVar + " = new PrimeFaces.widget.Rating('" + clientId + "'");
        writer.write(",{");
        if (rating.getRateListener() != null) {
            writer.write("hasRateListener:true");
            writer.write(",formId:'" + form.getClientId(facesContext) + "'");
            writer.write(",actionURL:'" + this.getActionURL(facesContext) + "'");
            writer.write(",update:'" + ComponentUtils.findClientIds(facesContext, (UIComponent)rating, rating.getUpdate()) + "'");
        }
        writer.write("});");
        writer.endElement("script");
    }

    private void encodeMarkup(FacesContext facesContext, Rating rating) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = rating.getClientId(facesContext);
        Object value = rating.getValue();
        if (value != null && !(value instanceof Double)) {
            throw new FacesException("Rating component('" + clientId + "')'s value must be of type java.lang.Double");
        }
        Double ratingValue = (Double)value;
        writer.startElement("span", (UIComponent)rating);
        writer.writeAttribute("id", (Object)clientId, "id");
        for (int i = 1; i <= rating.getStars(); ++i) {
            writer.startElement("input", null);
            writer.writeAttribute("name", (Object)(clientId + "_input"), null);
            writer.writeAttribute("type", (Object)"radio", null);
            writer.writeAttribute("value", (Object)i, null);
            writer.writeAttribute("class", (Object)"pf-rating-star", null);
            if (ratingValue != null && ratingValue.intValue() == i) {
                writer.writeAttribute("checked", (Object)"checked", null);
            }
            if (rating.isDisabled()) {
                writer.writeAttribute("disabled", (Object)"disabled", null);
            }
            writer.endElement("input");
        }
        writer.endElement("span");
    }

    public Object getConvertedValue(FacesContext facesContext, UIComponent component, Object submittedValue) throws ConverterException {
        String value = (String)submittedValue;
        try {
            return Double.valueOf(value);
        }
        catch (NumberFormatException exception) {
            FacesMessage msg = new FacesMessage(FacesMessage.SEVERITY_ERROR, "Conversion error", submittedValue + " is not a valid value for " + component.getClientId(facesContext));
            throw new ConverterException(msg);
        }
    }
}

