/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.schedule;

import java.io.IOException;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import java.util.Map;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.servlet.ServletResponse;
import org.primefaces.component.schedule.Schedule;
import org.primefaces.component.schedule.ScheduleEventDialog;
import org.primefaces.event.DateSelectEvent;
import org.primefaces.event.ScheduleEntryMoveEvent;
import org.primefaces.event.ScheduleEntryResizeEvent;
import org.primefaces.event.ScheduleEntrySelectEvent;
import org.primefaces.model.LazyScheduleModel;
import org.primefaces.model.ScheduleEvent;
import org.primefaces.model.ScheduleModel;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.renderkit.PartialRenderer;
import org.primefaces.util.ComponentUtils;

public class ScheduleRenderer
extends CoreRenderer
implements PartialRenderer {
    public void decode(FacesContext facesContext, UIComponent component) {
        Schedule schedule = (Schedule)component;
        ScheduleModel model = (ScheduleModel)schedule.getValue();
        String clientId = schedule.getClientId(facesContext);
        Map params = facesContext.getExternalContext().getRequestParameterMap();
        if (params.containsKey(schedule.getClientId(facesContext))) {
            String selectedEventParam = clientId + "_selectedEventId";
            String selectedDateParam = clientId + "_selectedDate";
            String changedEventParam = clientId + "_changedEventId";
            if (params.containsKey(selectedEventParam)) {
                String eventId = (String)params.get(selectedEventParam);
                ScheduleEvent selectedEvent = model.getEvent(eventId);
                schedule.queueEvent(new ScheduleEntrySelectEvent((UIComponent)schedule, selectedEvent));
            } else if (params.containsKey(selectedDateParam)) {
                String dateAsString = (String)params.get(selectedDateParam);
                schedule.queueEvent(new DateSelectEvent(component, new Date(Long.valueOf(dateAsString))));
            } else if (params.containsKey(changedEventParam)) {
                String eventId = (String)params.get(changedEventParam);
                ScheduleEvent changedEvent = model.getEvent(eventId);
                int dayDelta = Integer.valueOf((String)params.get(clientId + "_dayDelta"));
                int minuteDelta = Integer.valueOf((String)params.get(clientId + "_minuteDelta"));
                Calendar calendar = Calendar.getInstance();
                boolean isResize = params.containsKey(clientId + "_resized");
                if (!isResize) {
                    calendar.setTime(changedEvent.getStartDate());
                    calendar.roll(5, dayDelta);
                    changedEvent.getStartDate().setTime(calendar.getTimeInMillis());
                }
                calendar = Calendar.getInstance();
                calendar.setTime(changedEvent.getEndDate());
                calendar.roll(5, dayDelta);
                changedEvent.getEndDate().setTime(calendar.getTimeInMillis());
                if (isResize) {
                    schedule.queueEvent(new ScheduleEntryResizeEvent((UIComponent)schedule, changedEvent, dayDelta, minuteDelta));
                } else {
                    schedule.queueEvent(new ScheduleEntryMoveEvent((UIComponent)schedule, changedEvent, dayDelta, minuteDelta));
                }
            }
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        Schedule schedule = (Schedule)component;
        this.encodeMarkup(facesContext, schedule);
        this.encodeScript(facesContext, schedule);
    }

    public void encodePartially(FacesContext facesContext, UIComponent component) throws IOException {
        Schedule schedule = (Schedule)component;
        String clientId = schedule.getClientId(facesContext);
        ScheduleModel model = (ScheduleModel)schedule.getValue();
        Map params = facesContext.getExternalContext().getRequestParameterMap();
        String startDateParam = (String)params.get(clientId + "_start");
        String endDateParam = (String)params.get(clientId + "_end");
        if (model instanceof LazyScheduleModel) {
            Date startDate = new Date(Long.valueOf(startDateParam));
            Date endDate = new Date(Long.valueOf(endDateParam));
            LazyScheduleModel lazyModel = (LazyScheduleModel)model;
            lazyModel.clear();
            lazyModel.loadEvents(startDate, endDate);
        }
        this.encodeEventsAsJSON(facesContext, model);
    }

    protected void encodeEventsAsJSON(FacesContext facesContext, ScheduleModel model) throws IOException {
        ServletResponse response = (ServletResponse)facesContext.getExternalContext().getResponse();
        response.setContentType("application/json");
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.write("{");
        writer.write("\"events\" : [");
        Iterator<ScheduleEvent> iterator = model.getEvents().iterator();
        while (iterator.hasNext()) {
            ScheduleEvent event = iterator.next();
            writer.write("{");
            writer.write("\"id\": \"" + event.getId() + "\"");
            writer.write(",\"title\": \"" + event.getTitle() + "\"");
            writer.write(",\"start\": " + event.getStartDate().getTime());
            writer.write(",\"end\": " + event.getEndDate().getTime());
            writer.write(",\"allDay\":" + event.isAllDay());
            if (event.getStyleClass() != null) {
                writer.write(",\"className\":\"" + event.getStyleClass() + "\"");
            }
            writer.write("}");
            if (!iterator.hasNext()) continue;
            writer.write(",");
        }
        writer.write("]}");
    }

    protected void encodeScript(FacesContext facesContext, Schedule schedule) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = schedule.getClientId(facesContext);
        String scheduleVar = this.createUniqueWidgetVar(facesContext, (UIComponent)schedule);
        ScheduleEventDialog dialog = schedule.getEventDialog();
        UIComponent form = ComponentUtils.findParentForm(facesContext, (UIComponent)schedule);
        if (form == null) {
            throw new FacesException("Schedule: '" + clientId + "' must be inside a form");
        }
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("jQuery(function() {");
        writer.write(scheduleVar + " = new PrimeFaces.widget.Schedule('" + clientId + "'");
        writer.write(",{");
        writer.write("defaultView:'" + schedule.getView() + "'");
        writer.write(",language:'" + schedule.calculateLocale(facesContext).getLanguage() + "'");
        writer.write(",formId:'" + form.getClientId(facesContext) + "'");
        writer.write(",url:'" + this.getActionURL(facesContext) + "'");
        writer.write(",theme:true");
        if (schedule.isEditable()) {
            writer.write(",editable:true");
            if (schedule.getOnEventSelectUpdate() != null) {
                writer.write(",onEventSelectUpdate:'" + ComponentUtils.findClientIds(facesContext, (UIComponent)schedule, schedule.getOnEventSelectUpdate()) + "'");
            }
            if (schedule.getOnDateSelectUpdate() != null) {
                writer.write(",onDateSelectUpdate:'" + ComponentUtils.findClientIds(facesContext, (UIComponent)schedule, schedule.getOnDateSelectUpdate()) + "'");
            }
            if (schedule.getOnEventMoveUpdate() != null) {
                writer.write(",onEventMoveUpdate:'" + ComponentUtils.findClientIds(facesContext, (UIComponent)schedule, schedule.getOnEventMoveUpdate()) + "'");
            }
            if (schedule.getOnEventResizeUpdate() != null) {
                writer.write(",onEventResizeUpdate:'" + ComponentUtils.findClientIds(facesContext, (UIComponent)schedule, schedule.getOnEventResizeUpdate()) + "'");
            }
        }
        if (dialog != null) {
            writer.write(",hasEventDialog:true");
            writer.write(",dialogClientId:'" + dialog.getClientId(facesContext) + "'");
        }
        if (schedule.getInitialDate() != null) {
            Calendar c = Calendar.getInstance();
            c.setTime((Date)schedule.getInitialDate());
            writer.write(",year: " + c.get(1));
            writer.write(",month: " + c.get(2));
            writer.write(",date: " + c.get(5));
        }
        if (schedule.isShowHeader()) {
            writer.write(",header:{");
            writer.write("left:'" + schedule.getLeftHeaderTemplate() + "'");
            writer.write(",center:'" + schedule.getCenterHeaderTemplate() + "'");
            writer.write(",right:'" + schedule.getRightHeaderTemplate() + "'}");
        } else {
            writer.write(",header:false");
        }
        if (!schedule.isAllDaySlot()) {
            writer.write(",allDaySlot:false");
        }
        if (schedule.getSlotMinutes() != 30) {
            writer.write(",slotMinutes:" + schedule.getSlotMinutes());
        }
        if (schedule.getFirstHour() != 6) {
            writer.write(",firstHour:" + schedule.getFirstHour());
        }
        if (schedule.getMinTime() != null) {
            writer.write(",minTime:'" + schedule.getMinTime() + "'");
        }
        if (schedule.getMaxTime() != null) {
            writer.write(",maxTime:'" + schedule.getMaxTime() + "'");
        }
        if (schedule.getAspectRatio() != null) {
            writer.write(",aspectRatio: '" + schedule.getAspectRatio() + "'");
        }
        if (!schedule.isShowWeekends()) {
            writer.write(",weekends:false");
        }
        if (!schedule.isDraggable()) {
            writer.write(",disableDragging:true");
        }
        if (!schedule.isResizable()) {
            writer.write(",disableResizing:true");
        }
        if (schedule.getStartWeekday() != 0) {
            writer.write(",firstDay:" + schedule.getStartWeekday());
        }
        writer.write("});});");
        writer.endElement("script");
    }

    protected void encodeMarkup(FacesContext facesContext, Schedule schedule) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = schedule.getClientId(facesContext);
        ScheduleEventDialog dialog = schedule.getEventDialog();
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)clientId, null);
        if (schedule.getStyle() != null) {
            writer.writeAttribute("style", (Object)schedule.getStyle(), "style");
        }
        if (schedule.getStyleClass() != null) {
            writer.writeAttribute("class", (Object)schedule.getStyleClass(), "style");
        }
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)(clientId + "_container"), null);
        writer.endElement("div");
        if (dialog != null) {
            this.encodeDialogMarkup(facesContext, schedule, dialog);
        }
        writer.endElement("div");
    }

    protected void encodeDialogMarkup(FacesContext facesContext, Schedule schedule, ScheduleEventDialog dialog) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = schedule.getClientId(facesContext);
        writer.startElement("div", null);
        writer.writeAttribute("id", (Object)(clientId + "_dialogContainer"), null);
        if (dialog.getHeader() != null) {
            writer.startElement("div", null);
            writer.writeAttribute("class", (Object)"hd", null);
            writer.write(dialog.getHeader());
            writer.endElement("div");
        }
        writer.startElement("div", null);
        writer.writeAttribute("class", (Object)"bd", null);
        this.renderChild(facesContext, (UIComponent)dialog);
        writer.endElement("div");
        writer.endElement("div");
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

