/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.spreadsheet;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.column.Column;
import org.primefaces.component.spreadsheet.Sheet;
import org.primefaces.component.spreadsheet.Spreadsheet;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;

public class SpreadsheetRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        Spreadsheet ss = (Spreadsheet)component;
        this.encodeMarkup(facesContext, ss);
        this.encodeScript(facesContext, ss);
    }

    protected void encodeMarkup(FacesContext facesContext, Spreadsheet ss) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = ss.getClientId(facesContext);
        writer.startElement("div", (UIComponent)ss);
        writer.writeAttribute("id", (Object)clientId, "id");
        writer.startElement("div", (UIComponent)ss);
        writer.writeAttribute("id", (Object)(clientId + "_datasources"), "id");
        for (UIComponent component : ss.getChildren()) {
            this.encodeSheet(facesContext, (Sheet)component, true);
        }
        writer.endElement("div");
        writer.startElement("div", (UIComponent)ss);
        writer.writeAttribute("id", (Object)(clientId + "_datatransports"), "id");
        for (UIComponent component : ss.getChildren()) {
            this.encodeSheet(facesContext, (Sheet)component, false);
        }
        writer.endElement("div");
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext facesContext, Spreadsheet ss) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String widgetVar = this.createUniqueWidgetVar(facesContext, (UIComponent)ss);
        String clientId = ss.getClientId(facesContext);
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("jQuery(function() {");
        writer.write(widgetVar + " = new PrimeFaces.widget.Spreadsheet('" + clientId + "', {");
        writer.write("editable:" + ss.isEditable());
        if (ss.getTitle() != null) {
            writer.write(",title:'" + ss.getTitle() + "'");
        }
        if (ss.getColumnWidth() != Integer.MIN_VALUE) {
            writer.write(",newColumnWidth:" + ss.getColumnWidth());
        }
        writer.write("});});");
        writer.endElement("script");
    }

    protected void encodeSheet(FacesContext facesContext, Sheet sheet, boolean datasource) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        String clientId = sheet.getClientId(facesContext);
        String tableId = datasource ? clientId + "_datasource" : clientId + "_datatransport";
        int first = sheet.getFirst();
        int rowCount = sheet.getRowCount();
        writer.startElement("table", (UIComponent)sheet);
        writer.writeAttribute("id", (Object)tableId, "id");
        if (!datasource) {
            writer.writeAttribute("style", (Object)"display:none", null);
        }
        if (sheet.getTitle() != null) {
            writer.writeAttribute("title", (Object)sheet.getTitle(), null);
        }
        writer.startElement("tbody", null);
        for (int i = first; i < rowCount; ++i) {
            sheet.setRowIndex(i);
            writer.startElement("tr", null);
            for (UIComponent child : sheet.getChildren()) {
                if (!child.isRendered() || !(child instanceof Column)) continue;
                Column column = (Column)child;
                writer.startElement("td", null);
                if (datasource) {
                    writer.write(ComponentUtils.getStringValueToRender(facesContext, (UIComponent)column.getChildren().get(0)));
                } else {
                    this.renderChildren(facesContext, (UIComponent)column);
                }
                writer.endElement("td");
            }
            writer.endElement("tr");
        }
        writer.endElement("tbody");
        writer.endElement("table");
        sheet.setRowIndex(-1);
    }

    public void encodeChildren(FacesContext facesContext, UIComponent component) throws IOException {
    }

    public boolean getRendersChildren() {
        return true;
    }
}

