/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.themeswitcher;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.component.themeswitcher.ThemeSwitcher;
import org.primefaces.renderkit.CoreRenderer;

public class ThemeSwitcherRenderer
extends CoreRenderer {
    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        ThemeSwitcher ts = (ThemeSwitcher)component;
        this.encodeMarkup(facesContext, ts);
        this.encodeScript(facesContext, ts);
    }

    protected void encodeMarkup(FacesContext facesContext, ThemeSwitcher ts) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("div", (UIComponent)ts);
        writer.writeAttribute("id", (Object)ts.getClientId(facesContext), null);
        writer.endElement("div");
    }

    protected void encodeScript(FacesContext facesContext, ThemeSwitcher ts) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("jQuery(function(){");
        writer.write("jQuery(PrimeFaces.escapeClientId('" + ts.getClientId(facesContext) + "')).themeswitcher({");
        writer.write("width:" + ts.getWidth());
        writer.write(",height:" + ts.getHeight());
        if (ts.getButtonHeight() != 14) {
            writer.write(",buttonHeight:" + ts.getButtonHeight());
        }
        if (ts.getButtonPreText() != null) {
            writer.write(",buttonPreText:'" + ts.getButtonPreText() + "'");
        }
        if (ts.getInitialText() != null) {
            writer.write(",initialText:'" + ts.getInitialText() + "'");
        }
        if (ts.getTheme() != null) {
            writer.write(",loadTheme:'" + ts.getTheme() + "'");
        }
        writer.write("});});");
        writer.endElement("script");
    }
}

