/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.component.uiajax;

import java.io.IOException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.component.UIParameter;
import javax.faces.context.FacesContext;
import javax.faces.event.ActionEvent;
import javax.faces.event.FacesEvent;
import org.primefaces.component.uiajax.UIAjax;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.util.ComponentUtils;

public class UIAjaxRenderer
extends CoreRenderer {
    public void decode(FacesContext facesContext, UIComponent component) {
        UIAjax ajax = (UIAjax)component;
        String clientId = ajax.getClientId(facesContext);
        if (facesContext.getExternalContext().getRequestParameterMap().containsKey(clientId)) {
            ajax.queueEvent((FacesEvent)new ActionEvent((UIComponent)ajax));
        }
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        UIAjax uiajax = (UIAjax)component;
        UIComponent parent = uiajax.getParent();
        String formClientId = null;
        String clientId = uiajax.getClientId(facesContext);
        UIComponent form = ComponentUtils.findParentForm(facesContext, (UIComponent)uiajax);
        if (form == null) {
            throw new FacesException("UIAjax:" + clientId + " needs to be enclosed in a form");
        }
        formClientId = ComponentUtils.findParentForm(facesContext, (UIComponent)uiajax).getClientId(facesContext);
        String ajaxRequest = this.createAjaxRequest(facesContext, uiajax, formClientId, clientId);
        ComponentUtils.decorateAttribute(parent, "on" + uiajax.getEvent(), ajaxRequest);
    }

    protected String createAjaxRequest(FacesContext facesContext, UIAjax uiajax, String formId, String decodeParam) {
        StringBuilder req = new StringBuilder();
        req.append("PrimeFaces.ajax.AjaxRequest('");
        req.append(this.getActionURL(facesContext));
        req.append("',{");
        req.append("formId:'");
        req.append(formId);
        req.append("'");
        if (uiajax.isAsync()) {
            req.append(",async:true");
        }
        if (uiajax.getOnstart() != null) {
            req.append(",onstart:function(xhr){" + uiajax.getOnstart() + ";}");
        }
        if (uiajax.getOnerror() != null) {
            req.append(",onerror:function(xhr, status, error){" + uiajax.getOnerror() + ";}");
        }
        if (uiajax.getOnsuccess() != null) {
            req.append(",onsuccess:function(data, status, xhr, args){" + uiajax.getOnsuccess() + ";}");
        }
        if (uiajax.getOncomplete() != null) {
            req.append(",oncomplete:function(xhr, status, args){" + uiajax.getOncomplete() + ";}");
        }
        req.append(",global:" + uiajax.isGlobal());
        req.append("},{");
        req.append("'" + decodeParam + "'");
        req.append(":");
        req.append("'" + decodeParam + "'");
        if (uiajax.getUpdate() != null) {
            req.append(",'primefacesPartialUpdate':");
            req.append("'" + ComponentUtils.findClientIds(facesContext, uiajax.getParent(), uiajax.getUpdate()) + "'");
        }
        if (uiajax.getProcess() != null) {
            req.append(",'primefacesPartialProcess':");
            req.append("'" + ComponentUtils.findClientIds(facesContext, uiajax.getParent(), uiajax.getProcess()) + "'");
        }
        for (UIComponent child : uiajax.getChildren()) {
            if (!(child instanceof UIParameter)) continue;
            UIParameter parameter = (UIParameter)child;
            req.append(",");
            req.append("'" + parameter.getName() + "'");
            req.append(":");
            req.append("'" + parameter.getValue() + "'");
        }
        req.append("});");
        return req.toString();
    }
}

