/*
 * Decompiled with CFR 0.152.
 */
package org.primefaces.touch.component.application;

import java.io.IOException;
import java.util.ListIterator;
import java.util.logging.Logger;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.primefaces.renderkit.CoreRenderer;
import org.primefaces.resource.ResourceUtils;
import org.primefaces.touch.component.application.Application;

public class ApplicationRenderer
extends CoreRenderer {
    private static final Logger logger = Logger.getLogger(ApplicationRenderer.class.getName());

    public void encodeBegin(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        Application application = (Application)component;
        String themeRelativePath = "/jquery/plugins/jqtouch/themes/" + application.getTheme();
        String themeRealPath = ResourceUtils.getResourceURL(facesContext, themeRelativePath);
        writer.startElement("html", null);
        writer.startElement("head", null);
        this.renderCSSDependency(facesContext, "/jquery/plugins/jqtouch/jqtouch.min.css");
        this.renderCSSDependency(facesContext, themeRelativePath + "/theme.min.css");
        ListIterator iter = facesContext.getViewRoot().getComponentResources(facesContext, "head").listIterator();
        while (iter.hasNext()) {
            UIComponent resource = (UIComponent)iter.next();
            resource.encodeAll(facesContext);
        }
        writer.startElement("script", null);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        writer.write("TouchFaces = new PrimeFaces.touch.Application({");
        writer.write("themePath:'" + themeRealPath + "'");
        if (application.getIcon() != null) {
            writer.write(",icon:'" + this.getResourceURL(facesContext, application.getIcon()) + "'");
        }
        writer.write("});\n");
        writer.endElement("script");
        UIComponent meta = application.getFacet("meta");
        if (meta != null) {
            this.renderChild(facesContext, meta);
        }
        writer.endElement("head");
        writer.startElement("body", null);
    }

    public void encodeEnd(FacesContext facesContext, UIComponent component) throws IOException {
        ResponseWriter writer = facesContext.getResponseWriter();
        writer.endElement("body");
        writer.write("\n");
        writer.endElement("html");
    }
}

