/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.spring.webmvc.editor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.spring.api.Action;
import org.netbeans.modules.spring.api.beans.SpringScope;
import org.netbeans.modules.spring.api.beans.model.SpringBean;
import org.netbeans.modules.spring.api.beans.model.SpringBeans;
import org.netbeans.modules.spring.api.beans.model.SpringConfigModel;
import org.netbeans.modules.web.el.spi.ELVariableResolver;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public final class SpringBeansELVariableResolver
implements ELVariableResolver {
    public String getBeanClass(String beanName, FileObject context) {
        for (SpringBean bean : this.getSpringBeans(context)) {
            if (!beanName.equals(SpringBeansELVariableResolver.getBeanName(bean))) continue;
            return bean.getClassName();
        }
        return null;
    }

    public String getBeanName(String clazz, FileObject context) {
        for (SpringBean bean : this.getSpringBeans(context)) {
            if (!clazz.equals(bean.getClassName())) continue;
            return SpringBeansELVariableResolver.getBeanName(bean);
        }
        return null;
    }

    public List<ELVariableResolver.VariableInfo> getManagedBeans(FileObject context) {
        List<SpringBean> beans = this.getSpringBeans(context);
        ArrayList<ELVariableResolver.VariableInfo> result = new ArrayList<ELVariableResolver.VariableInfo>(beans.size());
        for (SpringBean bean : beans) {
            String beanName = SpringBeansELVariableResolver.getBeanName(bean);
            if (beanName == null) continue;
            result.add(ELVariableResolver.VariableInfo.createResolvedVariable((String)SpringBeansELVariableResolver.getBeanName(bean), (String)bean.getClassName()));
        }
        return result;
    }

    public List<ELVariableResolver.VariableInfo> getVariables(Snapshot snapshot, int offset) {
        return Collections.emptyList();
    }

    public List<ELVariableResolver.VariableInfo> getBeansInScope(String scope, Snapshot context) {
        return Collections.emptyList();
    }

    public List<ELVariableResolver.VariableInfo> getRawObjectProperties(String name, Snapshot context) {
        return Collections.emptyList();
    }

    private List<SpringBean> getSpringBeans(FileObject context) {
        SpringScope scope = SpringScope.getSpringScope((FileObject)context);
        final ArrayList<SpringBean> allSpringBeans = new ArrayList<SpringBean>();
        if (scope != null) {
            for (SpringConfigModel model : scope.getAllConfigModels()) {
                try {
                    model.runReadAction((Action)new Action<SpringBeans>(){

                        public void run(SpringBeans beans) {
                            allSpringBeans.addAll(beans.getBeans());
                        }
                    });
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        return allSpringBeans;
    }

    private static String getBeanName(SpringBean bean) {
        String beanName = null;
        Iterator i$ = bean.getNames().iterator();
        if (i$.hasNext()) {
            String name;
            beanName = name = (String)i$.next();
        }
        if (beanName == null) {
            beanName = bean.getId();
        }
        return beanName;
    }
}

