/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.indicators;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.netbeans.modules.dlight.api.indicator.IndicatorConfiguration;
import org.netbeans.modules.dlight.api.indicator.IndicatorMetadata;
import org.netbeans.modules.dlight.indicators.Aggregation;
import org.netbeans.modules.dlight.indicators.DataRowToTimeSeries;
import org.netbeans.modules.dlight.indicators.DetailDescriptor;
import org.netbeans.modules.dlight.indicators.TimeSeriesDescriptor;
import org.netbeans.modules.dlight.indicators.graph.TimeSeriesIndicatorConfigurationAccessor;
import org.netbeans.modules.dlight.util.ValueFormatter;

public final class TimeSeriesIndicatorConfiguration
extends IndicatorConfiguration {
    private String title = "";
    private int scale = 100;
    private final List<TimeSeriesDescriptor> seriesDescriptors = new ArrayList<TimeSeriesDescriptor>();
    private final List<DetailDescriptor> detailDescriptors = new ArrayList<DetailDescriptor>();
    private DataRowToTimeSeries dataRowHandler;
    private long granularity;
    private long extent;
    private Aggregation aggr = Aggregation.LAST;
    private ValueFormatter formatter;
    private boolean lastNonNull = true;
    private String persistencePrefix;
    private boolean legendIsVisible = true;

    public TimeSeriesIndicatorConfiguration(IndicatorMetadata metadata, int position) {
        super(metadata, position, true);
        this.granularity = TimeUnit.NANOSECONDS.convert(1L, TimeUnit.SECONDS);
        this.extent = TimeUnit.NANOSECONDS.convert(20L, TimeUnit.SECONDS);
    }

    public String getID() {
        return "DLightTimeSeriesIndicatorConfigurationID";
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setGraphScale(int scale) {
        this.scale = scale;
    }

    public void setExtent(long extent) {
        this.extent = extent;
    }

    public void addTimeSeriesDescriptors(TimeSeriesDescriptor ... seriesDescriptors) {
        this.seriesDescriptors.addAll(Arrays.asList(seriesDescriptors));
    }

    public void addDetailDescriptors(DetailDescriptor ... detailDescriptors) {
        this.detailDescriptors.addAll(Arrays.asList(detailDescriptors));
    }

    public void setDataRowHandler(DataRowToTimeSeries dataRowHandler) {
        this.dataRowHandler = dataRowHandler;
    }

    public void setLabelFormatter(ValueFormatter formatter) {
        this.formatter = formatter;
    }

    public void setAggregation(Aggregation aggr) {
        this.aggr = aggr;
    }

    public void setGranularity(long granularity) {
        this.granularity = granularity;
    }

    public void setLastNonNull(boolean lastNonNull) {
        this.lastNonNull = lastNonNull;
    }

    public void setPersistencePrefix(String persistencePrefix) {
        this.persistencePrefix = persistencePrefix;
    }

    public void setLegendIsVisible(boolean legendIsVisible) {
        this.legendIsVisible = legendIsVisible;
    }

    static {
        TimeSeriesIndicatorConfigurationAccessor.setDefault(new TimeSeriesIndicatorConfigurationAccessorImpl());
    }

    private static class TimeSeriesIndicatorConfigurationAccessorImpl
    extends TimeSeriesIndicatorConfigurationAccessor {
        private TimeSeriesIndicatorConfigurationAccessorImpl() {
        }

        @Override
        public String getTitle(TimeSeriesIndicatorConfiguration conf) {
            return conf.title;
        }

        @Override
        public boolean isLegendVisible(TimeSeriesIndicatorConfiguration conf) {
            return conf.legendIsVisible;
        }

        @Override
        public int getGraphScale(TimeSeriesIndicatorConfiguration conf) {
            return conf.scale;
        }

        @Override
        public List<TimeSeriesDescriptor> getTimeSeriesDescriptors(TimeSeriesIndicatorConfiguration conf) {
            return Collections.unmodifiableList(conf.seriesDescriptors);
        }

        @Override
        public List<DetailDescriptor> getDetailDescriptors(TimeSeriesIndicatorConfiguration conf) {
            return Collections.unmodifiableList(conf.detailDescriptors);
        }

        @Override
        public DataRowToTimeSeries getDataRowHandler(TimeSeriesIndicatorConfiguration conf) {
            return conf.dataRowHandler;
        }

        @Override
        public ValueFormatter getLabelFormatter(TimeSeriesIndicatorConfiguration conf) {
            return conf.formatter;
        }

        @Override
        public long getGranularity(TimeSeriesIndicatorConfiguration conf) {
            return conf.granularity;
        }

        @Override
        public Aggregation getAggregation(TimeSeriesIndicatorConfiguration conf) {
            return conf.aggr;
        }

        @Override
        public boolean getLastNonNull(TimeSeriesIndicatorConfiguration conf) {
            return conf.lastNonNull;
        }

        @Override
        public String getPersistencePrefix(TimeSeriesIndicatorConfiguration conf) {
            return conf.persistencePrefix;
        }

        @Override
        public long getExtent(TimeSeriesIndicatorConfiguration conf) {
            return conf.extent;
        }
    }
}

