/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.api.model;

import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper;
import org.openide.filesystems.FileObject;

public class ModelUnit {
    private final AnnotationModelHelper myHelper;
    private final ClassPath myBootPath;
    private final ClassPath myCompilePath;
    private final ClassPath mySourcePath;

    private ModelUnit(ClassPath bootPath, ClassPath compilePath, ClassPath sourcePath) {
        this.myBootPath = bootPath;
        this.myCompilePath = compilePath;
        this.mySourcePath = sourcePath;
        ClasspathInfo classpathInfo = ClasspathInfo.create((ClassPath)bootPath, (ClassPath)compilePath, (ClassPath)sourcePath);
        this.myHelper = AnnotationModelHelper.create((ClasspathInfo)classpathInfo);
    }

    public boolean equals(Object obj) {
        if (obj instanceof ModelUnit) {
            ModelUnit unit = (ModelUnit)obj;
            return this.myBootPath.equals(unit.myBootPath) && this.myCompilePath.equals(unit.myCompilePath) && this.mySourcePath.equals(this.mySourcePath);
        }
        return false;
    }

    public ClassPath getBootPath() {
        return this.myBootPath;
    }

    public ClassPath getCompilePath() {
        return this.myCompilePath;
    }

    public ClassPath getSourcePath() {
        return this.mySourcePath;
    }

    public int hashCode() {
        return 37 * (37 * this.myBootPath.hashCode() + this.myCompilePath.hashCode()) + this.mySourcePath.hashCode();
    }

    public static ModelUnit create(ClassPath bootPath, ClassPath compilePath, ClassPath sourcePath) {
        return new ModelUnit(bootPath, compilePath, sourcePath);
    }

    FileObject getSourceFileObject() {
        FileObject[] roots = this.mySourcePath.getRoots();
        if (roots != null && roots.length > 0) {
            return roots[0];
        }
        return null;
    }

    AnnotationModelHelper getHelper() {
        return this.myHelper;
    }
}

