/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.api.model.support;

import java.io.IOException;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import javax.lang.model.element.Element;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelAction;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModelException;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.beans.api.model.ModelUnit;
import org.netbeans.modules.web.beans.api.model.WebBeansModel;
import org.netbeans.spi.java.classpath.ClassPathProvider;
import org.netbeans.spi.java.classpath.support.ClassPathSupport;
import org.openide.filesystems.FileObject;
import org.openide.util.Exceptions;

public final class WebBeansModelSupport {
    private WebBeansModelSupport() {
    }

    public static List<WebBean> getNamedBeans(MetadataModel<WebBeansModel> webBeansModel) {
        try {
            return (List)webBeansModel.runReadAction((MetadataModelAction)new MetadataModelAction<WebBeansModel, List<WebBean>>(){

                public List<WebBean> run(WebBeansModel metadata) throws Exception {
                    List<Element> namedElements = metadata.getNamedElements();
                    LinkedList<WebBean> webBeans = new LinkedList<WebBean>();
                    for (Element e : namedElements) {
                        if (e == null) continue;
                        webBeans.add(new WebBean(e, metadata.getName(e)));
                    }
                    return webBeans;
                }
            });
        }
        catch (MetadataModelException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        catch (IOException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        return Collections.emptyList();
    }

    public static ModelUnit getModelUnit(WebModule module) {
        if (module == null) {
            return null;
        }
        FileObject fileObject = WebBeansModelSupport.getFileObject(module);
        Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
        if (project == null) {
            return null;
        }
        ClassPath boot = WebBeansModelSupport.getClassPath(project, "classpath/boot");
        ClassPath compile = WebBeansModelSupport.getClassPath(project, "classpath/compile");
        ClassPath src = WebBeansModelSupport.getClassPath(project, "classpath/source");
        return ModelUnit.create(boot, compile, src);
    }

    private static ClassPath getClassPath(Project project, String type) {
        ClassPathProvider provider = (ClassPathProvider)project.getLookup().lookup(ClassPathProvider.class);
        if (provider == null) {
            return null;
        }
        Sources sources = (Sources)project.getLookup().lookup(Sources.class);
        if (sources == null) {
            return null;
        }
        SourceGroup[] sourceGroups = sources.getSourceGroups("java");
        ClassPath[] paths = new ClassPath[sourceGroups.length];
        int i = 0;
        for (SourceGroup sourceGroup : sourceGroups) {
            FileObject rootFolder = sourceGroup.getRootFolder();
            paths[i] = provider.findClassPath(rootFolder, type);
        }
        return ClassPathSupport.createProxyClassPath((ClassPath[])paths);
    }

    private static FileObject getFileObject(WebModule module) {
        FileObject fileObject = module.getDocumentBase();
        if (fileObject != null) {
            return fileObject;
        }
        fileObject = module.getDeploymentDescriptor();
        if (fileObject != null) {
            return fileObject;
        }
        fileObject = module.getWebInf();
        if (fileObject != null) {
            return fileObject;
        }
        FileObject[] fileObjects = module.getJavaSources();
        if (fileObjects != null) {
            for (FileObject source : fileObjects) {
                if (source == null) continue;
                return source;
            }
        }
        return null;
    }

    public static final class WebBean {
        private Element element;
        private String name;

        private WebBean(Element element, String name) {
            this.element = element;
            this.name = name;
        }

        private Element getElement() {
            return this.element;
        }

        public String getBeanClassName() {
            return ((Object)this.getElement().asType()).toString();
        }

        public String getName() {
            return this.name;
        }
    }
}

