/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.hints;

import com.sun.source.tree.Tree;
import com.sun.source.util.TreePath;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.PackageElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.swing.text.Document;
import org.netbeans.api.editor.EditorRegistry;
import org.netbeans.api.j2ee.core.Profile;
import org.netbeans.api.java.lexer.JavaTokenId;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.SourceUtils;
import org.netbeans.api.java.source.TreeUtilities;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.editor.NbEditorUtilities;
import org.netbeans.modules.java.hints.spi.ErrorRule;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.beans.hints.CreateInterceptorBinding;
import org.netbeans.modules.web.beans.hints.CreateQualifierFix;
import org.netbeans.spi.editor.hints.Fix;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class CreateQualifier
implements ErrorRule<Void> {
    private static final String INJECT_ANNOTATION = "javax.inject.Inject";
    private static final String DISPOSES_ANNOTATION = "javax.enterprise.inject.Disposes";
    private static final String OBSERVES_ANNOTATION = "javax.enterprise.event.Observes";
    private static final String PRODUCER_ANNOTATION = "javax.enterprise.inject.Produces";
    private static final String INTERCEPTOR_ANNOTATION = "javax.interceptor.Interceptor";

    public String getId() {
        return CreateQualifier.class.getName();
    }

    public String getDisplayName() {
        return NbBundle.getMessage(CreateQualifier.class, (String)"LBL_CreateCDIAnnotation");
    }

    public void cancel() {
    }

    public Set<String> getCodes() {
        return new HashSet<String>(Arrays.asList("compiler.err.cant.resolve.location", "compiler.err.cant.resolve.location.args", "compiler.err.cant.apply.symbol", "compiler.err.cant.resolve", "compiler.err.cant.resolve.args"));
    }

    public List<Fix> run(CompilationInfo compilationInfo, String diagnosticKey, int offset, TreePath treePath, ErrorRule.Data<Void> data) {
        try {
            return this.analyze(compilationInfo, offset);
        }
        catch (IOException e) {
            Logger.getLogger(CreateQualifier.class.getName()).log(Level.SEVERE, null, e);
            return null;
        }
        catch (ClassCastException e) {
            Logger.getLogger(CreateQualifier.class.getName()).log(Level.FINE, null, e);
            return null;
        }
    }

    protected List<Fix> analyze(CompilationInfo compilationInfo, int offset) throws IOException {
        TreePath errorPath = this.findUnresolvedElement(compilationInfo, offset);
        if (!this.checkProject() || errorPath == null) {
            return Collections.emptyList();
        }
        if (compilationInfo.getElements().getTypeElement("java.lang.Object") == null) {
            return Collections.emptyList();
        }
        Element element = compilationInfo.getTrees().getElement(errorPath);
        if (element.getSimpleName() == null || errorPath.getLeaf().getKind() != Tree.Kind.IDENTIFIER) {
            return Collections.emptyList();
        }
        TreePath parentPath = errorPath.getParentPath();
        if (parentPath.getLeaf().getKind() != Tree.Kind.ANNOTATION) {
            return Collections.emptyList();
        }
        Element annotation = compilationInfo.getTrees().getElement(parentPath);
        for (TreePath path = parentPath; path != null; path = path.getParentPath()) {
            Element method;
            Tree leaf = path.getLeaf();
            Tree.Kind leafKind = leaf.getKind();
            if (TreeUtilities.CLASS_TREE_KINDS.contains((Object)leafKind)) {
                Element clazz = compilationInfo.getTrees().getElement(path);
                if (clazz.getKind() != ElementKind.CLASS) continue;
                return this.analyzeClass(compilationInfo, (TypeElement)clazz, annotation);
            }
            if (leafKind == Tree.Kind.VARIABLE) {
                Element var = compilationInfo.getTrees().getElement(path);
                Element parent = var.getEnclosingElement();
                if (var.getKind() != ElementKind.FIELD || !(parent instanceof TypeElement)) continue;
                return this.analyzeField(compilationInfo, var, annotation, (TypeElement)parent);
            }
            if (leafKind != Tree.Kind.METHOD || (method = compilationInfo.getTrees().getElement(path)).getKind() != ElementKind.METHOD) continue;
            return this.analyzeMethodParameter(compilationInfo, (ExecutableElement)method, annotation);
        }
        return null;
    }

    private List<Fix> analyzeMethodParameter(CompilationInfo compilationInfo, ExecutableElement method, Element annotation) {
        boolean bl;
        Element parent = method.getEnclosingElement();
        if (!(parent instanceof TypeElement)) {
            return Collections.emptyList();
        }
        List<? extends VariableElement> parameters = method.getParameters();
        List<? extends AnnotationMirror> allAnnotationMirrors = compilationInfo.getElements().getAllAnnotationMirrors(method);
        for (AnnotationMirror annotationMirror : allAnnotationMirrors) {
            TypeElement annotationElement = (TypeElement)annotationMirror.getAnnotationType().asElement();
            if (!annotationElement.getQualifiedName().contentEquals(INJECT_ANNOTATION) && !annotationElement.getQualifiedName().contentEquals(PRODUCER_ANNOTATION)) continue;
            return this.createQualifierFix(compilationInfo, annotation, parent);
        }
        boolean hasDisposesObserves = false;
        boolean bl2 = false;
        for (VariableElement variableElement : parameters) {
            allAnnotationMirrors = compilationInfo.getElements().getAllAnnotationMirrors(variableElement);
            for (AnnotationMirror annotationMirror : allAnnotationMirrors) {
                TypeElement annotationElement = (TypeElement)annotationMirror.getAnnotationType().asElement();
                if (annotationElement.getQualifiedName().contentEquals(OBSERVES_ANNOTATION) || annotationElement.getQualifiedName().contentEquals(DISPOSES_ANNOTATION)) {
                    hasDisposesObserves = true;
                    continue;
                }
                if (!annotationElement.equals(annotation)) continue;
                bl = true;
            }
        }
        if (bl && hasDisposesObserves) {
            return this.createQualifierFix(compilationInfo, annotation, parent);
        }
        return Collections.emptyList();
    }

    private List<Fix> createQualifierFix(CompilationInfo compilationInfo, Element annotation, Element classElement) {
        PackageElement packageElement = compilationInfo.getElements().getPackageOf(classElement);
        FileObject targetFile = SourceUtils.getFile((ElementHandle)ElementHandle.create((Element)classElement), (ClasspathInfo)compilationInfo.getClasspathInfo());
        return Collections.singletonList(new CreateQualifierFix(compilationInfo, annotation.getSimpleName().toString(), packageElement.getQualifiedName().toString(), targetFile));
    }

    private List<Fix> createInterceptorFix(CompilationInfo compilationInfo, Element annotation, Element classElement) {
        PackageElement packageElement = compilationInfo.getElements().getPackageOf(classElement);
        FileObject targetFile = SourceUtils.getFile((ElementHandle)ElementHandle.create((Element)classElement), (ClasspathInfo)compilationInfo.getClasspathInfo());
        return Collections.singletonList(new CreateInterceptorBinding(compilationInfo, annotation.getSimpleName().toString(), packageElement.getQualifiedName().toString(), targetFile));
    }

    private List<Fix> analyzeField(CompilationInfo compilationInfo, Element var, Element annotation, TypeElement parent) {
        List<? extends AnnotationMirror> allAnnotationMirrors = compilationInfo.getElements().getAllAnnotationMirrors(var);
        boolean isInjectionPoint = false;
        boolean hasRequiredAnnotation = false;
        for (AnnotationMirror annotationMirror : allAnnotationMirrors) {
            Element annotationElement = annotationMirror.getAnnotationType().asElement();
            TypeElement annotationTypeElement = (TypeElement)annotationElement;
            if (((Object)annotationElement).equals(annotation)) {
                hasRequiredAnnotation = true;
                continue;
            }
            if (!annotationTypeElement.getQualifiedName().contentEquals(INJECT_ANNOTATION) && !annotationTypeElement.getQualifiedName().contentEquals(PRODUCER_ANNOTATION)) continue;
            isInjectionPoint = true;
        }
        if (hasRequiredAnnotation && isInjectionPoint) {
            return this.createQualifierFix(compilationInfo, annotation, parent);
        }
        return Collections.emptyList();
    }

    private List<Fix> analyzeClass(CompilationInfo compilationInfo, TypeElement clazz, Element annotation) {
        List<? extends AnnotationMirror> allAnnotationMirrors = compilationInfo.getElements().getAllAnnotationMirrors(clazz);
        boolean isInterceptor = false;
        boolean hasAnnotation = false;
        for (AnnotationMirror annotationMirror : allAnnotationMirrors) {
            Element annotationElement = annotationMirror.getAnnotationType().asElement();
            if (((Object)annotationElement).equals(annotation)) {
                hasAnnotation = true;
            }
            if (!(annotationElement instanceof TypeElement) || !((TypeElement)annotationElement).getQualifiedName().contentEquals(INTERCEPTOR_ANNOTATION)) continue;
            isInterceptor = true;
        }
        if (!hasAnnotation) {
            return Collections.emptyList();
        }
        if (isInterceptor) {
            return this.createInterceptorFix(compilationInfo, annotation, clazz);
        }
        return this.createQualifierFix(compilationInfo, annotation, clazz);
    }

    private boolean checkProject() {
        FileObject fileObject = NbEditorUtilities.getFileObject((Document)EditorRegistry.lastFocusedComponent().getDocument());
        if (fileObject == null) {
            return false;
        }
        WebModule webModule = WebModule.getWebModule((FileObject)fileObject);
        if (webModule == null) {
            return false;
        }
        Profile profile = webModule.getJ2eeProfile();
        return profile.equals(Profile.JAVA_EE_6_FULL) || profile.equals(Profile.JAVA_EE_6_WEB);
    }

    private TreePath findUnresolvedElement(CompilationInfo info, int offset) throws IOException {
        int[] span = this.findUnresolvedElementSpan(info, offset);
        if (span != null) {
            return info.getTreeUtilities().pathFor(span[0] + 1);
        }
        return null;
    }

    private int[] findUnresolvedElementSpan(CompilationInfo info, int offset) throws IOException {
        Token<?> t = this.findUnresolvedElementToken(info, offset);
        if (t != null) {
            return new int[]{t.offset(null), t.offset(null) + t.length()};
        }
        return null;
    }

    private Token<?> findUnresolvedElementToken(CompilationInfo info, int offset) throws IOException {
        TokenHierarchy th = info.getTokenHierarchy();
        TokenSequence ts = th.tokenSequence(JavaTokenId.language());
        if (ts == null) {
            return null;
        }
        ts.move(offset);
        if (ts.moveNext()) {
            Token t = ts.token();
            if (t.id() == JavaTokenId.DOT) {
                ts.moveNext();
                t = ts.token();
            } else if (t.id() == JavaTokenId.LT) {
                ts.moveNext();
                t = ts.token();
            } else if (t.id() == JavaTokenId.NEW || t.id() == JavaTokenId.WHITESPACE) {
                boolean cont = ts.moveNext();
                while (cont && ts.token().id() == JavaTokenId.WHITESPACE) {
                    cont = ts.moveNext();
                }
                if (!cont) {
                    return null;
                }
                t = ts.token();
            }
            if (t.id() == JavaTokenId.IDENTIFIER) {
                return ts.offsetToken();
            }
        }
        return null;
    }
}

