/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.impl.model;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.ClassIndex;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.api.java.source.ElementUtilities;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationHandler;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.PersistentObjectManager;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.AnnotationParser;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.ParseResult;
import org.netbeans.modules.web.beans.api.model.Result;
import org.netbeans.modules.web.beans.impl.model.AnnotationObjectProvider;
import org.netbeans.modules.web.beans.impl.model.BeansFilter;
import org.netbeans.modules.web.beans.impl.model.BindingQualifier;
import org.netbeans.modules.web.beans.impl.model.DefaultBindingTypeFilter;
import org.netbeans.modules.web.beans.impl.model.EnableBeansFilter;
import org.netbeans.modules.web.beans.impl.model.MemberBindingFilter;
import org.netbeans.modules.web.beans.impl.model.QualifierChecker;
import org.netbeans.modules.web.beans.impl.model.TypeBindingFilter;
import org.netbeans.modules.web.beans.impl.model.TypeProductionFilter;
import org.netbeans.modules.web.beans.impl.model.WebBeansModelImplementation;
import org.netbeans.modules.web.beans.impl.model.WebBeansModelProviderImpl;
import org.netbeans.modules.web.beans.impl.model.results.DefinitionErrorResult;
import org.netbeans.modules.web.beans.impl.model.results.ResultImpl;
import org.netbeans.modules.web.beans.model.spi.WebBeansModelProvider;
import org.openide.util.NbBundle;

abstract class FieldInjectionPointLogic {
    static final String PRODUCER_ANNOTATION = "javax.enterprise.inject.Produces";
    static final String ANY_QUALIFIER_ANNOTATION = "javax.enterprise.inject.Any";
    static final String DEFAULT_QUALIFIER_ANNOTATION = "javax.enterprise.inject.Default";
    static final String NEW_QUALIFIER_ANNOTATION = "javax.enterprise.inject.New";
    static final String NAMED_QUALIFIER_ANNOTATION = "javax.inject.Named";
    static final String INJECT_ANNOTATION = "javax.inject.Inject";
    static final String INSTANCE_INTERFACE = "javax.enterprise.inject.Instance";
    static final Logger LOGGER = Logger.getLogger(WebBeansModelProvider.class.getName());

    FieldInjectionPointLogic() {
    }

    public TypeMirror resolveType(String fqn, AnnotationModelHelper helper) {
        return helper.resolveType(fqn);
    }

    protected Result findVariableInjectable(VariableElement element, DeclaredType parentType, WebBeansModelImplementation modelImpl) {
        DeclaredType parent = parentType;
        try {
            parent = this.getParent(element, parentType, modelImpl);
        }
        catch (DefinitionError e) {
            TypeElement type = e.getElement();
            return new DefinitionErrorResult(element, parentType, NbBundle.getMessage(WebBeansModelProviderImpl.class, (String)"ERR_BadParent", (Object)element.getSimpleName(), (Object)(type != null ? type.toString() : null)));
        }
        TypeMirror type = modelImpl.getHelper().getCompilationController().getTypes().asMemberOf(parent, element);
        return this.getResult(this.doFindVariableInjectable(element, type, modelImpl, true), modelImpl);
    }

    protected DeclaredType getParent(Element element, DeclaredType parentType, WebBeansModelImplementation modelImpl) throws DefinitionError {
        DeclaredType parent = parentType;
        if (parent == null) {
            TypeElement type = modelImpl.getHelper().getCompilationController().getElementUtilities().enclosingTypeElement(element);
            boolean isDeclaredType = type.asType() instanceof DeclaredType;
            if (isDeclaredType) {
                parent = (DeclaredType)type.asType();
            }
            if (!isDeclaredType) {
                throw new DefinitionError(type);
            }
        }
        return parent;
    }

    protected Result getResult(Result result, WebBeansModelImplementation model) {
        this.filterBeans(result);
        result = this.filterEnabled(result, model);
        return result;
    }

    protected void filterBeans(Result result) {
        if (result instanceof ResultImpl) {
            BeansFilter filter = BeansFilter.get();
            filter.filter(((ResultImpl)result).getTypeElements());
        }
    }

    protected Result filterEnabled(Result result, WebBeansModelImplementation model) {
        if (result instanceof ResultImpl) {
            EnableBeansFilter filter = new EnableBeansFilter((ResultImpl)result, model);
            return filter.filter();
        }
        return result;
    }

    protected Result doFindVariableInjectable(VariableElement element, TypeMirror elementType, WebBeansModelImplementation modelImpl, boolean injectRequired) {
        Set<Element> productionElements;
        LinkedList<AnnotationMirror> quilifierAnnotations = new LinkedList<AnnotationMirror>();
        boolean anyQualifier = false;
        try {
            anyQualifier = this.hasAnyQualifier(element, modelImpl, injectRequired, false, quilifierAnnotations);
        }
        catch (InjectionPointDefinitionError e) {
            return new DefinitionErrorResult(element, elementType, e.getMessage());
        }
        boolean defaultQualifier = !anyQualifier && quilifierAnnotations.size() == 0;
        boolean newQualifier = false;
        String annotationName = null;
        HashSet<TypeElement> types = new HashSet<TypeElement>();
        if (quilifierAnnotations.size() == 1) {
            AnnotationMirror annotationMirror = (AnnotationMirror)quilifierAnnotations.get(0);
            DeclaredType type = annotationMirror.getAnnotationType();
            TypeElement annotationElement = (TypeElement)type.asElement();
            annotationName = annotationElement.getQualifiedName().toString();
            defaultQualifier = annotationElement.getQualifiedName().contentEquals(DEFAULT_QUALIFIER_ANNOTATION);
            newQualifier = annotationElement.getQualifiedName().contentEquals(NEW_QUALIFIER_ANNOTATION);
        }
        if (quilifierAnnotations.size() == 0 && anyQualifier || defaultQualifier) {
            LOGGER.fine("Found built-in binding " + annotationName);
            Set<TypeElement> assignableTypes = this.getAssignableTypes(element, elementType, modelImpl);
            if (defaultQualifier) {
                LOGGER.fine("@Default annotation requires test for implementors of varaible type");
                this.filterBindingsByDefault(assignableTypes, modelImpl);
            }
            types.addAll(assignableTypes);
        } else {
            if (newQualifier) {
                return this.handleNewQualifier(element, elementType, modelImpl, quilifierAnnotations);
            }
            Set<TypeElement> typesWithQualifiers = this.getBindingTypes(quilifierAnnotations, modelImpl);
            this.filterBindingsByMembers(quilifierAnnotations, typesWithQualifiers, modelImpl, TypeElement.class);
            this.filterBindingsByType(element, elementType, typesWithQualifiers, modelImpl);
            types.addAll(typesWithQualifiers);
        }
        if (quilifierAnnotations.size() == 0 && anyQualifier || defaultQualifier) {
            productionElements = this.getAllProductions(modelImpl);
            if (defaultQualifier) {
                this.filterDefaultProductions(productionElements, modelImpl);
            }
        } else {
            productionElements = this.getProductions(quilifierAnnotations, modelImpl);
            this.filterBindingsByMembers(quilifierAnnotations, productionElements, modelImpl, Element.class);
        }
        Map<Element, List<DeclaredType>> productions = this.filterProductionByType(element, elementType, productionElements, modelImpl);
        return this.createResult(element, elementType, types, productions, modelImpl);
    }

    protected boolean isQualifier(TypeElement element, AnnotationModelHelper helper, boolean event) {
        QualifierChecker checker = QualifierChecker.get(event);
        checker.init(element, helper);
        return checker.check();
    }

    protected Set<Element> getChildSpecializes(Element productionElement, WebBeansModelImplementation model) {
        TypeElement typeElement = model.getHelper().getCompilationController().getElementUtilities().enclosingTypeElement(productionElement);
        Set<TypeElement> implementors = FieldInjectionPointLogic.getImplementors(model, typeElement);
        implementors.remove(productionElement.getEnclosingElement());
        HashSet<Element> specializeElements = new HashSet<Element>();
        specializeElements.add(productionElement);
        for (TypeElement implementor : implementors) {
            this.inspectHierarchy(productionElement, implementor, specializeElements, model);
        }
        specializeElements.remove(productionElement);
        return specializeElements;
    }

    protected boolean hasAnyQualifier(VariableElement element, WebBeansModelImplementation modelImpl, boolean injectRequired, boolean eventQualifiers, List<AnnotationMirror> quilifierAnnotations) throws InjectionPointDefinitionError {
        List<? extends AnnotationMirror> annotations = modelImpl.getHelper().getCompilationController().getElements().getAllAnnotationMirrors(element);
        boolean isProducer = false;
        boolean anyQualifier = false;
        boolean hasInject = false;
        for (AnnotationMirror annotationMirror : annotations) {
            DeclaredType type = annotationMirror.getAnnotationType();
            TypeElement annotationElement = (TypeElement)type.asElement();
            if (ANY_QUALIFIER_ANNOTATION.equals(annotationElement.getQualifiedName().toString())) {
                anyQualifier = true;
            } else if (this.isQualifier(annotationElement, modelImpl.getHelper(), eventQualifiers)) {
                quilifierAnnotations.add(annotationMirror);
            }
            if (PRODUCER_ANNOTATION.contentEquals(annotationElement.getQualifiedName())) {
                isProducer = true;
                continue;
            }
            if (!INJECT_ANNOTATION.contentEquals(annotationElement.getQualifiedName())) continue;
            hasInject = true;
        }
        if (isProducer) {
            throw new InjectionPointDefinitionError(NbBundle.getMessage(WebBeansModelProviderImpl.class, (String)"ERR_ProducerInjectPoint", (Object)element.getSimpleName()));
        }
        if (injectRequired && !hasInject) {
            throw new InjectionPointDefinitionError(NbBundle.getMessage(WebBeansModelProviderImpl.class, (String)"ERR_NoInjectPoint", (Object)element.getSimpleName()));
        }
        return anyQualifier;
    }

    protected <T extends Element> void filterBindingsByMembers(List<AnnotationMirror> bindingAnnotations, Set<T> elementsWithBindings, WebBeansModelImplementation impl, Class<T> clazz) {
        MemberBindingFilter<T> filter = MemberBindingFilter.get(clazz);
        filter.init(bindingAnnotations, impl);
        filter.filter(elementsWithBindings);
    }

    static Set<TypeElement> getImplementors(WebBeansModelImplementation modelImpl, Element typeElement) {
        if (!(typeElement instanceof TypeElement)) {
            return Collections.emptySet();
        }
        HashSet<TypeElement> result = new HashSet<TypeElement>();
        result.add((TypeElement)typeElement);
        HashSet<TypeElement> toProcess = new HashSet<TypeElement>();
        toProcess.add((TypeElement)typeElement);
        while (toProcess.size() > 0) {
            TypeElement element = (TypeElement)toProcess.iterator().next();
            toProcess.remove(element);
            Set<TypeElement> set = FieldInjectionPointLogic.doGetImplementors(modelImpl, element);
            if (set.size() == 0) continue;
            result.addAll(set);
            for (TypeElement impl : set) {
                toProcess.add(impl);
            }
        }
        return result;
    }

    private Result createResult(VariableElement element, TypeMirror elementType, Set<TypeElement> types, Map<Element, List<DeclaredType>> productions, WebBeansModelImplementation model) {
        return new ResultImpl(element, elementType, types, productions, model.getHelper());
    }

    private Result handleNewQualifier(VariableElement element, TypeMirror elementType, WebBeansModelImplementation modelImpl, List<AnnotationMirror> quilifierAnnotations) {
        AnnotationMirror annotationMirror = quilifierAnnotations.get(0);
        AnnotationParser parser = AnnotationParser.create((AnnotationModelHelper)modelImpl.getHelper());
        parser.expectClass("value", null);
        ParseResult parseResult = parser.parse(annotationMirror);
        String clazz = (String)parseResult.get("value", String.class);
        TypeMirror typeMirror = clazz == null ? elementType : this.resolveType(clazz, modelImpl.getHelper());
        Element typeElement = null;
        if (typeMirror != null) {
            typeElement = modelImpl.getHelper().getCompilationController().getTypes().asElement(typeMirror);
        }
        if (typeElement != null && modelImpl.getHelper().getCompilationController().getTypes().isAssignable(typeMirror, elementType)) {
            return new ResultImpl(element, elementType, (TypeElement)typeElement, modelImpl.getHelper());
        }
        return new ResultImpl(element, elementType, modelImpl.getHelper());
    }

    private void inspectHierarchy(Element productionElement, TypeElement implementor, Set<Element> specializeElements, WebBeansModelImplementation model) {
        List<? extends Element> enclosedElements = implementor.getEnclosedElements();
        for (Element element : enclosedElements) {
            HashSet<Element> probableSpecializes;
            if (element.getKind() != ElementKind.METHOD || !productionElement.getSimpleName().contentEquals(element.getSimpleName()) || !this.collectSpecializes(productionElement, (ExecutableElement)element, model, probableSpecializes = new HashSet<Element>(), specializeElements)) continue;
            specializeElements.addAll(probableSpecializes);
            return;
        }
    }

    private boolean collectSpecializes(Element productionElement, ExecutableElement element, WebBeansModelImplementation model, Set<Element> probableSpecializes, Set<Element> specializeElements) {
        ElementUtilities elementUtilities = model.getHelper().getCompilationController().getElementUtilities();
        if (!elementUtilities.overridesMethod(element)) {
            return false;
        }
        ExecutableElement overriddenMethod = elementUtilities.getOverriddenMethod(element);
        if (overriddenMethod == null) {
            return false;
        }
        if (!AnnotationObjectProvider.hasSpecializes(element, model.getHelper())) {
            return false;
        }
        probableSpecializes.add(element);
        if (overriddenMethod.equals(productionElement) || specializeElements.contains(productionElement)) {
            return true;
        }
        return this.collectSpecializes(productionElement, overriddenMethod, model, probableSpecializes, specializeElements);
    }

    private static Set<TypeElement> doGetImplementors(WebBeansModelImplementation modelImpl, TypeElement typeElement) {
        HashSet<TypeElement> result = new HashSet<TypeElement>();
        ElementHandle handle = ElementHandle.create((Element)typeElement);
        Set handles = modelImpl.getHelper().getClasspathInfo().getClassIndex().getElements(handle, EnumSet.of(ClassIndex.SearchKind.IMPLEMENTORS), EnumSet.of(ClassIndex.SearchScope.SOURCE, ClassIndex.SearchScope.DEPENDENCIES));
        if (handles == null) {
            LOGGER.log(Level.WARNING, "ClassIndex.getElements() was interrupted");
            return Collections.emptySet();
        }
        for (ElementHandle elementHandle : handles) {
            LOGGER.log(Level.FINE, "found derived element {0}", elementHandle.getQualifiedName());
            TypeElement derivedElement = (TypeElement)elementHandle.resolve((CompilationInfo)modelImpl.getHelper().getCompilationController());
            if (derivedElement == null) continue;
            result.add(derivedElement);
        }
        return result;
    }

    private void filterDefaultProductions(Set<Element> productionElements, WebBeansModelImplementation model) {
        DefaultBindingTypeFilter<Element> filter = DefaultBindingTypeFilter.get(Element.class);
        filter.init(model);
        filter.filter(productionElements);
    }

    private Set<Element> getAllProductions(WebBeansModelImplementation model) {
        final HashSet<Element> result = new HashSet<Element>();
        try {
            model.getHelper().getAnnotationScanner().findAnnotations(PRODUCER_ANNOTATION, EnumSet.of(ElementKind.FIELD, ElementKind.METHOD), new AnnotationHandler(){

                public void handleAnnotation(TypeElement type, Element element, AnnotationMirror annotation) {
                    result.add(element);
                }
            });
        }
        catch (InterruptedException e) {
            LOGGER.warning("Finding annotation javax.enterprise.inject.Produces was interrupted");
        }
        return result;
    }

    private Map<Element, List<DeclaredType>> filterProductionByType(VariableElement element, TypeMirror elementType, Set<Element> productionElements, WebBeansModelImplementation model) {
        TypeProductionFilter filter = TypeProductionFilter.get();
        filter.init(elementType, element.getSimpleName().toString(), model);
        filter.filter(productionElements);
        return filter.getResult();
    }

    private void filterBindingsByDefault(Set<TypeElement> assignableTypes, WebBeansModelImplementation modelImpl) {
        DefaultBindingTypeFilter<TypeElement> filter = DefaultBindingTypeFilter.get(TypeElement.class);
        filter.init(modelImpl);
        filter.filter(assignableTypes);
    }

    private Set<TypeElement> getAssignableTypes(VariableElement element, TypeMirror elementType, WebBeansModelImplementation modelImpl) {
        if (elementType.getKind() != TypeKind.DECLARED) {
            return Collections.emptySet();
        }
        Element typeElement = ((DeclaredType)elementType).asElement();
        if (!(typeElement instanceof TypeElement)) {
            return Collections.emptySet();
        }
        if (((TypeElement)typeElement).getTypeParameters().size() != 0) {
            return this.getAssignables(modelImpl, elementType, (TypeElement)typeElement, element);
        }
        return FieldInjectionPointLogic.getImplementors(modelImpl, typeElement);
    }

    private Set<TypeElement> getAssignables(WebBeansModelImplementation model, TypeMirror elementType, TypeElement typeElement, VariableElement element) {
        Set<TypeElement> result = FieldInjectionPointLogic.getImplementors(model, typeElement);
        TypeBindingFilter filter = TypeBindingFilter.get();
        filter.init(elementType, element.getSimpleName().toString(), model);
        filter.filter(result);
        return result;
    }

    private void filterBindingsByType(VariableElement element, TypeMirror elementType, Set<TypeElement> typesWithBindings, WebBeansModelImplementation modelImpl) {
        TypeBindingFilter filter = TypeBindingFilter.get();
        filter.init(elementType, element.getSimpleName().toString(), modelImpl);
        filter.filter(typesWithBindings);
    }

    private Set<Element> getProductions(List<AnnotationMirror> qualifierAnnotations, WebBeansModelImplementation model) {
        ArrayList<Set<Element>> bindingCollections = new ArrayList<Set<Element>>(qualifierAnnotations.size());
        boolean hasDefault = model.getHelper().getAnnotationsByType(qualifierAnnotations).get(DEFAULT_QUALIFIER_ANNOTATION) != null;
        HashSet<Element> currentBindings = new HashSet<Element>();
        for (AnnotationMirror annotationMirror : qualifierAnnotations) {
            DeclaredType type = annotationMirror.getAnnotationType();
            TypeElement annotationElement = (TypeElement)type.asElement();
            String annotationFQN = annotationElement.getQualifiedName().toString();
            this.findAnnotation(model, bindingCollections, annotationFQN, hasDefault, currentBindings);
        }
        if (hasDefault) {
            bindingCollections.add(currentBindings);
        }
        Set result = null;
        for (int i = 0; i < bindingCollections.size(); ++i) {
            Set list = (Set)bindingCollections.get(i);
            if (i == 0) {
                result = list;
                continue;
            }
            result.retainAll(list);
        }
        if (result == null) {
            return Collections.emptySet();
        }
        return result;
    }

    private void findAnnotation(final WebBeansModelImplementation model, final List<Set<Element>> bindingCollections, final String annotationFQN, boolean hasCurrent, final Set<Element> currentBindings) {
        try {
            final HashSet bindings = new HashSet();
            model.getHelper().getAnnotationScanner().findAnnotations(annotationFQN, EnumSet.of(ElementKind.FIELD, ElementKind.METHOD), new AnnotationHandler(){

                public void handleAnnotation(TypeElement type, Element element, AnnotationMirror annotation) {
                    if (AnnotationObjectProvider.hasAnnotation(element, FieldInjectionPointLogic.PRODUCER_ANNOTATION, model.getHelper())) {
                        bindings.add(element);
                        bindings.addAll(FieldInjectionPointLogic.this.getChildSpecializes(element, model));
                        if (annotationFQN.contentEquals(FieldInjectionPointLogic.DEFAULT_QUALIFIER_ANNOTATION)) {
                            currentBindings.addAll(bindings);
                        } else {
                            bindingCollections.add(bindings);
                        }
                    }
                }
            });
            if (hasCurrent) {
                for (Element element : bindings) {
                    if (!AnnotationObjectProvider.checkDefault(element, model.getHelper())) continue;
                    currentBindings.add(element);
                }
            }
        }
        catch (InterruptedException e) {
            LOGGER.warning("Finding annotation " + annotationFQN + " was interrupted");
        }
    }

    private Set<TypeElement> getBindingTypes(List<AnnotationMirror> qualifierAnnotations, WebBeansModelImplementation modelImpl) {
        ArrayList bindingCollections = new ArrayList(qualifierAnnotations.size());
        boolean hasDefault = modelImpl.getHelper().getAnnotationsByType(qualifierAnnotations).get(DEFAULT_QUALIFIER_ANNOTATION) != null;
        HashSet<BindingQualifier> defaultQualifiers = new HashSet<BindingQualifier>();
        for (AnnotationMirror annotationMirror : qualifierAnnotations) {
            DeclaredType type = annotationMirror.getAnnotationType();
            TypeElement annotationElement = (TypeElement)type.asElement();
            String annotationFQN = annotationElement.getQualifiedName().toString();
            PersistentObjectManager<BindingQualifier> manager = modelImpl.getManager(annotationFQN);
            Collection bindings = manager.getObjects();
            if (annotationFQN.contentEquals(DEFAULT_QUALIFIER_ANNOTATION)) {
                defaultQualifiers.addAll(bindings);
                continue;
            }
            bindingCollections.add(new HashSet(bindings));
            if (!hasDefault) continue;
            for (BindingQualifier binding : bindings) {
                if (!AnnotationObjectProvider.checkDefault(binding.getTypeElement(), modelImpl.getHelper())) continue;
                defaultQualifiers.add(new BindingQualifier(modelImpl.getHelper(), binding.getTypeElement(), DEFAULT_QUALIFIER_ANNOTATION));
            }
        }
        if (hasDefault) {
            bindingCollections.add(defaultQualifiers);
        }
        Set result = null;
        for (int i = 0; i < bindingCollections.size(); ++i) {
            Set set = (Set)bindingCollections.get(i);
            if (i == 0) {
                result = set;
                continue;
            }
            result.retainAll(set);
        }
        if (result == null) {
            return Collections.emptySet();
        }
        HashSet<TypeElement> set = new HashSet<TypeElement>();
        for (BindingQualifier binding : result) {
            set.add(binding.getTypeElement());
        }
        return set;
    }

    protected static class DefinitionError
    extends Exception {
        private static final long serialVersionUID = 8538541504206293629L;
        private TypeElement myElement;

        protected DefinitionError(TypeElement element) {
            this.myElement = element;
        }

        public TypeElement getElement() {
            return this.myElement;
        }
    }

    protected static class InjectionPointDefinitionError
    extends Exception {
        private static final long serialVersionUID = -1568276063434281036L;

        private InjectionPointDefinitionError(String msg) {
            super(msg);
        }
    }
}

