/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.impl.model;

import java.util.Iterator;
import java.util.List;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ExecutableType;
import javax.lang.model.type.TypeMirror;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.modules.web.beans.api.model.AbstractModelImplementation;
import org.netbeans.modules.web.beans.api.model.InjectionPointDefinitionError;
import org.netbeans.modules.web.beans.api.model.Result;
import org.netbeans.modules.web.beans.impl.model.AnnotationObjectProvider;
import org.netbeans.modules.web.beans.impl.model.FieldInjectionPointLogic;
import org.netbeans.modules.web.beans.impl.model.WebBeansModelImplementation;
import org.netbeans.modules.web.beans.impl.model.WebBeansModelProviderImpl;
import org.netbeans.modules.web.beans.impl.model.results.DefinitionErrorResult;
import org.netbeans.modules.web.beans.impl.model.results.ResultImpl;
import org.netbeans.modules.web.beans.model.spi.WebBeansModelProvider;
import org.openide.util.NbBundle;

abstract class ParameterInjectionPointLogic
extends FieldInjectionPointLogic
implements WebBeansModelProvider {
    static final String DISPOSES_ANNOTATION = "javax.enterprise.inject.Disposes";
    static final String OBSERVES_ANNOTATION = "javax.enterprise.event.Observes";

    ParameterInjectionPointLogic() {
    }

    protected Result findParameterInjectable(VariableElement element, DeclaredType parentType, WebBeansModelImplementation model) {
        DeclaredType parent = parentType;
        try {
            parent = this.getParent(element, parentType, model);
        }
        catch (FieldInjectionPointLogic.DefinitionError e) {
            TypeElement type = e.getElement();
            return new DefinitionErrorResult(element, parentType, NbBundle.getMessage(WebBeansModelProviderImpl.class, (String)"ERR_BadParent", (Object)element.getSimpleName(), (Object)(type != null ? type.toString() : null)));
        }
        ExecutableElement parentMethod = (ExecutableElement)element.getEnclosingElement();
        ExecutableType methodType = (ExecutableType)model.getHelper().getCompilationController().getTypes().asMemberOf(parent, parentMethod);
        List<? extends TypeMirror> parameterTypes = methodType.getParameterTypes();
        boolean isInjectionPoint = false;
        List<? extends VariableElement> parameters = parentMethod.getParameters();
        int index = 0;
        for (int i = 0; i < parameters.size(); ++i) {
            VariableElement variableElement = parameters.get(i);
            if (variableElement.equals(element)) {
                index = i;
                continue;
            }
            if (!AnnotationObjectProvider.hasAnnotation(variableElement, DISPOSES_ANNOTATION, model.getHelper()) && !AnnotationObjectProvider.hasAnnotation(variableElement, OBSERVES_ANNOTATION, model.getHelper())) continue;
            isInjectionPoint = true;
        }
        TypeMirror elementType = parameterTypes.get(index);
        Result result = null;
        boolean disposes = AnnotationObjectProvider.hasAnnotation(element, DISPOSES_ANNOTATION, model.getHelper());
        boolean observes = AnnotationObjectProvider.hasAnnotation(element, OBSERVES_ANNOTATION, model.getHelper());
        if (isInjectionPoint || AnnotationObjectProvider.hasAnnotation(parentMethod, "javax.inject.Inject", model.getHelper()) || AnnotationObjectProvider.hasAnnotation(parentMethod, "javax.enterprise.inject.Produces", model.getHelper()) || disposes || observes) {
            result = this.doFindVariableInjectable(element, elementType, model, false);
            isInjectionPoint = true;
        }
        if (disposes) {
            if (result instanceof ResultImpl) {
                ((ResultImpl)result).getTypeElements().clear();
                Set<Element> productions = ((ResultImpl)result).getProductions();
                TypeElement enclosingTypeElement = model.getHelper().getCompilationController().getElementUtilities().enclosingTypeElement((Element)element);
                Iterator<Element> iterator = productions.iterator();
                while (iterator.hasNext()) {
                    Element injectable = iterator.next();
                    if (injectable instanceof ExecutableElement && model.getHelper().getCompilationController().getElementUtilities().isMemberOf(injectable, enclosingTypeElement)) continue;
                    iterator.remove();
                }
            } else {
                return result;
            }
        }
        if (isInjectionPoint) {
            return this.getResult(result, model);
        }
        return new DefinitionErrorResult(element, elementType, NbBundle.getMessage(WebBeansModelProviderImpl.class, (String)"ERR_NoInjectPoint", (Object)element.getSimpleName()));
    }

    @Override
    public Result lookupInjectables(VariableElement element, DeclaredType parentType, AbstractModelImplementation modelImpl) {
        WebBeansModelImplementation impl = WebBeansModelProviderImpl.getImplementation(modelImpl);
        DeclaredType parent = parentType;
        try {
            parent = this.getParent(element, parentType, impl);
        }
        catch (FieldInjectionPointLogic.DefinitionError e) {
            TypeElement type = e.getElement();
            return new DefinitionErrorResult(element, parentType, NbBundle.getMessage(WebBeansModelProviderImpl.class, (String)"ERR_BadParent", (Object)element.getSimpleName(), (Object)(type != null ? type.toString() : null)));
        }
        TypeMirror elementType = this.getParameterType(element, parent, impl.getHelper().getCompilationController(), "javax.enterprise.inject.Instance");
        Result result = this.doFindVariableInjectable(element, elementType, impl, true);
        return null;
    }

    @Override
    public boolean isDynamicInjectionPoint(VariableElement element, AbstractModelImplementation modelImpl) {
        WebBeansModelImplementation impl = WebBeansModelProviderImpl.getImplementation(modelImpl);
        TypeMirror type = this.getParameterType(element, null, impl.getHelper().getCompilationController(), "javax.enterprise.inject.Instance");
        if (type != null) {
            try {
                return this.isInjectionPoint(element, impl);
            }
            catch (InjectionPointDefinitionError e) {
                return false;
            }
        }
        return false;
    }

    protected TypeMirror getParameterType(Element element, DeclaredType parentType, CompilationController compilationController, String ... interfaceFqns) {
        DeclaredType declaredType;
        Element elementDeclaredType;
        TypeMirror parameterType = null;
        TypeMirror elementType = null;
        elementType = parentType == null ? element.asType() : compilationController.getTypes().asMemberOf(parentType, element);
        if (elementType instanceof DeclaredType && (elementDeclaredType = (declaredType = (DeclaredType)elementType).asElement()).getKind() == ElementKind.INTERFACE) {
            String typeFqn = ((TypeElement)elementDeclaredType).getQualifiedName().toString();
            for (String interfaceFqn : interfaceFqns) {
                List<? extends TypeMirror> typeArguments;
                if (!interfaceFqn.equals(typeFqn) || (typeArguments = declaredType.getTypeArguments()).size() <= 0) continue;
                parameterType = typeArguments.get(0);
            }
        }
        return parameterType;
    }
}

