/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.impl.model;

import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.TypeElement;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.AnnotationParser;

public abstract class RuntimeAnnotationChecker {
    protected static final String VALUE = "value";
    private AnnotationModelHelper myHelper;
    private TypeElement myElement;

    public void init(TypeElement element, AnnotationModelHelper helper) {
        this.myHelper = helper;
        this.myElement = element;
    }

    public boolean check() {
        List<? extends AnnotationMirror> annotations = this.getElement().getAnnotationMirrors();
        boolean hasAnnotation = this.getHelper().hasAnnotation(annotations, this.getAnnotation());
        boolean hasRequiredRetention = this.getHelper().hasAnnotation(annotations, Retention.class.getCanonicalName());
        boolean hasRequiredTarget = this.getHelper().hasAnnotation(annotations, Target.class.getCanonicalName());
        if (!hasAnnotation) {
            return false;
        }
        if (!hasRequiredRetention) {
            this.getLogger().log(Level.WARNING, "Annotation " + this.getElement().getQualifiedName() + "declared as " + this.getAnnotation() + " but has no Retention");
            return false;
        }
        if (!hasRequiredTarget) {
            this.getLogger().log(Level.WARNING, "Annotation " + this.getElement().getQualifiedName() + "declared as " + this.getAnnotation() + " but has no Target");
            return false;
        }
        AnnotationParser parser = AnnotationParser.create((AnnotationModelHelper)this.getHelper());
        parser.expectEnumConstant(VALUE, this.getHelper().resolveType(RetentionPolicy.class.getCanonicalName()), null);
        Map types = this.getHelper().getAnnotationsByType(annotations);
        AnnotationMirror retention = (AnnotationMirror)types.get(Retention.class.getCanonicalName());
        String retentionPolicy = (String)parser.parse(retention).get(VALUE, String.class);
        hasRequiredRetention = retentionPolicy.equals(RetentionPolicy.RUNTIME.toString());
        if (!hasRequiredRetention) {
            this.getLogger().log(Level.WARNING, "Annotation " + this.getElement().getQualifiedName() + " declared as " + this.getAnnotation() + " but has wrong retention policy." + " Correct retention policy is " + RetentionPolicy.RUNTIME.toString());
            return false;
        }
        hasRequiredTarget = this.checkTarget(types);
        return hasRequiredTarget;
    }

    protected abstract Logger getLogger();

    protected abstract String getAnnotation();

    protected abstract boolean checkTarget(Map<String, ? extends AnnotationMirror> var1);

    protected TypeElement getElement() {
        return this.myElement;
    }

    protected AnnotationModelHelper getHelper() {
        return this.myHelper;
    }
}

