/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.impl.model;

import java.lang.annotation.ElementType;
import java.lang.annotation.Target;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.TypeElement;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.AnnotationModelHelper;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.AnnotationParser;
import org.netbeans.modules.j2ee.metadata.model.api.support.annotation.parser.ArrayValueHandler;
import org.netbeans.modules.web.beans.impl.model.RuntimeAnnotationChecker;

public class StereotypeChecker
extends RuntimeAnnotationChecker {
    static final String STEREOTYPE = "javax.enterprise.inject.Stereotype";

    public StereotypeChecker(AnnotationModelHelper helper) {
        this.init(null, helper);
    }

    public void init(TypeElement element) {
        assert (this.getElement() == null);
        super.init(element, this.getHelper());
    }

    public void clean() {
        this.init(null, this.getHelper());
    }

    @Override
    protected boolean checkTarget(Map<String, ? extends AnnotationMirror> types) {
        boolean hasRequiredTarget = false;
        AnnotationParser parser = AnnotationParser.create((AnnotationModelHelper)this.getHelper());
        final HashSet elementTypes = new HashSet();
        parser.expectEnumConstantArray("value", this.getHelper().resolveType(ElementType.class.getCanonicalName()), new ArrayValueHandler(){

            public Object handleArray(List<AnnotationValue> arrayMembers) {
                for (AnnotationValue arrayMember : arrayMembers) {
                    String value = arrayMember.getValue().toString();
                    elementTypes.add(value);
                }
                return null;
            }
        }, null);
        parser.parse(types.get(Target.class.getCanonicalName()));
        if (elementTypes.contains(ElementType.METHOD.toString()) && elementTypes.contains(ElementType.FIELD.toString()) && elementTypes.contains(ElementType.TYPE.toString()) && elementTypes.size() == 3) {
            hasRequiredTarget = true;
        } else if (elementTypes.size() == 2 && elementTypes.contains(ElementType.METHOD.toString()) && elementTypes.contains(ElementType.FIELD.toString())) {
            hasRequiredTarget = true;
        } else if (elementTypes.size() == 1) {
            hasRequiredTarget = elementTypes.contains(ElementType.METHOD.toString()) || elementTypes.contains(ElementType.FIELD.toString()) || elementTypes.contains(ElementType.TYPE.toString());
        } else {
            this.getLogger().log(Level.WARNING, "Annotation " + this.getElement().getQualifiedName() + "declared as Qualifier but has wrong target values." + " Correct target values are {METHOD, FIELD, TYPE} or" + "{METHOD, FIELD} or TYPE or METHOD or FIELD");
        }
        return hasRequiredTarget;
    }

    @Override
    protected String getAnnotation() {
        return STEREOTYPE;
    }

    @Override
    protected Logger getLogger() {
        return Logger.getLogger(StereotypeChecker.class.getName());
    }
}

