/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.impl.model;

import java.util.Iterator;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.ReferenceType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import org.netbeans.modules.web.beans.impl.model.AssignabilityChecker;
import org.netbeans.modules.web.beans.impl.model.Filter;
import org.netbeans.modules.web.beans.impl.model.WebBeansModelImplementation;
import org.netbeans.modules.web.beans.impl.model.WebBeansModelProviderImpl;

class TypeBindingFilter
extends Filter<TypeElement> {
    private TypeMirror myVarType;
    private WebBeansModelImplementation myImpl;
    private String mySimpleName;
    private boolean isGeneric;

    TypeBindingFilter() {
    }

    static TypeBindingFilter get() {
        return new TypeBindingFilter();
    }

    void init(TypeMirror varType, String name, WebBeansModelImplementation modelImpl) {
        this.mySimpleName = name;
        this.myImpl = modelImpl;
        this.myVarType = varType;
        this.setIsGeneric();
    }

    @Override
    void filter(Set<TypeElement> set) {
        super.filter(set);
        if (set.size() == 0) {
            return;
        }
        TypeKind kind = this.getType().getKind();
        if (kind == TypeKind.DECLARED) {
            this.filterDeclaredTypes(set);
        } else if (kind.isPrimitive()) {
            WebBeansModelProviderImpl.LOGGER.fine("Variable element " + this.mySimpleName + " " + "couldn't have type as eligible for inection becuase its " + "type is primitive. It is unproxyable bean types");
            set.clear();
        } else if (kind == TypeKind.ARRAY) {
            WebBeansModelProviderImpl.LOGGER.fine("Variable element " + this.mySimpleName + " " + "couldn't have type as eligible for inection becuase its " + "type has array type. It is unproxyable bean types");
            set.clear();
        }
    }

    boolean isAssignable(TypeMirror type) {
        if (!this.isGeneric && this.getImplementation().getHelper().getCompilationController().getTypes().isAssignable(type, this.getType())) {
            WebBeansModelProviderImpl.LOGGER.fine("Found type  " + type + " for variable element " + this.mySimpleName + " by typesafe resolution");
            return true;
        }
        if (this.checkAssignability(type)) {
            WebBeansModelProviderImpl.LOGGER.fine("Probably found castable parametrizied or raw type " + type + " for variable element " + this.mySimpleName + " by typesafe resolution");
            return true;
        }
        return false;
    }

    private void setIsGeneric() {
        Element typeElement = this.getImplementation().getHelper().getCompilationController().getTypes().asElement(this.getType());
        this.isGeneric = typeElement instanceof TypeElement && ((TypeElement)typeElement).getTypeParameters().size() != 0;
    }

    private void filterDeclaredTypes(Set<TypeElement> set) {
        Iterator<TypeElement> iterator = set.iterator();
        while (iterator.hasNext()) {
            TypeElement type = iterator.next();
            if (this.isAssignable(type.asType())) continue;
            iterator.remove();
        }
    }

    private boolean checkAssignability(TypeMirror type) {
        if (!(type instanceof ReferenceType)) {
            return false;
        }
        AssignabilityChecker checker = AssignabilityChecker.get(false);
        checker.init((DeclaredType)this.getType(), (ReferenceType)type, this.getImplementation());
        return checker.check();
    }

    private TypeMirror getType() {
        return this.myVarType;
    }

    private WebBeansModelImplementation getImplementation() {
        return this.myImpl;
    }
}

