/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.beans.navigation.actions;

import java.util.List;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.VariableElement;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.modules.j2ee.metadata.model.api.MetadataModel;
import org.netbeans.modules.web.beans.api.model.WebBeansModel;
import org.netbeans.modules.web.beans.navigation.ObserversModel;
import org.netbeans.modules.web.beans.navigation.actions.AbstractObserversAction;
import org.netbeans.modules.web.beans.navigation.actions.GoToInjectableAtCaretAction;
import org.netbeans.modules.web.beans.navigation.actions.WebBeansActionHelper;
import org.openide.awt.StatusDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class InspectObserversAtCaretAction
extends AbstractObserversAction {
    private static final long serialVersionUID = 3982229267831538567L;
    private static final String INSPECT_OBSERVERS_AT_CARET = "inspect-observers-at-caret";
    private static final String INSPECT_OBSERVERS_AT_CARET_POPUP = "inspect-observers-at-caret-popup";

    public InspectObserversAtCaretAction() {
        super(NbBundle.getMessage(InspectObserversAtCaretAction.class, (String)INSPECT_OBSERVERS_AT_CARET));
    }

    @Override
    protected void modelAcessAction(WebBeansModel model, final MetadataModel<WebBeansModel> metaModel, final Object[] variable, JTextComponent component, FileObject fileObject) {
        VariableElement var = WebBeansActionHelper.findVariable(model, variable);
        if (var == null) {
            return;
        }
        if (!model.isEventInjectionPoint(var)) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(GoToInjectableAtCaretAction.class, (String)"LBL_NotEventInjectionPoint"), 700);
            return;
        }
        final List<ExecutableElement> observers = model.getObservers(var, null);
        if (observers.size() == 0) {
            StatusDisplayer.getDefault().setStatusText(NbBundle.getMessage(GoToInjectableAtCaretAction.class, (String)"LBL_ObserversNotFound"), 700);
            return;
        }
        CompilationController controller = model.getCompilationController();
        final ObserversModel uiModel = new ObserversModel(observers, controller, metaModel);
        final String name = var.getSimpleName().toString();
        if (SwingUtilities.isEventDispatchThread()) {
            WebBeansActionHelper.showObserversDialog(observers, metaModel, model, variable, uiModel, name);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    WebBeansActionHelper.showObserversDialog(observers, (MetadataModel<WebBeansModel>)metaModel, null, variable, uiModel, name);
                }
            });
        }
    }

    @Override
    protected String getActionCommand() {
        return INSPECT_OBSERVERS_AT_CARET;
    }

    @Override
    protected String getPopupMenuKey() {
        return INSPECT_OBSERVERS_AT_CARET_POPUP;
    }
}

