/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.refactoring.ui.tree;

import java.util.Map;
import java.util.WeakHashMap;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.refactoring.support.ElementGrip;
import org.netbeans.modules.cnd.refactoring.support.ElementGripFactory;
import org.netbeans.modules.cnd.refactoring.ui.tree.ElementGripTreeElement;
import org.netbeans.modules.cnd.refactoring.ui.tree.FileTreeElement;
import org.netbeans.modules.cnd.refactoring.ui.tree.ParentTreeElement;
import org.netbeans.modules.cnd.refactoring.ui.tree.ProjectTreeElement;
import org.netbeans.modules.cnd.refactoring.ui.tree.RefactoringTreeElement;
import org.netbeans.modules.refactoring.api.RefactoringElement;
import org.netbeans.modules.refactoring.spi.ui.TreeElement;
import org.netbeans.modules.refactoring.spi.ui.TreeElementFactoryImplementation;
import org.openide.filesystems.FileObject;
import org.openide.util.Lookup;

public class TreeElementFactoryImpl
implements TreeElementFactoryImplementation {
    public Map<Object, TreeElement> map = new WeakHashMap<Object, TreeElement>();

    public TreeElement getTreeElement(Object o) {
        FileObject fo;
        CsmFile csmFile;
        TreeElement result = this.map.get(o);
        if (result != null) {
            return result;
        }
        if (o instanceof RefactoringElement) {
            Lookup lkp = ((RefactoringElement)o).getLookup();
            CsmOffsetable csmObject = (CsmOffsetable)lkp.lookup(CsmOffsetable.class);
            if (csmObject != null) {
                result = new RefactoringTreeElement((RefactoringElement)o);
            } else {
                CsmObject obj = (CsmObject)((RefactoringElement)o).getLookup().lookup(CsmObject.class);
                if (obj != null) {
                    System.err.println("unhandled CsmObject: " + obj);
                }
            }
        } else if (o instanceof ElementGrip) {
            result = new ElementGripTreeElement((ElementGrip)o);
        } else if (CsmKindUtilities.isProject((Object)o)) {
            result = new ProjectTreeElement((CsmProject)o);
        } else if (CsmKindUtilities.isCsmObject((Object)o)) {
            CsmObject csm = (CsmObject)o;
            if (CsmKindUtilities.isFile((CsmObject)csm)) {
                FileObject fo2 = CsmUtilities.getFileObject((CsmFile)((CsmFile)o));
                result = new FileTreeElement(fo2, (CsmFile)o);
            } else {
                result = new ParentTreeElement(csm);
            }
        } else if (o instanceof FileObject && (csmFile = CsmUtilities.getCsmFile((FileObject)(fo = (FileObject)o), (boolean)false, (boolean)false)) != null) {
            result = new FileTreeElement(fo, csmFile);
        }
        if (result != null) {
            this.map.put(o, result);
        }
        return result;
    }

    public void cleanUp() {
        this.map.clear();
        ElementGripFactory.getDefault().cleanUp();
    }
}

