/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.screen.actions;

import java.awt.event.ActionEvent;
import javax.swing.SwingUtilities;
import org.netbeans.modules.vmd.api.io.ActiveViewSupport;
import org.netbeans.modules.vmd.api.io.DataObjectContext;
import org.netbeans.modules.vmd.api.io.ProjectUtils;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.common.ActiveDocumentSupport;
import org.netbeans.modules.vmd.api.screen.actions.EditDependencyPresenter;
import org.netbeans.modules.vmd.api.screen.editor.EditedScreenSupport;
import org.netbeans.modules.vmd.screen.ScreenEditorView;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.SystemAction;

public class DesignerEditAction
extends SystemAction {
    private boolean enabled;

    public void actionPerformed(ActionEvent e) {
        ProjectUtils.requestVisibility((DataObjectContext)ActiveViewSupport.getDefault().getActiveView().getContext(), (String)ScreenEditorView.SCREEN_EDITOR_VIEW_DISPLAY_NAME);
        this.requestComponentVisibility();
    }

    public String getName() {
        return NbBundle.getMessage(DesignerEditAction.class, (String)"NAME_EditAction");
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    public boolean isEnabled() {
        final DesignDocument document = ActiveDocumentSupport.getDefault().getActiveDocument();
        this.enabled = false;
        if (document == null) {
            return this.enabled;
        }
        document.getTransactionManager().readAccess(new Runnable(){

            @Override
            public void run() {
                DesignComponent component = DesignerEditAction.this.getSelectedComponent(document);
                if (component == null) {
                    return;
                }
                EditDependencyPresenter presenter = (EditDependencyPresenter)component.getPresenter(EditDependencyPresenter.class);
                if (presenter == null) {
                    return;
                }
                DesignerEditAction.this.enabled = presenter.isComponentEditable();
            }
        });
        return this.enabled;
    }

    protected void requestComponentVisibility() {
        final DesignDocument document = ActiveDocumentSupport.getDefault().getActiveDocument();
        document.getTransactionManager().readAccess(new Runnable(){

            @Override
            public void run() {
                final DesignComponent component = DesignerEditAction.this.getSelectedComponent(document);
                if (component != null) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            document.getTransactionManager().readAccess(new Runnable(){

                                @Override
                                public void run() {
                                    EditedScreenSupport.getSupportForDocument(document).setEditedScreenComponentID(component.getComponentID());
                                }
                            });
                        }
                    });
                }
            }
        });
    }

    protected DesignComponent getSelectedComponent(DesignDocument document) {
        if (document.getSelectedComponents().size() != 1) {
            return null;
        }
        DesignComponent component = (DesignComponent)document.getSelectedComponents().iterator().next();
        return component;
    }
}

