/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.navigation.hierarchy;

import java.util.Collections;
import java.util.Iterator;
import javax.swing.JEditorPane;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmClassifier;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmNamespaceDefinition;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmScopeElement;
import org.netbeans.modules.cnd.api.model.CsmType;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.model.xref.CsmReferenceResolver;
import org.netbeans.modules.cnd.modelutil.CsmUtilities;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.openide.cookies.EditorCookie;
import org.openide.nodes.Node;

public class ContextUtils {
    public static final boolean USE_REFERENCE_RESOLVER = CndUtils.getBoolean((String)"hierarchy.use.reference", (boolean)true);

    private ContextUtils() {
    }

    public static CsmFile findFile(Node[] activatedNodes) {
        if (activatedNodes != null && activatedNodes.length > 0) {
            CsmInclude incl;
            CsmFile file;
            CsmReference ref;
            if (USE_REFERENCE_RESOLVER && (ref = ContextUtils.findReference(activatedNodes[0])) != null && ref.getClosestTopLevelObject() != null && CsmKindUtilities.isInclude((CsmObject)ref.getClosestTopLevelObject()) && (file = (incl = (CsmInclude)ref.getClosestTopLevelObject()).getIncludeFile()) != null) {
                return file;
            }
            return ContextUtils.findFile(activatedNodes[0]);
        }
        return null;
    }

    public static CsmFile findFile(Node activatedNode) {
        EditorCookie c = (EditorCookie)activatedNode.getCookie(EditorCookie.class);
        if (c != null && CsmUtilities.findRecentEditorPaneInEQ((EditorCookie)c) != null) {
            return CsmUtilities.getCsmFile((Node)activatedNode, (boolean)false);
        }
        return null;
    }

    public static CsmClass getContextClass(Node[] activatedNodes) {
        CsmReference ref;
        CsmDeclaration decl = null;
        if (USE_REFERENCE_RESOLVER && ContextUtils.isSupportedReference(ref = ContextUtils.findReference(activatedNodes[0]))) {
            decl = ref.getReferencedObject();
            if (CsmKindUtilities.isClass((CsmObject)decl)) {
                return (CsmClass)decl;
            }
            if (CsmKindUtilities.isVariable((CsmObject)decl)) {
                CsmClassifier cls;
                CsmVariable v = (CsmVariable)decl;
                CsmType type = v.getType();
                CsmClassifier csmClassifier = cls = type == null ? null : type.getClassifier();
                if (CsmKindUtilities.isClass((CsmObject)cls)) {
                    return (CsmClass)cls;
                }
            }
        }
        if (CsmKindUtilities.isClass((CsmObject)(decl = ContextUtils.findDeclaration(activatedNodes[0])))) {
            return (CsmClass)decl;
        }
        return null;
    }

    public static boolean isSupportedReference(CsmReference ref) {
        if (ref != null && ref.getClosestTopLevelObject() != null) {
            return !CsmKindUtilities.isMacro((CsmObject)ref.getClosestTopLevelObject()) && !CsmKindUtilities.isInclude((CsmObject)ref.getClosestTopLevelObject());
        }
        return false;
    }

    public static CsmReference findReference(Node activatedNode) {
        return CsmReferenceResolver.getDefault().findReference(activatedNode);
    }

    public static CsmDeclaration findDeclaration(Node activatedNode) {
        JEditorPane pane;
        EditorCookie c = (EditorCookie)activatedNode.getCookie(EditorCookie.class);
        if (c != null && (pane = CsmUtilities.findRecentEditorPaneInEQ((EditorCookie)c)) != null) {
            int offset = pane.getCaret().getDot();
            CsmFile file = CsmUtilities.getCsmFile((Node)activatedNode, (boolean)false);
            if (file != null) {
                return ContextUtils.findInnerFileDeclaration(file, offset);
            }
        }
        return null;
    }

    public static CsmDeclaration findInnerFileDeclaration(CsmFile file, int offset) {
        CsmSelect.CsmFilter offsetFilter = CsmSelect.getFilterBuilder().createOffsetFilter(offset);
        Iterator<? extends CsmObject> fileElements = ContextUtils.getInnerObjectsIterator(offsetFilter, (CsmScope)file);
        CsmDeclaration innermostDecl = (CsmDeclaration)(fileElements.hasNext() ? fileElements.next() : null);
        if (innermostDecl != null && CsmKindUtilities.isScope((CsmObject)innermostDecl)) {
            CsmDeclaration inner = ContextUtils.findInnerDeclaration(offsetFilter, (CsmScope)innermostDecl);
            innermostDecl = inner != null ? inner : innermostDecl;
        }
        return innermostDecl;
    }

    private static Iterator<? extends CsmObject> getInnerObjectsIterator(CsmSelect.CsmFilter offsetFilter, CsmScope scope) {
        Iterator out = Collections.emptyList().iterator();
        out = CsmKindUtilities.isFile((CsmObject)scope) ? CsmSelect.getDeclarations((CsmFile)((CsmFile)scope), (CsmSelect.CsmFilter)offsetFilter) : (CsmKindUtilities.isNamespaceDefinition((CsmObject)scope) ? CsmSelect.getDeclarations((CsmNamespaceDefinition)((CsmNamespaceDefinition)scope), (CsmSelect.CsmFilter)offsetFilter) : (CsmKindUtilities.isClass((CsmObject)scope) ? CsmSelect.getClassMembers((CsmClass)((CsmClass)scope), (CsmSelect.CsmFilter)offsetFilter) : scope.getScopeElements().iterator()));
        return out;
    }

    private static CsmDeclaration findInnerDeclaration(CsmSelect.CsmFilter offsetFilter, CsmScope scope) {
        CsmObject decl;
        Iterator<? extends CsmObject> it = ContextUtils.getInnerObjectsIterator(offsetFilter, scope);
        if (it != null && it.hasNext() && CsmKindUtilities.isScope((CsmObject)(decl = it.next()))) {
            CsmDeclaration innerDecl = ContextUtils.findInnerDeclaration(offsetFilter, (CsmScope)decl);
            if (CsmKindUtilities.isClass((CsmObject)innerDecl)) {
                return (CsmClass)innerDecl;
            }
            if (CsmKindUtilities.isClass((CsmObject)decl)) {
                return (CsmClass)decl;
            }
        }
        return null;
    }

    private static boolean isInObject(CsmObject obj, int offset) {
        if (!CsmKindUtilities.isOffsetable((Object)obj)) {
            return false;
        }
        CsmOffsetable offs = (CsmOffsetable)obj;
        return offs.getStartOffset() <= offset && offset <= offs.getEndOffset();
    }

    public static CsmScope findScope(Node activatedNode) {
        JEditorPane pane;
        EditorCookie c = (EditorCookie)activatedNode.getCookie(EditorCookie.class);
        if (c != null && (pane = CsmUtilities.findRecentEditorPaneInEQ((EditorCookie)c)) != null) {
            int offset = pane.getCaret().getDot();
            CsmFile file = CsmUtilities.getCsmFile((Node)activatedNode, (boolean)false);
            if (file != null) {
                return ContextUtils.findInnerFileScope(file, offset);
            }
        }
        return null;
    }

    public static CsmScope findInnerFileScope(CsmFile file, int offset) {
        CsmScope innerScope = null;
        for (CsmOffsetableDeclaration decl : file.getDeclarations()) {
            if (!CsmKindUtilities.isScope((CsmObject)decl) || !ContextUtils.isInObject((CsmObject)decl, offset)) continue;
            innerScope = ContextUtils.findInnerScope((CsmScope)decl, offset);
            innerScope = innerScope != null ? innerScope : (CsmScope)decl;
            break;
        }
        return innerScope;
    }

    private static CsmScope findInnerScope(CsmScope outScope, int offset) {
        CsmScope inScope;
        for (CsmScopeElement item : outScope.getScopeElements()) {
            if (!CsmKindUtilities.isScope((CsmObject)item) || !ContextUtils.isInObject((CsmObject)item, offset)) continue;
            inScope = ContextUtils.findInnerScope((CsmScope)item, offset);
            if (inScope != null) {
                return inScope;
            }
            if (!CsmKindUtilities.isClass((CsmObject)item) && !CsmKindUtilities.isNamespace((Object)item) && !CsmKindUtilities.isFunction((CsmObject)item) && !CsmKindUtilities.isEnum((CsmObject)item) && !CsmKindUtilities.isUnion((CsmObject)item) && !CsmKindUtilities.isFile((CsmObject)item)) continue;
            return (CsmScope)item;
        }
        if (CsmKindUtilities.isNamespaceDefinition((CsmObject)outScope)) {
            for (CsmScopeElement item : ((CsmNamespaceDefinition)outScope).getDeclarations()) {
                if (!CsmKindUtilities.isScope((CsmObject)item) || !ContextUtils.isInObject((CsmObject)item, offset)) continue;
                inScope = ContextUtils.findInnerScope((CsmScope)item, offset);
                if (inScope != null) {
                    return inScope;
                }
                if (!CsmKindUtilities.isClass((CsmObject)item) && !CsmKindUtilities.isNamespace((Object)item) && !CsmKindUtilities.isFunction((CsmObject)item) && !CsmKindUtilities.isEnum((CsmObject)item) && !CsmKindUtilities.isUnion((CsmObject)item) && !CsmKindUtilities.isFile((CsmObject)item)) continue;
                return (CsmScope)item;
            }
        }
        return null;
    }
}

