/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.dialog;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.image.BufferedImage;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.BorderFactory;
import org.netbeans.modules.vmd.game.dialog.AbstractImagePreviewComponent;
import org.netbeans.modules.vmd.game.model.ImageUtils;

public class PartialImageGridPreview
extends AbstractImagePreviewComponent {
    public static final boolean DEBUG = false;
    private static final int TILE_GAP = 4;
    private URL imageURL;
    private BufferedImage originalImage;
    private Image preview;
    private int tileWidth;
    private int tileHeight;

    public PartialImageGridPreview() {
        this.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        Dimension d = new Dimension(50, 20);
        this.setMinimumSize(d);
        this.addComponentListener(new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent e) {
                PartialImageGridPreview.this.createPartialPreview();
                PartialImageGridPreview.this.repaint();
            }
        });
    }

    @Override
    public void setImageURL(URL imageURL) throws MalformedURLException, IllegalArgumentException {
        this.imageURL = imageURL;
        if (imageURL == null) {
            return;
        }
        BufferedImage image = ImageUtils.loadImage(imageURL);
        if (image == null) {
            throw new IllegalArgumentException();
        }
        BufferedImage bufImg = new BufferedImage(((Image)image).getWidth(null), ((Image)image).getHeight(null), 2);
        Graphics2D graphics = (Graphics2D)bufImg.getGraphics();
        graphics.drawImage((Image)image, 0, 0, null);
        this.originalImage = bufImg;
        this.tileWidth = this.originalImage.getWidth(this);
        this.tileHeight = this.originalImage.getHeight(this);
        this.createPartialPreview();
        this.repaint();
    }

    @Override
    public URL getImageURL() {
        return this.imageURL;
    }

    @Override
    public Image getImage() {
        return this.originalImage;
    }

    private void createPartialPreview() {
        if (this.originalImage == null) {
            return;
        }
        BufferedImage tmpImg = null;
        int rows = this.originalImage.getHeight(this) / this.tileHeight;
        int cols = this.originalImage.getWidth(this) / this.tileWidth;
        if (rows == 1 && cols == 1) {
            this.preview = ImageUtils.getScaledImage(this.originalImage, this.getWidth(), this.getHeight());
            return;
        }
        if (rows == 1 && cols != 1) {
            int maxWidth = (this.getWidth() - 4) / 2;
            int maxHeight = this.getHeight();
            Image left = ImageUtils.getScaledImage(this.originalImage.getSubimage(0, 0, this.tileWidth, this.tileHeight), maxWidth, maxHeight);
            Image right = ImageUtils.getScaledImage(this.originalImage.getSubimage(this.tileWidth, 0, this.tileWidth, this.tileHeight), maxWidth, maxHeight);
            tmpImg = new BufferedImage(left.getWidth(this) * 2 + 4, left.getHeight(this), 2);
            Graphics2D g = tmpImg.createGraphics();
            g.drawImage(left, 0, 0, this);
            g.setColor(Color.WHITE);
            g.fillRect(left.getWidth(this), 0, 4, left.getHeight(this) * 2 + 4);
            g.setColor(Color.BLACK);
            g.fillRect(left.getWidth(this) + 1, 0, 2, left.getHeight(this) * 2 + 4);
            g.drawImage(right, left.getWidth(this) + 4, 0, this);
        } else if (rows != 1 && cols == 1) {
            int maxWidth = this.getWidth();
            int maxHeight = (this.getHeight() - 4) / 2;
            Image top = ImageUtils.getScaledImage(this.originalImage.getSubimage(0, 0, this.tileWidth, this.tileHeight), maxWidth, maxHeight);
            Image bottom = ImageUtils.getScaledImage(this.originalImage.getSubimage(0, this.tileHeight, this.tileWidth, this.tileHeight), maxWidth, maxHeight);
            tmpImg = new BufferedImage(top.getWidth(this), top.getHeight(this) * 2 + 4, 2);
            Graphics2D g = tmpImg.createGraphics();
            g.drawImage(top, 0, 0, this);
            g.setColor(Color.WHITE);
            g.fillRect(0, top.getHeight(this), top.getWidth(this) * 2 + 4, 4);
            g.setColor(Color.BLACK);
            g.fillRect(0, top.getHeight(this) + 1, top.getWidth(this) * 2 + 4, 2);
            g.drawImage(bottom, 0, top.getHeight(this) + 4, this);
        } else {
            int maxWidth = (this.getWidth() - 4) / 2;
            int maxHeight = (this.getHeight() - 4) / 2;
            Image topLeft = ImageUtils.getScaledImage(this.originalImage.getSubimage(0, 0, this.tileWidth, this.tileHeight), maxWidth, maxHeight);
            Image topRight = ImageUtils.getScaledImage(this.originalImage.getSubimage(this.tileWidth, 0, this.tileWidth, this.tileHeight), maxWidth, maxHeight);
            Image bottomLeft = ImageUtils.getScaledImage(this.originalImage.getSubimage(0, this.tileHeight, this.tileWidth, this.tileHeight), maxWidth, maxHeight);
            Image bottomRight = ImageUtils.getScaledImage(this.originalImage.getSubimage(this.tileWidth, this.tileHeight, this.tileWidth, this.tileHeight), maxWidth, maxHeight);
            tmpImg = new BufferedImage(topLeft.getWidth(this) * 2 + 4, topLeft.getHeight(this) * 2 + 4, 2);
            Graphics2D g = tmpImg.createGraphics();
            g.drawImage(topLeft, 0, 0, this);
            g.drawImage(topRight, topLeft.getWidth(this) + 4, 0, this);
            g.setColor(Color.WHITE);
            g.fillRect(topLeft.getWidth(this), 0, 4, topLeft.getHeight(this) * 2 + 4);
            g.fillRect(0, topLeft.getHeight(this), topLeft.getWidth(this) * 2 + 4, 4);
            g.setColor(Color.BLACK);
            g.fillRect(topLeft.getWidth(this) + 1, 0, 2, topLeft.getHeight(this) * 2 + 4);
            g.fillRect(0, topLeft.getHeight(this) + 1, topLeft.getWidth(this) * 2 + 4, 2);
            g.drawImage(bottomLeft, 0, topLeft.getHeight(this) + 4, this);
            g.drawImage(bottomRight, topLeft.getWidth(this) + 4, topLeft.getHeight(this) + 4, this);
        }
        this.preview = tmpImg;
    }

    @Override
    public void setTileWidth(int width) {
        this.tileWidth = width;
        this.createPartialPreview();
        this.repaint();
    }

    @Override
    public void setTileHeight(int height) {
        this.tileHeight = height;
        this.createPartialPreview();
        this.repaint();
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.originalImage != null) {
            int offX = (this.getWidth() - this.preview.getWidth(this)) / 2;
            int offY = (this.getHeight() - this.preview.getHeight(this)) / 2;
            g.clearRect(0, 0, this.getWidth(), this.getWidth());
            g.drawImage(this.preview, offX, offY, this);
        }
    }

    @Override
    public int getTileWidth() {
        return this.tileWidth;
    }

    @Override
    public int getTileHeight() {
        return this.tileHeight;
    }
}

