/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.editor.common;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import org.netbeans.modules.vmd.game.model.StaticTile;
import org.netbeans.modules.vmd.game.view.ColorConstants;
import org.openide.util.NbBundle;

public class TileCellRenderer
extends JComponent
implements ListCellRenderer {
    private static final int MIN_TILE_SIZE = 30;
    private int padX;
    private int padY;
    private static final Color MOST_COLOR = ColorConstants.COLOR_OUTLINE_SELECTED;
    private static final Color NO_COLOR = ColorConstants.COLOR_OUTLINE_PLAIN;
    private static final Color MEDIUM_COLOR = ColorConstants.COLOR_OUTLINE_HILITE;
    private StaticTile tile;
    private boolean isSelected;
    private boolean hasFocus;

    public TileCellRenderer(int padX, int padY) {
        this.padX = padX;
        this.padY = padY;
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        return NbBundle.getMessage(TileCellRenderer.class, (String)"TileCellRenderer.tooltip", (Object)this.tile.getIndex());
    }

    @Override
    public void paintComponent(Graphics g) {
        Color c = this.isSelected && this.hasFocus ? MOST_COLOR : (this.isSelected ? MEDIUM_COLOR : NO_COLOR);
        g.setColor(c);
        g.fillRect(0, 0, this.padX, this.getHeight());
        g.fillRect(this.getWidth() - this.padX, 0, this.padX, this.getHeight());
        g.fillRect(this.padX, 0, this.getWidth() - 2 * this.padX, this.padY);
        g.fillRect(this.padX, this.getHeight() - this.padY, this.getWidth() - 2 * this.padX, this.padY);
        if (this.tile != null) {
            this.tile.paint((Graphics2D)g, this.padX, this.padY, this.getWidth() - 2 * this.padX, this.getHeight() - 2 * this.padY);
        }
        g.setColor(Color.WHITE);
        g.drawRect(0, 0, this.getWidth() - 1, this.getHeight() - 1);
        this.paintBorder(g);
    }

    public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean hasFocus) {
        if (value instanceof StaticTile) {
            float ratio;
            StaticTile tile;
            this.tile = tile = (StaticTile)value;
            this.isSelected = isSelected;
            this.hasFocus = hasFocus;
            int tileW = tile.getWidth();
            int tileH = tile.getHeight();
            int width = tileW;
            int height = tileH;
            if (tileW < tileH && tileW < 30) {
                ratio = 30.0f / (float)tileW;
                width = 30;
                height = (int)((float)height * ratio);
            } else if (tileH < tileW && tileH < 30) {
                ratio = 30.0f / (float)tileH;
                height = 30;
                width = (int)((float)width * ratio);
            } else if (tileH == tileW && tileH < 30) {
                width = 30;
                height = 30;
            }
            Dimension dimension = new Dimension(width + 2 * this.padX, height + 2 * this.padY);
            this.setPreferredSize(dimension);
            return this;
        }
        throw new IllegalArgumentException("Only org.netbeans.mobility.game.model.Tile or java.lang.Integer can be rendered.");
    }
}

