/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.editor.tiledlayer;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ComboBoxEditor;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.text.JTextComponent;
import org.jdesktop.layout.GroupLayout;
import org.netbeans.modules.vmd.game.dialog.NewAnimatedTileDialog;
import org.netbeans.modules.vmd.game.editor.tiledlayer.AnimatedTileList;
import org.netbeans.modules.vmd.game.editor.tiledlayer.TiledLayerEditorComponent;
import org.netbeans.modules.vmd.game.model.Tile;
import org.netbeans.modules.vmd.game.model.TiledLayer;
import org.netbeans.modules.vmd.game.model.TiledLayerListener;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;

public class TiledLayerEditor
extends JPanel
implements TiledLayerListener,
PropertyChangeListener {
    public static final int MAX_COMPILABLE_CELLS = 8000;
    public static final int MAX_EXTENDABLE_CELLS = 100000;
    private static final float ZOOM_STEP = 1.1f;
    private static final String[] ZOOM_VALUES = new String[]{"400%", "300%", "200%", "100%", "75%", "50%", "25%"};
    private TiledLayer tiledLayer;
    private TiledLayerEditorComponent editorComponent;
    private JScrollPane editorScroll;
    public JButton buttonAddAnimatedTile;
    public ButtonGroup buttonGroupMouseMode;
    public JLabel jLabel1;
    public JLabel jLabel2;
    public JLabel jLabel3;
    public JPanel jPanel1;
    private JPanel jPanel2;
    public JSeparator jSeparator1;
    public JSplitPane jSplitPane1;
    public JPanel panelAnimatedTiles;
    public JToggleButton resizableModeButton;
    public JTextField textFieldCols;
    public JTextField textFieldName;
    public JTextField textFieldRows;
    public JToggleButton toggleButtonPaint;
    public JToggleButton toggleButtonSelect;
    public JComboBox zoomCombo;
    public JButton zoomInButton;
    public JButton zoomOutButton;

    public TiledLayerEditor(final TiledLayer tiledLayer) {
        this.tiledLayer = tiledLayer;
        this.tiledLayer.addTiledLayerListener(this);
        this.tiledLayer.addPropertyChangeListener(this);
        this.editorComponent = new TiledLayerEditorComponent(this.tiledLayer);
        this.initComponents();
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TiledLayerEditor.class, (String)"TiledLayerEditor.accessible.name"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TiledLayerEditor.class, (String)"TiledLayerEditor.accessible.description"));
        this.toggleButtonPaint.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TiledLayerEditor.this.toggleButtonPaint.isSelected()) {
                    TiledLayerEditor.this.editorComponent.setEditMode(0);
                }
            }
        });
        this.toggleButtonSelect.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                if (TiledLayerEditor.this.toggleButtonSelect.isSelected()) {
                    TiledLayerEditor.this.editorComponent.setEditMode(1);
                }
            }
        });
        this.resizableModeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TiledLayerEditor.this.editorComponent.setAutoResizable(TiledLayerEditor.this.resizableModeButton.isSelected());
            }
        });
        this.toggleButtonPaint.setSelected(true);
        this.resizableModeButton.setSelected(true);
        this.buttonAddAnimatedTile.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                NewAnimatedTileDialog dialog = new NewAnimatedTileDialog(tiledLayer.getImageResource(), tiledLayer.getTileWidth(), tiledLayer.getTileHeight());
                DialogDescriptor dd = new DialogDescriptor((Object)dialog, NbBundle.getMessage(TiledLayerEditor.class, (String)"TiledLayerEditor.newAnimatedTileButton.txt"));
                dd.setButtonListener((ActionListener)dialog);
                dd.setValid(false);
                dialog.setDialogDescriptor(dd);
                Dialog d = DialogDisplayer.getDefault().createDialog(dd);
                d.setVisible(true);
            }
        });
        this.textFieldName.setBackground(this.textFieldName.getParent().getBackground());
        this.textFieldRows.setBackground(this.textFieldRows.getParent().getBackground());
        this.textFieldCols.setBackground(this.textFieldCols.getParent().getBackground());
        this.editorScroll = new JScrollPane();
        this.editorScroll.getViewport().setBackground(Color.WHITE);
        this.editorScroll.setViewportView(this.editorComponent);
        this.editorScroll.setColumnHeaderView(this.editorComponent.rulerHorizontal);
        this.editorScroll.setRowHeaderView(this.editorComponent.rulerVertical);
        this.editorScroll.setCorner("UPPER_LEFT_CORNER", this.editorComponent.getGridButton());
        this.jPanel2.add((Component)this.editorScroll, "Center");
        JScrollPane scrollAnimTiles = new JScrollPane(new AnimatedTileList(this.editorComponent));
        scrollAnimTiles.setBorder(null);
        this.panelAnimatedTiles.add((Component)scrollAnimTiles, "Center");
        this.updateTextLabels();
        ComboBoxEditor zce = this.zoomCombo.getEditor();
        this.zoomCombo.setEditor(new ZoomComboBoxEditor(zce));
        this.updateZoomCombo();
        MouseWheelListener mouseWheelListener = new MouseWheelListener(){

            @Override
            public void mouseWheelMoved(MouseWheelEvent e) {
                if (e.getWheelRotation() < 0) {
                    TiledLayerEditor.this.zoomOut();
                } else {
                    TiledLayerEditor.this.zoomIn();
                }
            }
        };
        this.addMouseWheelListener(mouseWheelListener);
        this.editorScroll.addMouseWheelListener(mouseWheelListener);
    }

    private void initComponents() {
        this.buttonGroupMouseMode = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.textFieldName = new JTextField();
        this.toggleButtonPaint = new JToggleButton();
        this.toggleButtonSelect = new JToggleButton();
        this.jLabel2 = new JLabel();
        this.textFieldRows = new JTextField();
        this.jLabel3 = new JLabel();
        this.textFieldCols = new JTextField();
        this.resizableModeButton = new JToggleButton();
        this.zoomCombo = new JComboBox();
        this.zoomOutButton = new JButton();
        this.jSeparator1 = new JSeparator();
        this.zoomInButton = new JButton();
        this.jSplitPane1 = new JSplitPane();
        this.panelAnimatedTiles = new JPanel();
        this.buttonAddAnimatedTile = new JButton();
        this.jPanel2 = new JPanel();
        this.setLayout(new BorderLayout());
        this.jLabel1.setText(NbBundle.getMessage(TiledLayerEditor.class, (String)"TiledLayerEditor.tiledLayerLabel.txt"));
        this.textFieldName.setEditable(false);
        this.textFieldName.setHorizontalAlignment(2);
        this.textFieldName.setText(this.tiledLayer.getName());
        this.textFieldName.setBorder(null);
        this.buttonGroupMouseMode.add(this.toggleButtonPaint);
        this.toggleButtonPaint.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/vmd/game/editor/tiledlayer/res/drawing_mode_16.png")));
        this.toggleButtonPaint.setToolTipText(NbBundle.getMessage(TiledLayerEditor.class, (String)"TiledLayerEditor.paintModeButton.tooltip"));
        this.toggleButtonPaint.setBorderPainted(false);
        this.buttonGroupMouseMode.add(this.toggleButtonSelect);
        this.toggleButtonSelect.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/vmd/game/editor/tiledlayer/res/selection_mode_16.png")));
        this.toggleButtonSelect.setToolTipText(NbBundle.getMessage(TiledLayerEditor.class, (String)"TiledLayerEditor.selectModeButton.tooltip"));
        this.toggleButtonSelect.setBorderPainted(false);
        this.jLabel2.setText(NbBundle.getMessage(TiledLayerEditor.class, (String)"TiledLayerEditor.tiledLayerRowsLabel.txt"));
        this.textFieldRows.setEditable(false);
        this.textFieldRows.setHorizontalAlignment(2);
        this.textFieldRows.setText(Integer.toString(this.tiledLayer.getRowCount()));
        this.textFieldRows.setBorder(null);
        this.jLabel3.setText(NbBundle.getMessage(TiledLayerEditor.class, (String)"TiledLayerEditor.tiledLayerColsLabel.txt"));
        this.textFieldCols.setEditable(false);
        this.textFieldCols.setHorizontalAlignment(2);
        this.textFieldCols.setText(Integer.toString(this.tiledLayer.getColumnCount()));
        this.textFieldCols.setBorder(null);
        this.resizableModeButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/vmd/game/editor/tiledlayer/res/resizable_mode_16.png")));
        this.resizableModeButton.setToolTipText(NbBundle.getMessage(TiledLayerEditor.class, (String)"TiledLayerEditor.resizableModeButton.tooltip"));
        this.resizableModeButton.setBorderPainted(false);
        this.zoomCombo.setEditable(true);
        this.zoomCombo.setModel(new DefaultComboBoxModel<String>(ZOOM_VALUES));
        this.zoomCombo.setSelectedIndex(0);
        this.zoomCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TiledLayerEditor.this.zoomComboActionPerformed(evt);
            }
        });
        this.zoomOutButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/vmd/game/editor/tiledlayer/res/zoom_out.png")));
        this.zoomOutButton.setToolTipText(NbBundle.getMessage(TiledLayerEditor.class, (String)"TiledLayerEditor.zoomOutButton.tooltip"));
        this.zoomOutButton.setBorder(null);
        this.zoomOutButton.setBorderPainted(false);
        this.zoomOutButton.setOpaque(false);
        this.zoomOutButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TiledLayerEditor.this.zoomOutButtonActionPerformed(evt);
            }
        });
        this.jSeparator1.setOrientation(1);
        this.zoomInButton.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/vmd/game/editor/tiledlayer/res/zoom_in.png")));
        this.zoomInButton.setToolTipText(NbBundle.getMessage(TiledLayerEditor.class, (String)"TiledLayerEditor.zoomInButton.tooltip"));
        this.zoomInButton.setBorder(null);
        this.zoomInButton.setBorderPainted(false);
        this.zoomInButton.setOpaque(false);
        this.zoomInButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                TiledLayerEditor.this.zoomInButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout((Container)this.jPanel1);
        this.jPanel1.setLayout((LayoutManager)jPanel1Layout);
        jPanel1Layout.setHorizontalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createSequentialGroup().addContainerGap().add((Component)this.toggleButtonPaint, -2, 26, -2).addPreferredGap(0).add((Component)this.toggleButtonSelect, -2, 23, -2).addPreferredGap(0).add((Component)this.jLabel1).addPreferredGap(0).add((Component)this.textFieldName, -1, 195, Short.MAX_VALUE).addPreferredGap(1).add((Component)this.zoomCombo, -2, -1, -2).addPreferredGap(0).add((Component)this.zoomInButton, -2, 23, -2).add(3, 3, 3).add((Component)this.zoomOutButton, -2, 23, -2).addPreferredGap(0).add((Component)this.jSeparator1, -2, -1, -2).addPreferredGap(0).add((Component)this.resizableModeButton, -2, 23, -2).addPreferredGap(0).add((Component)this.jLabel2).add(6, 6, 6).add((Component)this.textFieldRows, -2, 41, -2).addPreferredGap(0).add((Component)this.jLabel3).add(6, 6, 6).add((Component)this.textFieldCols, -2, 41, -2).addContainerGap()));
        jPanel1Layout.linkSize(new Component[]{this.toggleButtonPaint, this.toggleButtonSelect}, 1);
        jPanel1Layout.setVerticalGroup((GroupLayout.Group)jPanel1Layout.createParallelGroup(1).add((GroupLayout.Group)jPanel1Layout.createParallelGroup(4).add((Component)this.jLabel1).add((Component)this.textFieldName, -2, -1, -2).add((Component)this.toggleButtonPaint, -2, 25, -2).add((Component)this.toggleButtonSelect, -2, 25, -2).add((Component)this.jLabel2).add((Component)this.textFieldRows, -2, -1, -2).add((Component)this.jLabel3).add((Component)this.textFieldCols, -2, -1, -2).add((Component)this.resizableModeButton, -2, 25, -2).add((Component)this.jSeparator1, -2, 25, -2).add((Component)this.zoomOutButton, -2, 25, -2).add((Component)this.zoomInButton, -2, 25, -2).add((Component)this.zoomCombo, -2, -1, -2)));
        this.resizableModeButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TiledLayerEditor.class, (String)"ACSN_resizableModeButton"));
        this.resizableModeButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TiledLayerEditor.class, (String)"ACSD_resizableModeButton"));
        this.zoomCombo.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TiledLayerEditor.class, (String)"ACSN_zoomCombo"));
        this.zoomCombo.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TiledLayerEditor.class, (String)"ACSD_zoomCombo"));
        this.zoomOutButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TiledLayerEditor.class, (String)"ACSN_zoomOutButton"));
        this.zoomOutButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TiledLayerEditor.class, (String)"ACSD_zoomOutButton"));
        this.zoomInButton.getAccessibleContext().setAccessibleName(NbBundle.getMessage(TiledLayerEditor.class, (String)"ACSN_zoomInButton"));
        this.zoomInButton.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(TiledLayerEditor.class, (String)"ACSD_zoomInButton"));
        this.add((Component)this.jPanel1, "North");
        this.jSplitPane1.setBorder(null);
        this.jSplitPane1.setDividerSize(5);
        this.jSplitPane1.setResizeWeight(1.0);
        this.jSplitPane1.setContinuousLayout(true);
        this.panelAnimatedTiles.setBorder(BorderFactory.createEtchedBorder());
        this.panelAnimatedTiles.setLayout(new BorderLayout());
        this.buttonAddAnimatedTile.setIcon(new ImageIcon(this.getClass().getResource("/org/netbeans/modules/vmd/game/editor/tiledlayer/res/new_animated_tile_16.png")));
        this.buttonAddAnimatedTile.setText(NbBundle.getMessage(TiledLayerEditor.class, (String)"TiledLayerEditor.newAnimatedTileButton.txt"));
        this.buttonAddAnimatedTile.setToolTipText(NbBundle.getMessage(TiledLayerEditor.class, (String)"TiledLayerEditor.newAnimTileButton.tooltip"));
        this.panelAnimatedTiles.add((Component)this.buttonAddAnimatedTile, "North");
        this.jSplitPane1.setRightComponent(this.panelAnimatedTiles);
        this.jPanel2.setBackground(new Color(255, 255, 255));
        this.jPanel2.setToolTipText("");
        this.jPanel2.setPreferredSize(new Dimension(10000, 10000));
        this.jPanel2.setLayout(new BorderLayout());
        this.jSplitPane1.setLeftComponent(this.jPanel2);
        this.add((Component)this.jSplitPane1, "Center");
    }

    private void zoomComboActionPerformed(ActionEvent evt) {
        String selection = (String)this.zoomCombo.getSelectedItem();
        if (selection != null) {
            if ((selection = selection.trim()).endsWith("%")) {
                selection = selection.substring(0, selection.length() - 1);
            }
            try {
                float zoom = Float.parseFloat(selection) / 100.0f;
                if (zoom > 0.0f && zoom < 100.0f) {
                    this.editorComponent.setZoom(zoom);
                }
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
    }

    private void zoomInButtonActionPerformed(ActionEvent evt) {
        this.zoomIn();
    }

    private void zoomOutButtonActionPerformed(ActionEvent evt) {
        this.zoomOut();
    }

    public void setPaintTile(Tile tile) {
        this.editorComponent.setPaintTileIndex(tile.getIndex());
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getSource() == this.tiledLayer && evt.getPropertyName().equals("editable.prop.name")) {
            this.textFieldName.setText(this.tiledLayer.getName());
        }
    }

    public void updateTextLabels() {
        this.textFieldRows.setText(Integer.toString(this.tiledLayer.getRowCount()));
        this.textFieldCols.setText(Integer.toString(this.tiledLayer.getColumnCount()));
        Color textColor = null;
        int cellsCnt = this.tiledLayer.getRowCount() * this.tiledLayer.getColumnCount();
        if (cellsCnt > 100000) {
            textColor = Color.RED;
            this.textFieldName.setToolTipText(NbBundle.getMessage(TiledLayerEditor.class, (String)"TiledLayerEditor.textFieldName.notExtendable.err.tooltip", (Object)100000));
            this.resizableModeButton.setSelected(false);
            this.editorComponent.setAutoResizable(false);
            this.resizableModeButton.setEnabled(false);
        } else if (cellsCnt > 8000) {
            textColor = Color.RED;
            this.textFieldName.setToolTipText(NbBundle.getMessage(TiledLayerEditor.class, (String)"TiledLayerEditor.textFieldName.notCompilable.err.tooltip"));
            if (!this.resizableModeButton.isEnabled()) {
                this.resizableModeButton.setEnabled(true);
            }
        } else {
            textColor = Color.BLACK;
            this.textFieldName.setToolTipText(null);
            if (!this.resizableModeButton.isEnabled()) {
                this.resizableModeButton.setEnabled(true);
            }
        }
        this.textFieldName.setForeground(textColor);
    }

    @Override
    public void tileChanged(TiledLayer t, int row, int col) {
    }

    @Override
    public void tilesChanged(TiledLayer t, Set positions) {
    }

    @Override
    public void tilesStructureChanged(TiledLayer source) {
        this.updateTextLabels();
    }

    @Override
    public void columnsInserted(TiledLayer t, int index, int count) {
        this.updateTextLabels();
    }

    @Override
    public void columnsRemoved(TiledLayer t, int index, int count) {
        this.updateTextLabels();
    }

    @Override
    public void rowsInserted(TiledLayer t, int index, int count) {
        this.updateTextLabels();
    }

    @Override
    public void rowsRemoved(TiledLayer t, int index, int count) {
        this.updateTextLabels();
    }

    private void zoomIn() {
        this.editorComponent.setZoom(this.editorComponent.getZoom() * 1.1f);
        this.updateZoomCombo();
    }

    private void zoomOut() {
        this.editorComponent.setZoom(this.editorComponent.getZoom() / 1.1f);
        this.updateZoomCombo();
    }

    protected void updateZoomCombo() {
        this.zoomCombo.getEditor().setItem(Integer.toString((int)(this.editorComponent.getZoom() * 100.0f)) + "%");
    }

    private class ZoomComboBoxEditor
    implements ComboBoxEditor {
        private ComboBoxEditor cbe;
        private String m_lastValue = "";

        ZoomComboBoxEditor(ComboBoxEditor editor) {
            this.cbe = editor;
        }

        @Override
        public Component getEditorComponent() {
            return this.cbe.getEditorComponent();
        }

        @Override
        public void setItem(Object anObject) {
            this.cbe.setItem(anObject);
        }

        @Override
        public Object getItem() {
            int len;
            String value;
            Object o = this.cbe.getItem();
            if (o != null && (value = o.toString()) != null && (len = (value = value.trim()).length()) > 0) {
                if (value.endsWith("%")) {
                    value = value.substring(0, len - 1);
                }
                try {
                    float floatValue = Float.parseFloat(value);
                    this.m_lastValue = Math.round(floatValue) + "%";
                    return this.m_lastValue;
                }
                catch (NumberFormatException e) {
                    // empty catch block
                }
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ((JTextComponent)ZoomComboBoxEditor.this.cbe.getEditorComponent()).setText(ZoomComboBoxEditor.this.m_lastValue);
                }
            });
            return this.m_lastValue;
        }

        @Override
        public void selectAll() {
            this.cbe.selectAll();
        }

        @Override
        public void addActionListener(ActionListener l) {
            this.cbe.addActionListener(l);
        }

        @Override
        public void removeActionListener(ActionListener l) {
            this.cbe.removeActionListener(l);
        }
    }
}

