/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.integration.components;

import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEdit;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.netbeans.modules.vmd.game.integration.components.GameTypes;
import org.netbeans.modules.vmd.game.model.SpriteCD;
import org.netbeans.modules.vmd.game.model.TiledLayerCD;

public class GameDocumentSupport {
    public static DesignComponent addSprite(DesignDocument document) {
        DesignComponent rootComponent = document.getRootComponent();
        DesignComponent sprite = document.createComponent(SpriteCD.TYPEID);
        rootComponent.addComponent(sprite);
        return sprite;
    }

    public static DesignComponent addTiledLayer(DesignDocument document) {
        DesignComponent rootComponent = document.getRootComponent();
        DesignComponent tiledLayer = document.createComponent(TiledLayerCD.TYPEID);
        rootComponent.addComponent(tiledLayer);
        return tiledLayer;
    }

    public static int getRowCount(PropertyValue tilesPropertyValue) {
        if (tilesPropertyValue == null) {
            return 0;
        }
        return GameTypes.getTiles(tilesPropertyValue).length;
    }

    public static int getColumnCount(PropertyValue tilesPropertyValue) {
        if (tilesPropertyValue == null) {
            return 0;
        }
        int[][] tiles = GameTypes.getTiles(tilesPropertyValue);
        if (tiles.length < 1) {
            return 0;
        }
        return tiles[0].length;
    }

    public static void setSingleTile(DesignComponent tiledLayer, int y, int x, int newValue) {
        PropertyValue tilesPropertyValue = tiledLayer.readProperty("tiledlayercd.prop.tiles");
        int[][] tiles = GameTypes.getTiles(tilesPropertyValue);
        int oldValue = tiles[y][x];
        tiles[y][x] = newValue;
        TilesChangeUndoableEdit undoableEdit = new TilesChangeUndoableEdit(tiledLayer, y, x, oldValue, newValue);
        tiledLayer.getDocument().getTransactionManager().undoableEditHappened((UndoableEdit)undoableEdit);
        tiledLayer.writeProperty("tiledlayercd.prop.tiles", GameTypes.createTilesProperty(tiles));
    }

    private static class TilesChangeUndoableEdit
    extends AbstractUndoableEdit {
        private DesignComponent tiledLayer;
        private int y;
        private int x;
        private int oldValue;
        private int newValue;

        public TilesChangeUndoableEdit(DesignComponent tiledLayer, int y, int x, int oldValue, int newValue) {
            this.tiledLayer = tiledLayer;
            this.y = y;
            this.x = x;
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            PropertyValue tilesPropertyValue = this.tiledLayer.readProperty("tiledlayercd.prop.tiles");
            int[][] tiles = GameTypes.getTiles(tilesPropertyValue);
            tiles[this.y][this.x] = this.oldValue;
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            PropertyValue tilesPropertyValue = this.tiledLayer.readProperty("tiledlayercd.prop.tiles");
            int[][] tiles = GameTypes.getTiles(tilesPropertyValue);
            tiles[this.y][this.x] = this.newValue;
        }

        @Override
        public boolean isSignificant() {
            return false;
        }
    }
}

