/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.model;

import java.awt.Graphics2D;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import org.netbeans.modules.vmd.game.model.Editable;
import org.netbeans.modules.vmd.game.model.GlobalRepository;
import org.netbeans.modules.vmd.game.model.Identifiable;
import org.netbeans.modules.vmd.game.model.ImageResource;
import org.netbeans.modules.vmd.game.model.LayerDataFlavor;
import org.netbeans.modules.vmd.game.model.Previewable;
import org.netbeans.modules.vmd.game.model.Scene;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public abstract class Layer
implements Previewable,
Editable,
Transferable,
Identifiable {
    private long id = -1L;
    public static final String ACTION_PROP_SCENE = "layer.action.prop.scene";
    protected PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private GlobalRepository gameDesign;
    private String name;
    private ImageResource imageResource;
    private int cellWidth;
    private int cellHeight;

    protected Layer(GlobalRepository gameDesign, String name, ImageResource imageResource, int cellWidth, int cellHeight) {
        assert (gameDesign != null);
        this.gameDesign = gameDesign;
        this.name = name;
        this.imageResource = imageResource;
        this.cellWidth = cellWidth;
        this.cellHeight = cellHeight;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public GlobalRepository getGameDesign() {
        return this.gameDesign;
    }

    public void setName(String name) {
        if (name == null) {
            return;
        }
        if (this.getName().equals(name)) {
            return;
        }
        if (!this.gameDesign.isComponentNameAvailable(name)) {
            throw new IllegalArgumentException("Layer cannot be renamed because component name '" + name + "' already exists.");
        }
        String oldName = this.name;
        this.name = name;
        this.propertyChangeSupport.firePropertyChange("editable.prop.name", oldName, name);
    }

    public ImageResource getImageResource() {
        return this.imageResource;
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    public abstract void paint(Graphics2D var1);

    @Override
    public abstract int getHeight();

    @Override
    public abstract int getWidth();

    @Override
    public Object getTransferData(DataFlavor flavor) throws UnsupportedFlavorException, IOException {
        return this;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        DataFlavor[] flavors = new DataFlavor[1];
        try {
            flavors[0] = new LayerDataFlavor();
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
        return flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor flavor) {
        return flavor instanceof LayerDataFlavor;
    }

    public int getTileHeight() {
        return this.cellHeight;
    }

    public int getTileWidth() {
        return this.cellWidth;
    }

    public abstract String getDisplayableTypeName();

    @Override
    public List<Action> getActions() {
        ArrayList<AbstractAction> actions = new ArrayList<AbstractAction>();
        actions.add(new EditLayerAction());
        actions.add(new RemoveAction());
        return Collections.unmodifiableList(actions);
    }

    @Override
    public JComponent getNavigator() {
        return null;
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    public class RemoveAction
    extends AbstractAction {
        public RemoveAction() {
            this.putValue("Name", NbBundle.getMessage(Layer.class, (String)"Layer.removeAction", (Object)Layer.this.getDisplayableTypeName()));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Scene scene = (Scene)this.getValue(Layer.ACTION_PROP_SCENE);
            if (scene != null) {
                scene.remove(Layer.this);
            } else {
                Object response = DialogDisplayer.getDefault().notify(new NotifyDescriptor((Object)NbBundle.getMessage(Layer.class, (String)"Layer.removeDialog.text", (Object[])new Object[]{Layer.this.getDisplayableTypeName(), Layer.this.getName()}), NbBundle.getMessage(Layer.class, (String)"Layer.removeDialog.title"), 0, 3, new Object[]{NotifyDescriptor.YES_OPTION, NotifyDescriptor.NO_OPTION}, NotifyDescriptor.YES_OPTION));
                if (response == NotifyDescriptor.YES_OPTION) {
                    Layer.this.gameDesign.removeLayer(Layer.this);
                }
            }
        }
    }

    public class EditLayerAction
    extends AbstractAction {
        public EditLayerAction() {
            this.putValue("Name", NbBundle.getMessage(Layer.class, (String)"Layer.editAction", (Object)Layer.this.getDisplayableTypeName()));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Layer.this.gameDesign.getMainView().requestEditing(Layer.this);
        }
    }

    public static class NameComparator
    implements Comparator {
        public int compare(Object arg0, Object arg1) {
            if (!(arg0 instanceof Layer) || !(arg1 instanceof Layer)) {
                throw new ClassCastException("Compared object not instance of Layer");
            }
            Layer l0 = (Layer)arg0;
            Layer l1 = (Layer)arg1;
            return l0.getName().compareTo(l1.getName());
        }
    }
}

