/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.model;

import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.event.EventListenerList;
import org.netbeans.modules.vmd.game.dialog.RenameSequenceDialog;
import org.netbeans.modules.vmd.game.editor.sequece.SequenceEditingPanel;
import org.netbeans.modules.vmd.game.model.Editable;
import org.netbeans.modules.vmd.game.model.GlobalRepository;
import org.netbeans.modules.vmd.game.model.Identifiable;
import org.netbeans.modules.vmd.game.model.ImageResource;
import org.netbeans.modules.vmd.game.model.Previewable;
import org.netbeans.modules.vmd.game.model.SequenceListener;
import org.netbeans.modules.vmd.game.model.StaticTile;
import org.netbeans.modules.vmd.game.preview.SequencePreviewPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;

public class Sequence
implements Previewable,
Editable,
Identifiable {
    private long id = -1L;
    public static final boolean DEBUG = false;
    public static final int DEFAULT_FRAMES = 1;
    public static final int DEFAULT_SHOWTIME_MS = 200;
    public static final String PROPERTY_NAME = "sequence.prop.name";
    public static final String PROPERTY_FRAME_MS = "sequence.prop.frames.ms";
    EventListenerList listenerList = new EventListenerList();
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private SequenceEditingPanel editor;
    private String name;
    private ImageResource imageResource;
    private boolean zeroBasedIndex;
    private int frameWidth;
    private int frameHeight;
    private int frameMs;
    private ArrayList<StaticTile> frames;

    Sequence(String name, ImageResource imageResource, int frameWidth, int frameHeight, boolean zeroBasedIndex) {
        this(name, imageResource, 1, frameWidth, frameHeight, zeroBasedIndex);
    }

    Sequence(String name, ImageResource imageResource, int numberFrames, int frameWidth, int frameHeight, boolean zeroBasedIndex) {
        this.name = name;
        this.imageResource = imageResource;
        this.frameWidth = frameWidth;
        this.frameHeight = frameHeight;
        this.zeroBasedIndex = zeroBasedIndex;
        this.frames = new ArrayList();
        for (int i = 0; i < numberFrames; ++i) {
            this.frames.add((StaticTile)imageResource.getTile(0, this.frameWidth, this.frameHeight, this.zeroBasedIndex));
        }
        this.frameMs = 200;
    }

    Sequence(String name, Sequence sequence) {
        this.name = name;
        this.imageResource = sequence.getImageResource();
        this.frameHeight = sequence.getFrameHeight();
        this.frameWidth = sequence.getFrameWidth();
        this.frameMs = sequence.frameMs;
        this.zeroBasedIndex = sequence.zeroBasedIndex;
        this.frames = new ArrayList();
        this.frames.addAll(sequence.getFrames());
    }

    public GlobalRepository getGameDesign() {
        return this.imageResource.getGameDesign();
    }

    public boolean isZeroBasedIndex() {
        return this.zeroBasedIndex;
    }

    public void setName(String name) {
        if (name == null) {
            return;
        }
        if (this.getName().equals(name)) {
            return;
        }
        if (!this.getGameDesign().isComponentNameAvailable(name)) {
            throw new IllegalArgumentException("Sequence cannot be renamed because component name '" + name + "' already exists.");
        }
        String oldName = this.name;
        this.name = name;
        this.propertyChangeSupport.firePropertyChange(PROPERTY_NAME, oldName, name);
    }

    public void setFrames(int[] frames) {
        ArrayList<StaticTile> newFrames = new ArrayList<StaticTile>();
        for (int i = 0; i < frames.length; ++i) {
            StaticTile frame = new StaticTile(this.imageResource, frames[i], this.frameWidth, this.frameHeight, this.zeroBasedIndex);
            newFrames.add(frame);
        }
        this.frames = newFrames;
        this.fireFramesChanged();
    }

    public void addFrame(StaticTile frame) {
        if (frame == null) {
            frame = (StaticTile)this.imageResource.getTile(0, this.frameWidth, this.frameHeight, this.zeroBasedIndex);
        }
        this.frames.add(frame);
        int index = this.frames.indexOf(frame);
        this.fireFrameAdded(frame, index);
    }

    public void insertFrame(StaticTile frame, int index) {
        if (frame == null) {
            frame = (StaticTile)this.imageResource.getTile(0, this.frameWidth, this.frameHeight, this.zeroBasedIndex);
        }
        this.frames.add(index, frame);
        this.fireFrameAdded(frame, index);
    }

    public void removeFrame(int index) {
        StaticTile frame = this.frames.remove(index);
        this.fireFrameRemoved(frame, index);
    }

    public void removeFrames(Set<Integer> indexes) {
        ArrayList<Integer> tmp = new ArrayList<Integer>(indexes);
        Collections.sort(tmp, new Comparator<Integer>(){

            @Override
            public int compare(Integer a, Integer b) {
                return a > b ? -1 : (a.intValue() == b.intValue() ? 0 : 1);
            }
        });
        for (Integer integer : tmp) {
            this.removeFrame(integer);
        }
    }

    public StaticTile getFrame(int index) {
        return this.frames.get(index);
    }

    public void setFrame(StaticTile frame, int index) {
        if (frame == null) {
            frame = (StaticTile)this.imageResource.getTile(0, this.frameWidth, this.frameHeight, this.zeroBasedIndex);
        }
        this.frames.ensureCapacity(index + 1);
        this.frames.set(index, frame);
        this.fireFrameModified(frame, index);
    }

    public int getFrameMs() {
        return this.frameMs;
    }

    public void setFrameMs(int frameMs) {
        int oldMs = this.frameMs;
        this.frameMs = frameMs;
        this.propertyChangeSupport.firePropertyChange(PROPERTY_FRAME_MS, oldMs, frameMs);
    }

    public int getFrameHeight() {
        return this.frameHeight;
    }

    public int getFrameWidth() {
        return this.frameWidth;
    }

    public int getFrameCount() {
        return this.frames.size();
    }

    public Dimension getFrameSize() {
        return new Dimension(this.getFrameWidth(), this.getFrameHeight());
    }

    public List getFrames() {
        return Collections.unmodifiableList(this.frames);
    }

    public int[] getFramesAsArray() {
        int[] a = new int[this.frames.size()];
        for (int i = 0; i < a.length; ++i) {
            a[i] = this.frames.get(i).getIndex();
        }
        return a;
    }

    private void fireFramesChanged() {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != SequenceListener.class) continue;
            ((SequenceListener)listeners[i + 1]).framesChanged(this);
        }
    }

    private void fireFrameAdded(StaticTile frame, int index) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != SequenceListener.class) continue;
            ((SequenceListener)listeners[i + 1]).frameAdded(this, index);
        }
    }

    private void fireFrameRemoved(StaticTile frame, int index) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != SequenceListener.class) continue;
            ((SequenceListener)listeners[i + 1]).frameRemoved(this, index);
        }
    }

    private void fireFrameModified(StaticTile frame, int index) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != SequenceListener.class) continue;
            ((SequenceListener)listeners[i + 1]).frameModified(this, index);
        }
    }

    @Override
    public JComponent getEditor() {
        return this.editor == null ? (this.editor = new SequenceEditingPanel(this)) : this.editor;
    }

    public ImageResource getImageResource() {
        return this.imageResource;
    }

    @Override
    public Editable.ImageResourceInfo getImageResourceInfo() {
        return new Editable.ImageResourceInfo(this.imageResource, this.frameWidth, this.frameHeight, this.zeroBasedIndex);
    }

    @Override
    public JComponent getNavigator() {
        return null;
    }

    @Override
    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    @Override
    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    public synchronized void addSequenceListener(SequenceListener l) {
        this.listenerList.add(SequenceListener.class, l);
    }

    public synchronized void removeSequenceListener(SequenceListener l) {
        this.listenerList.remove(SequenceListener.class, l);
    }

    public String toString() {
        return this.getName();
    }

    @Override
    public void paint(Graphics2D g, int x, int y) {
        this.getFrame(0).paint(g, x, y);
    }

    @Override
    public int getWidth() {
        return this.frameWidth;
    }

    @Override
    public int getHeight() {
        return this.frameHeight;
    }

    @Override
    public JComponent getPreview() {
        return new SequencePreviewPanel(this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public List<Action> getActions() {
        ArrayList<AbstractAction> actions = new ArrayList<AbstractAction>();
        actions.add(new RenameSequenceAction());
        actions.add(new EditSequenceAction());
        return Collections.unmodifiableList(actions);
    }

    @Override
    public long getId() {
        return this.id;
    }

    @Override
    public void setId(long id) {
        this.id = id;
    }

    public class RenameSequenceAction
    extends AbstractAction {
        public RenameSequenceAction() {
            this.putValue("Name", NbBundle.getMessage(Sequence.class, (String)"Sequence.RenameSequenceAction.text"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RenameSequenceDialog dialog = new RenameSequenceDialog(Sequence.this);
            DialogDescriptor dd = new DialogDescriptor((Object)dialog, NbBundle.getMessage(Sequence.class, (String)"Sequence.RenameSequenceAction.text"));
            dd.setButtonListener((ActionListener)dialog);
            dd.setValid(false);
            dialog.setDialogDescriptor(dd);
            Dialog d = DialogDisplayer.getDefault().createDialog(dd);
            d.setVisible(true);
        }
    }

    public class EditSequenceAction
    extends AbstractAction {
        public EditSequenceAction() {
            this.putValue("Name", NbBundle.getMessage(Sequence.class, (String)"Sequence.EditSequenceAction.text"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Sequence.this.getGameDesign().getMainView().requestEditing(Sequence.this);
        }
    }
}

