/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.model;

import java.awt.Dialog;
import java.awt.Graphics2D;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import org.netbeans.modules.vmd.game.dialog.RenameSpriteDialog;
import org.netbeans.modules.vmd.game.editor.sequece.SequenceContainerEditor;
import org.netbeans.modules.vmd.game.editor.sequece.SequenceContainerNavigator;
import org.netbeans.modules.vmd.game.model.Editable;
import org.netbeans.modules.vmd.game.model.GlobalRepository;
import org.netbeans.modules.vmd.game.model.ImageResource;
import org.netbeans.modules.vmd.game.model.Layer;
import org.netbeans.modules.vmd.game.model.Sequence;
import org.netbeans.modules.vmd.game.model.SequenceContainer;
import org.netbeans.modules.vmd.game.model.SequenceContainerListener;
import org.netbeans.modules.vmd.game.preview.SequenceContainerPreview;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;

public class Sprite
extends Layer
implements SequenceContainer {
    private SequenceContainerEditor editor;
    private JComponent navigator;
    private SequenceContainer.SequenceContainerImpl sequenceContainer;

    Sprite(GlobalRepository gameDesign, String name, ImageResource imageResource, int numberFrames, int frameWidth, int frameHeight) {
        super(gameDesign, name, imageResource, frameWidth, frameHeight);
        this.sequenceContainer = new SequenceContainer.SequenceContainerImpl(this, null, this.propertyChangeSupport, imageResource, frameWidth, frameHeight, true);
        String seqName = this.getNextSequenceName(name + "seq");
        Sequence defaultSequence = this.createSequence(seqName, numberFrames, frameWidth, frameHeight);
        this.setDefaultSequence(defaultSequence);
    }

    Sprite(GlobalRepository gameDesign, String name, ImageResource imageResource, Sequence defaultSequence) {
        super(gameDesign, name, imageResource, defaultSequence.getFrameWidth(), defaultSequence.getFrameHeight());
        this.sequenceContainer = new SequenceContainer.SequenceContainerImpl(this, null, this.propertyChangeSupport, imageResource, defaultSequence.getFrameWidth(), defaultSequence.getFrameHeight(), true);
        this.setDefaultSequence(defaultSequence);
    }

    @Override
    public Editable.ImageResourceInfo getImageResourceInfo() {
        return new Editable.ImageResourceInfo(this.getImageResource(), this.getTileWidth(), this.getTileHeight(), true);
    }

    @Override
    public String getNextSequenceName(String prefix) {
        return this.sequenceContainer.getNextSequenceName(prefix);
    }

    @Override
    public void addSequenceContainerListener(SequenceContainerListener listener) {
        this.sequenceContainer.addSequenceContainerListener(listener);
    }

    @Override
    public void removeSequenceContainerListener(SequenceContainerListener listener) {
        this.sequenceContainer.removeSequenceContainerListener(listener);
    }

    @Override
    public Sequence createSequence(String name, int numberFrames, int frameWidth, int frameHeight) {
        return this.sequenceContainer.createSequence(name, numberFrames, frameWidth, frameHeight);
    }

    @Override
    public Sequence createSequence(String name, Sequence s) {
        return this.sequenceContainer.createSequence(name, s);
    }

    @Override
    public boolean append(Sequence sequence) {
        return this.sequenceContainer.append(sequence);
    }

    @Override
    public boolean insert(Sequence sequence, int index) {
        return this.sequenceContainer.insert(sequence, index);
    }

    @Override
    public boolean remove(Sequence sequence) {
        return this.sequenceContainer.remove(sequence);
    }

    @Override
    public void move(Sequence sequence, int newIndex) {
        this.sequenceContainer.move(sequence, newIndex);
    }

    @Override
    public List<Sequence> getSequences() {
        return this.sequenceContainer.getSequences();
    }

    @Override
    public int getSequenceCount() {
        return this.sequenceContainer.getSequenceCount();
    }

    @Override
    public Sequence getSequenceByName(String name) {
        return this.sequenceContainer.getSequenceByName(name);
    }

    @Override
    public void setDefaultSequence(Sequence defaultSequence) {
        this.sequenceContainer.setDefaultSequence(defaultSequence);
    }

    @Override
    public Sequence getDefaultSequence() {
        return this.sequenceContainer.getDefaultSequence();
    }

    @Override
    public int indexOf(Sequence sequence) {
        return this.sequenceContainer.indexOf(sequence);
    }

    @Override
    public Sequence getSequenceAt(int index) {
        return this.sequenceContainer.getSequenceAt(index);
    }

    @Override
    public List<Action> getActionsForSequence(Sequence sequence) {
        return this.sequenceContainer.getActionsForSequence(sequence);
    }

    @Override
    public JComponent getEditor() {
        return this.editor == null ? (this.editor = new SequenceContainerEditor(this)) : this.editor;
    }

    @Override
    public JComponent getNavigator() {
        return this.navigator == null ? (this.navigator = new SequenceContainerNavigator(this)) : this.navigator;
    }

    @Override
    public int getHeight() {
        return super.getTileHeight();
    }

    @Override
    public int getWidth() {
        return super.getTileWidth();
    }

    @Override
    public List<Action> getActions() {
        List<Action> superActions = super.getActions();
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.addAll(superActions);
        actions.add(new RenameAction());
        return actions;
    }

    @Override
    public String getDisplayableTypeName() {
        return NbBundle.getMessage(Sprite.class, (String)"Sprite.text");
    }

    @Override
    public JComponent getPreview() {
        return new SequenceContainerPreview(NbBundle.getMessage(Sprite.class, (String)"Sprite.preview.title"), this);
    }

    @Override
    public void paint(Graphics2D g, int x, int y) {
        this.getDefaultSequence().getFrame(0).paint(g, x, y);
    }

    @Override
    public void paint(Graphics2D g) {
        this.getDefaultSequence().getFrame(0).paint(g, 0, 0);
    }

    private class RenameAction
    extends AbstractAction {
        private RenameAction() {
            this.putValue("Name", NbBundle.getMessage(Sprite.class, (String)"Sprite.RenameAction.text"));
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            RenameSpriteDialog dialog = new RenameSpriteDialog(Sprite.this);
            DialogDescriptor dd = new DialogDescriptor((Object)dialog, NbBundle.getMessage(Sprite.class, (String)"Sprite.RenameAction.text"));
            dd.setButtonListener((ActionListener)dialog);
            dd.setValid(false);
            dialog.setDialogDescriptor(dd);
            Dialog d = DialogDisplayer.getDefault().createDialog(dd);
            d.setVisible(true);
        }
    }
}

