/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.view;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JLabel;
import org.netbeans.modules.vmd.game.dialog.NewSceneDialog;
import org.netbeans.modules.vmd.game.model.GlobalRepository;
import org.netbeans.modules.vmd.game.model.GlobalRepositoryListener;
import org.netbeans.modules.vmd.game.model.ImageResource;
import org.netbeans.modules.vmd.game.model.Scene;
import org.netbeans.modules.vmd.game.model.Sprite;
import org.netbeans.modules.vmd.game.model.TiledLayer;
import org.netbeans.modules.vmd.game.nbdialog.SpriteDialog;
import org.netbeans.modules.vmd.game.nbdialog.TiledLayerDialog;
import org.netbeans.modules.vmd.game.view.ColorConstants;
import org.netbeans.modules.vmd.game.view.GameDesignPreviewComponent;
import org.netbeans.modules.vmd.game.view.ImagePreviewComponent;
import org.netbeans.modules.vmd.game.view.ScrollableFlowPanel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.util.NbBundle;

public class GameDesignOverViewPanel
extends ScrollableFlowPanel
implements ComponentListener {
    private GlobalRepository gameDesign;
    private JLabel labelTiledLayers;
    private JLabel labelSprites;
    private JLabel labelScenes;
    private ScrollableFlowPanel panelTiledLayers = new ScrollableFlowPanel();
    private ScrollableFlowPanel panelSprites = new ScrollableFlowPanel();
    private ScrollableFlowPanel panelScenes = new ScrollableFlowPanel();
    private Map<TiledLayer, GameDesignPreviewComponent> tiledLayerPreviews = new HashMap<TiledLayer, GameDesignPreviewComponent>();
    private Map<Sprite, GameDesignPreviewComponent> spritePreviews = new HashMap<Sprite, GameDesignPreviewComponent>();
    private Map<Scene, GameDesignPreviewComponent> scenePreviews = new HashMap<Scene, GameDesignPreviewComponent>();

    public GameDesignOverViewPanel(final GlobalRepository gameDesign) {
        this.gameDesign = gameDesign;
        this.gameDesign.addGlobalRepositoryListener(new GlobalRepositoryListener(){

            @Override
            public void sceneAdded(Scene scene, int index) {
                GameDesignPreviewComponent preview = new GameDesignPreviewComponent(gameDesign, scene.getPreview(), scene.getName(), scene);
                GameDesignOverViewPanel.this.panelScenes.add((Component)preview, index);
                GameDesignOverViewPanel.this.panelScenes.revalidate();
                GameDesignOverViewPanel.this.panelScenes.repaint();
                GameDesignOverViewPanel.this.scenePreviews.put(scene, preview);
            }

            @Override
            public void sceneRemoved(Scene scene, int index) {
                JComponent preview = (JComponent)GameDesignOverViewPanel.this.scenePreviews.remove(scene);
                if (preview != null) {
                    GameDesignOverViewPanel.this.panelScenes.remove(preview);
                    GameDesignOverViewPanel.this.panelScenes.revalidate();
                    GameDesignOverViewPanel.this.panelScenes.repaint();
                }
            }

            @Override
            public void tiledLayerAdded(TiledLayer tiledLayer, int index) {
                GameDesignPreviewComponent preview = new GameDesignPreviewComponent(gameDesign, tiledLayer.getPreview(), tiledLayer.getName(), tiledLayer);
                GameDesignOverViewPanel.this.panelTiledLayers.add((Component)preview, index);
                GameDesignOverViewPanel.this.panelTiledLayers.revalidate();
                GameDesignOverViewPanel.this.panelTiledLayers.repaint();
                GameDesignOverViewPanel.this.tiledLayerPreviews.put(tiledLayer, preview);
            }

            @Override
            public void tiledLayerRemoved(TiledLayer tiledLayer, int index) {
                JComponent preview = (JComponent)GameDesignOverViewPanel.this.tiledLayerPreviews.remove(tiledLayer);
                if (preview != null) {
                    GameDesignOverViewPanel.this.panelTiledLayers.remove(preview);
                    GameDesignOverViewPanel.this.panelTiledLayers.revalidate();
                    GameDesignOverViewPanel.this.panelTiledLayers.repaint();
                }
            }

            @Override
            public void spriteAdded(Sprite sprite, int index) {
                ImagePreviewComponent imagePreviewComponent = new ImagePreviewComponent(true);
                imagePreviewComponent.setPreviewable(sprite.getDefaultSequence().getFrame(0));
                GameDesignPreviewComponent preview = new GameDesignPreviewComponent(gameDesign, imagePreviewComponent, sprite.getName(), sprite);
                GameDesignOverViewPanel.this.panelSprites.add((Component)preview, index);
                GameDesignOverViewPanel.this.panelSprites.revalidate();
                GameDesignOverViewPanel.this.panelSprites.repaint();
                GameDesignOverViewPanel.this.spritePreviews.put(sprite, preview);
            }

            @Override
            public void spriteRemoved(Sprite sprite, int index) {
                JComponent preview = (JComponent)GameDesignOverViewPanel.this.spritePreviews.remove(sprite);
                if (preview != null) {
                    GameDesignOverViewPanel.this.panelSprites.remove(preview);
                    GameDesignOverViewPanel.this.panelSprites.revalidate();
                    GameDesignOverViewPanel.this.panelSprites.repaint();
                }
            }

            @Override
            public void imageResourceAdded(ImageResource imageResource) {
            }
        });
        this.manualInit();
        this.addComponentListener(this);
        this.putClientProperty("print.printable", Boolean.TRUE);
    }

    private void manualInit() {
        this.setBackground(ColorConstants.COLOR_EDITOR_PANEL);
        this.panelTiledLayers.setBackground(ColorConstants.COLOR_EDITOR_PANEL);
        this.panelSprites.setBackground(ColorConstants.COLOR_EDITOR_PANEL);
        this.panelScenes.setBackground(ColorConstants.COLOR_EDITOR_PANEL);
        ((FlowLayout)this.getLayout()).setAlignment(0);
        ((FlowLayout)this.panelTiledLayers.getLayout()).setAlignment(0);
        ((FlowLayout)this.panelSprites.getLayout()).setAlignment(0);
        ((FlowLayout)this.panelScenes.getLayout()).setAlignment(0);
        this.labelScenes = new JLabel(NbBundle.getMessage(GameDesignOverViewPanel.class, (String)"GameDesignOverViewPanel.labelScenes.txt"));
        this.labelScenes.setFont(new Font("Dialog", 1, this.labelScenes.getFont().getSize() + 7));
        this.labelScenes.setForeground(ColorConstants.COLOR_TEXT_PLAIN);
        this.labelScenes.setHorizontalAlignment(2);
        this.add(this.labelScenes);
        this.add(this.panelScenes);
        this.labelTiledLayers = new JLabel(NbBundle.getMessage(GameDesignOverViewPanel.class, (String)"GameDesignOverViewPanel.labelTiledLayers.txt"));
        this.labelTiledLayers.setFont(new Font("Dialog", 1, this.labelTiledLayers.getFont().getSize() + 7));
        this.labelTiledLayers.setForeground(new Color(163, 184, 215));
        this.labelTiledLayers.setHorizontalAlignment(2);
        this.add(this.labelTiledLayers);
        this.add(this.panelTiledLayers);
        this.labelSprites = new JLabel(NbBundle.getMessage(GameDesignOverViewPanel.class, (String)"GameDesignOverViewPanel.labelSprites.txt"));
        this.labelSprites.setFont(new Font("Dialog", 1, this.labelSprites.getFont().getSize() + 7));
        this.labelSprites.setForeground(ColorConstants.COLOR_TEXT_PLAIN);
        this.labelSprites.setHorizontalAlignment(2);
        this.add(this.labelSprites);
        this.add(this.panelSprites);
        this.populateScenePreviewList(this.panelScenes);
        this.populateTiledLayerPreviewList(this.panelTiledLayers);
        this.populateSpritePreviewList(this.panelSprites);
        this.getAccessibleContext().setAccessibleName(NbBundle.getMessage(GameDesignOverViewPanel.class, (String)"GameDesignOverViewPanel.accessible.name"));
        this.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(GameDesignOverViewPanel.class, (String)"GameDesignOverViewPanel.accessible.description"));
    }

    private void populateTiledLayerPreviewList(JComponent container) {
        List<TiledLayer> layers = this.gameDesign.getTiledLayers();
        for (TiledLayer tiledLayer : layers) {
            GameDesignPreviewComponent preview = new GameDesignPreviewComponent(this.gameDesign, tiledLayer.getPreview(), tiledLayer.getName(), tiledLayer);
            container.add(preview);
            this.tiledLayerPreviews.put(tiledLayer, preview);
        }
        final JLabel lblCreate = new JLabel(NbBundle.getMessage(GameDesignOverViewPanel.class, (String)"GameDesignOverViewPanel.labelNewTiledLayer.txt"));
        lblCreate.setPreferredSize(new Dimension(lblCreate.getPreferredSize().width + 15, 40));
        lblCreate.setForeground(new Color(100, 123, 156));
        lblCreate.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                lblCreate.setFont(lblCreate.getFont().deriveFont(1));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                lblCreate.setFont(lblCreate.getFont().deriveFont(0));
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                TiledLayerDialog nld = new TiledLayerDialog(GameDesignOverViewPanel.this.gameDesign);
                DialogDescriptor dd = new DialogDescriptor((Object)nld, NbBundle.getMessage(GameDesignOverViewPanel.class, (String)"GameDesignOverViewPanel.dialogNewTiledLayer.txt"));
                dd.setButtonListener((ActionListener)nld);
                dd.setValid(false);
                nld.setDialogDescriptor(dd);
                Dialog d = DialogDisplayer.getDefault().createDialog(dd);
                d.setVisible(true);
            }
        });
        container.add(lblCreate);
    }

    private void populateSpritePreviewList(JComponent container) {
        List<Sprite> sprites = this.gameDesign.getSprites();
        for (Sprite sprite : sprites) {
            ImagePreviewComponent imagePreviewComponent = new ImagePreviewComponent(true);
            imagePreviewComponent.setPreviewable(sprite.getDefaultSequence().getFrame(0));
            GameDesignPreviewComponent preview = new GameDesignPreviewComponent(this.gameDesign, imagePreviewComponent, sprite.getName(), sprite);
            container.add(preview);
            this.spritePreviews.put(sprite, preview);
        }
        final JLabel lblCreate = new JLabel(NbBundle.getMessage(GameDesignOverViewPanel.class, (String)"GameDesignOverViewPanel.labelNewSprite.txt"));
        lblCreate.setPreferredSize(new Dimension(lblCreate.getPreferredSize().width + 15, 40));
        lblCreate.setForeground(new Color(100, 123, 156));
        lblCreate.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                lblCreate.setFont(lblCreate.getFont().deriveFont(1));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                lblCreate.setFont(lblCreate.getFont().deriveFont(0));
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                SpriteDialog nld = new SpriteDialog(GameDesignOverViewPanel.this.gameDesign);
                DialogDescriptor dd = new DialogDescriptor((Object)nld, NbBundle.getMessage(GameDesignOverViewPanel.class, (String)"GameDesignOverViewPanel.dialogNewSprite.txt"));
                dd.setButtonListener((ActionListener)nld);
                dd.setValid(false);
                nld.setDialogDescriptor(dd);
                Dialog d = DialogDisplayer.getDefault().createDialog(dd);
                d.setVisible(true);
            }
        });
        container.add(lblCreate);
    }

    private void populateScenePreviewList(JComponent container) {
        List<Scene> scenes = this.gameDesign.getScenes();
        for (Scene scene : scenes) {
            GameDesignPreviewComponent preview = new GameDesignPreviewComponent(this.gameDesign, scene.getPreview(), scene.getName(), scene);
            container.add(preview);
            this.scenePreviews.put(scene, preview);
        }
        final JLabel lblCreate = new JLabel(NbBundle.getMessage(GameDesignOverViewPanel.class, (String)"GameDesignOverViewPanel.labelNewScene.txt"));
        lblCreate.setPreferredSize(new Dimension(lblCreate.getPreferredSize().width + 15, 40));
        lblCreate.setForeground(new Color(100, 123, 156));
        lblCreate.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                lblCreate.setFont(lblCreate.getFont().deriveFont(1));
            }

            @Override
            public void mouseExited(MouseEvent e) {
                lblCreate.setFont(lblCreate.getFont().deriveFont(0));
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                NewSceneDialog dialog = new NewSceneDialog(GameDesignOverViewPanel.this.gameDesign);
                DialogDescriptor dd = new DialogDescriptor((Object)dialog, NbBundle.getMessage(GameDesignOverViewPanel.class, (String)"GameDesignOverViewPanel.dialogNewScene.txt"));
                dd.setButtonListener((ActionListener)dialog);
                dd.setValid(false);
                dialog.setDialogDescriptor(dd);
                Dialog d = DialogDisplayer.getDefault().createDialog(dd);
                d.setVisible(true);
            }
        });
        container.add(lblCreate);
    }

    private void resizeLabels() {
        Dimension d = this.labelTiledLayers.getPreferredSize();
        this.labelTiledLayers.setPreferredSize(new Dimension(this.getWidth(), d.getSize().height));
        d = this.labelSprites.getPreferredSize();
        this.labelSprites.setPreferredSize(new Dimension(this.getWidth(), d.getSize().height));
        d = this.labelScenes.getPreferredSize();
        this.labelScenes.setPreferredSize(new Dimension(this.getWidth(), d.getSize().height));
    }

    @Override
    public void componentResized(ComponentEvent e) {
        this.resizeLabels();
    }

    @Override
    public void componentMoved(ComponentEvent e) {
        this.resizeLabels();
    }

    @Override
    public void componentShown(ComponentEvent e) {
        this.resizeLabels();
    }

    @Override
    public void componentHidden(ComponentEvent e) {
    }
}

