/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.game.view.main;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.event.EventListenerList;
import org.netbeans.modules.vmd.game.editor.grid.ResourceImageEditor;
import org.netbeans.modules.vmd.game.editor.tiledlayer.TiledLayerEditor;
import org.netbeans.modules.vmd.game.model.Editable;
import org.netbeans.modules.vmd.game.model.EditorManager;
import org.netbeans.modules.vmd.game.model.EditorManagerListener;
import org.netbeans.modules.vmd.game.model.GlobalRepository;
import org.netbeans.modules.vmd.game.model.GlobalRepositoryListener;
import org.netbeans.modules.vmd.game.model.ImageResource;
import org.netbeans.modules.vmd.game.model.Previewable;
import org.netbeans.modules.vmd.game.model.Scene;
import org.netbeans.modules.vmd.game.model.Sprite;
import org.netbeans.modules.vmd.game.model.Tile;
import org.netbeans.modules.vmd.game.model.TiledLayer;

public class MainView
implements GlobalRepositoryListener,
EditorManager {
    public static final boolean DEBUG = false;
    EventListenerList listenerList = new EventListenerList();
    private GlobalRepository gameDesign;
    private Editable currentEditable;
    private JPanel rootPanel;
    private JSplitPane mainSplit;
    private JSplitPane previewExplorerSplit;
    private JPanel mainEditorPanel;
    Map<Editable, JSplitPane> splits = new HashMap<Editable, JSplitPane>();

    public MainView(GlobalRepository gameDesign) {
        this.gameDesign = gameDesign;
        this.initComponents();
        this.initLayout();
    }

    private void initComponents() {
        this.rootPanel = new JPanel();
        this.rootPanel.setLayout(new BorderLayout());
        this.rootPanel.setBackground(Color.WHITE);
        this.mainEditorPanel = new JPanel();
        this.mainEditorPanel.setBorder(null);
        this.mainEditorPanel.setBackground(Color.WHITE);
    }

    private void initLayout() {
        this.mainEditorPanel.setLayout(new BorderLayout());
        this.mainSplit = new JSplitPane(1, false, this.previewExplorerSplit, this.mainEditorPanel);
        this.mainSplit.setDividerLocation(230);
        this.mainSplit.setDividerSize(5);
        this.mainSplit.setOneTouchExpandable(false);
        this.mainSplit.setResizeWeight(0.0);
        this.rootPanel.add((Component)this.mainEditorPanel, "Center");
    }

    public void paintTileChanged(Tile tile) {
        if (tile == null) {
            return;
        }
        Editable editable = this.currentEditable;
        if (editable == null) {
            return;
        }
        JComponent editor = editable.getEditor();
        if (editor instanceof TiledLayerEditor) {
            TiledLayerEditor tiledLayerEditor = (TiledLayerEditor)editor;
            tiledLayerEditor.setPaintTile(tile);
        }
    }

    @Override
    public void sceneAdded(Scene scene, int index) {
        this.requestEditing(scene);
    }

    @Override
    public void sceneRemoved(Scene scene, int index) {
        this.requestEditing(this.gameDesign);
    }

    @Override
    public void tiledLayerAdded(TiledLayer tiledLayer, int index) {
        this.requestEditing(tiledLayer);
    }

    @Override
    public void tiledLayerRemoved(TiledLayer tiledLayer, int index) {
        this.requestEditing(this.gameDesign);
    }

    @Override
    public void spriteAdded(Sprite sprite, int index) {
        if (this.rootPanel.isShowing()) {
            this.requestEditing(sprite);
        }
    }

    @Override
    public void spriteRemoved(Sprite sprite, int index) {
        this.requestEditing(this.gameDesign);
    }

    @Override
    public void imageResourceAdded(ImageResource imageResource) {
    }

    @Override
    public void requestEditing(Editable editable) {
        if (this.currentEditable == editable) {
            return;
        }
        this.currentEditable = editable;
        Editable.ImageResourceInfo resource = this.currentEditable.getImageResourceInfo();
        JComponent editor = this.currentEditable.getEditor();
        this.mainEditorPanel.removeAll();
        if (resource != null) {
            JSplitPane split = this.splits.get(this.currentEditable);
            if (split == null) {
                split = new JSplitPane(0, false);
                split.setDividerLocation(400);
                split.setResizeWeight(1.0);
                split.setOneTouchExpandable(false);
                split.setDividerSize(5);
                split.setTopComponent(editor);
                ResourceImageEditor resourceImageView = new ResourceImageEditor();
                resourceImageView.setImageResourceInfo(resource);
                split.setBottomComponent(resourceImageView);
                split.setOneTouchExpandable(false);
                split.setDividerSize(5);
                this.splits.put(this.currentEditable, split);
            }
            this.mainEditorPanel.add(split);
        } else {
            this.mainEditorPanel.add(editor);
        }
        this.mainEditorPanel.repaint();
        this.mainEditorPanel.validate();
        this.fireEditingChanged(this.currentEditable);
    }

    private void fireEditingChanged(Editable editable) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != EditorManagerListener.class) continue;
            ((EditorManagerListener)listeners[i + 1]).editing(editable);
        }
    }

    public void requestPreview(Previewable previewable) {
        JComponent previewComponent = previewable.getPreview();
        if (previewComponent != null) {
            return;
        }
    }

    public void closeEditor(Editable editable) {
        if (this.currentEditable == editable) {
            SwingUtilities.invokeLater(new EditorDisposer());
        }
    }

    public static void center(JFrame frame) {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        Point center = ge.getCenterPoint();
        Rectangle bounds = ge.getMaximumWindowBounds();
        int w = Math.min(frame.getWidth(), bounds.width);
        int h = Math.min(frame.getHeight(), bounds.height);
        int x = center.x - w / 2;
        int y = center.y - h / 2;
        frame.setBounds(x, y, w, h);
        if (w == bounds.width && h == bounds.height) {
            frame.setExtendedState(6);
        }
        frame.validate();
    }

    public JComponent getRootComponent() {
        return this.rootPanel;
    }

    @Override
    public void addEditorManagerListener(EditorManagerListener l) {
        this.listenerList.add(EditorManagerListener.class, l);
    }

    @Override
    public void removeEditorManagerListener(EditorManagerListener l) {
        this.listenerList.remove(EditorManagerListener.class, l);
    }

    public Editable getCurrentEditable() {
        return this.currentEditable;
    }

    private class EditorDisposer
    implements Runnable {
        private EditorDisposer() {
        }

        @Override
        public void run() {
            MainView.this.currentEditable = null;
            MainView.this.mainEditorPanel.removeAll();
            MainView.this.mainEditorPanel.repaint();
            MainView.this.mainEditorPanel.validate();
        }
    }
}

