/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.disk;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.netbeans.modules.cnd.repository.api.DatabaseTable;
import org.netbeans.modules.cnd.repository.api.Repository;
import org.netbeans.modules.cnd.repository.api.RepositoryAccessor;
import org.netbeans.modules.cnd.repository.api.RepositoryException;
import org.netbeans.modules.cnd.repository.api.RepositoryTranslation;
import org.netbeans.modules.cnd.repository.disk.StorageAllocator;
import org.netbeans.modules.cnd.repository.disk.Unit;
import org.netbeans.modules.cnd.repository.disk.UnitImpl;
import org.netbeans.modules.cnd.repository.queue.KeyValueQueue;
import org.netbeans.modules.cnd.repository.queue.RepositoryQueue;
import org.netbeans.modules.cnd.repository.queue.RepositoryThreadManager;
import org.netbeans.modules.cnd.repository.queue.RepositoryWriter;
import org.netbeans.modules.cnd.repository.spi.Key;
import org.netbeans.modules.cnd.repository.spi.Persistent;
import org.netbeans.modules.cnd.repository.spi.RepositoryListener;
import org.netbeans.modules.cnd.repository.translator.RepositoryTranslatorImpl;
import org.netbeans.modules.cnd.repository.util.RepositoryListenersManager;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.openide.util.CharSequences;

public class DiskRepositoryManager
implements Repository,
RepositoryWriter {
    private final Map<Integer, Unit> units;
    private final RepositoryQueue queue;
    private final RepositoryThreadManager threadManager;
    private final Persistent removedObject;
    private final ReadWriteLock queueLock;
    private final Map<Integer, Object> unitLocks = new HashMap<Integer, Object>();
    private final Object mainUnitLock = new UnitLock();
    private final RepositoryTranslation translator = RepositoryAccessor.getTranslator();

    public DiskRepositoryManager() {
        this.removedObject = new RemovedPersistent();
        this.queueLock = new ReentrantReadWriteLock(true);
        this.threadManager = new RepositoryThreadManager(this, this.queueLock);
        this.queue = this.threadManager.startup();
        this.units = new ConcurrentHashMap<Integer, Unit>();
    }

    public DatabaseTable getDatabaseTable(Key unitKey, String tableID) {
        try {
            UnitImpl impl = (UnitImpl)this.getCreateUnit(unitKey);
            return impl.getDatabaseTable(tableID);
        }
        catch (Throwable ex) {
            RepositoryListenersManager.getInstance().fireAnException(this.getUnitNameSafe(unitKey), new RepositoryException(ex));
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object getUnitLock(int unitId) {
        Object object = this.mainUnitLock;
        synchronized (object) {
            Object lock = this.unitLocks.get(unitId);
            if (lock == null) {
                lock = new NamedLock("unitId=" + unitId);
                this.unitLocks.put(unitId, lock);
            }
            return lock;
        }
    }

    private Unit getCreateUnit(Key key) throws IOException {
        assert (key != null);
        Unit unit = this.units.get(key.getUnitId());
        if (unit != null) {
            return unit;
        }
        return this.getCreateUnit(key.getUnitId(), key.getUnit());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Unit getCreateUnit(int unitId, CharSequence unitName) throws IOException {
        assert (unitName != null);
        Unit unit = this.units.get(unitId);
        if (unit == null) {
            unit = null;
            Object object = this.getUnitLock(unitId);
            synchronized (object) {
                unit = this.units.get(unitId);
                if (unit == null && RepositoryListenersManager.getInstance().fireUnitOpenedEvent(unitName)) {
                    RepositoryTranslatorImpl.loadUnitIndex(unitName);
                    unit = new UnitImpl(unitId, unitName);
                    this.units.put(unitId, unit);
                }
            }
        }
        return unit;
    }

    public void put(Key key, Persistent obj) {
        try {
            this.getCreateUnit(key).putToCache(key, obj);
            this.queue.addLast(key, obj);
        }
        catch (Throwable ex) {
            RepositoryListenersManager.getInstance().fireAnException(this.getUnitNameSafe(key), new RepositoryException(ex));
        }
    }

    public void hang(Key key, Persistent obj) {
        try {
            this.getCreateUnit(key).hang(key, obj);
        }
        catch (Throwable ex) {
            RepositoryListenersManager.getInstance().fireAnException(this.getUnitNameSafe(key), new RepositoryException(ex));
        }
    }

    @Override
    public void write(Key key, Persistent object) {
        try {
            Unit diskRep = this.getCreateUnit(key);
            if (object instanceof RemovedPersistent) {
                diskRep.removePhysically(key);
            } else {
                diskRep.putPhysically(key, object);
            }
        }
        catch (Throwable ex) {
            RepositoryListenersManager.getInstance().fireAnException(this.getUnitNameSafe(key), new RepositoryException(ex));
        }
    }

    public Persistent get(Key key) {
        try {
            return this.getCreateUnit(key).get(key);
        }
        catch (Throwable ex) {
            RepositoryListenersManager.getInstance().fireAnException(this.getUnitNameSafe(key), new RepositoryException(ex));
            return null;
        }
    }

    public Persistent tryGet(Key key) {
        try {
            return this.getCreateUnit(key).tryGet(key);
        }
        catch (Throwable ex) {
            RepositoryListenersManager.getInstance().fireAnException(this.getUnitNameSafe(key), new RepositoryException(ex));
            return null;
        }
    }

    public void remove(Key key) {
        try {
            this.getCreateUnit(key).removeFromCache(key);
            this.queue.addLast(key, this.removedObject);
        }
        catch (Throwable ex) {
            RepositoryListenersManager.getInstance().fireAnException(this.getUnitNameSafe(key), new RepositoryException(ex));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        if (this.threadManager != null) {
            this.threadManager.shutdown();
        }
        ArrayList<Map.Entry<Integer, Unit>> entries = new ArrayList<Map.Entry<Integer, Unit>>(this.units.entrySet());
        for (Map.Entry entry : entries) {
            this.closeUnit(this.translator.getUnitName(((Integer)entry.getKey()).intValue()), true, null);
        }
        try {
            this.queueLock.writeLock().lock();
            this.cleanAndWriteQueue();
            this.units.clear();
        }
        finally {
            this.queueLock.writeLock().unlock();
        }
        RepositoryTranslatorImpl.shutdown();
    }

    @Override
    public boolean maintenance(long timeout) {
        if (this.units.isEmpty()) {
            return false;
        }
        Collection<Unit> values = this.units.values();
        Unit[] unitList = values.toArray(new Unit[values.size()]);
        Arrays.sort(unitList, new MaintenanceComparator());
        boolean needMoreTime = false;
        long start = System.currentTimeMillis();
        for (int i = 0; i < unitList.length; ++i) {
            if (timeout <= 0L) {
                needMoreTime = true;
                break;
            }
            try {
                if (unitList[i].maintenance(timeout)) {
                    needMoreTime = true;
                }
            }
            catch (IOException ex) {
                RepositoryListenersManager.getInstance().fireAnException(unitList[i].getName(), new RepositoryException((Throwable)ex));
            }
            timeout -= System.currentTimeMillis() - start;
        }
        return needMoreTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void openUnit(int unitId, CharSequence unitName) {
        try {
            Object object = this.getUnitLock(unitId);
            synchronized (object) {
                this.getCreateUnit(unitId, unitName);
            }
        }
        catch (Throwable exc) {
            RepositoryListenersManager.getInstance().fireAnException(unitName, new RepositoryException(exc));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeUnit(CharSequence unitName, boolean cleanRepository, Set<CharSequence> requiredUnits) {
        int unitId = this.translator.getUnitId(unitName);
        Object object = this.getUnitLock(unitId);
        synchronized (object) {
            this.closeUnit2(unitName, cleanRepository, requiredUnits);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeUnit2(CharSequence unitName, boolean cleanRepository, Set<CharSequence> requiredUnits) {
        Collection<KeyValueQueue.Entry<Key, Persistent>> clearQueue;
        try {
            int unitId;
            Unit unit;
            this.queueLock.writeLock().lock();
            Collection<KeyValueQueue.Entry<Key, Persistent>> removedEntries = this.queue.clearQueue(new UnitFilter(unitName));
            if (!cleanRepository) {
                for (KeyValueQueue.Entry<Key, Persistent> entry : removedEntries) {
                    this.write(entry.getKey(), entry.getValue());
                }
            }
            if ((unit = this.units.remove(unitId = this.translator.getUnitId(CharSequences.create((CharSequence)unitName)))) != null) {
                try {
                    unit.close();
                }
                catch (Throwable exc) {
                    RepositoryListenersManager.getInstance().fireAnException(unitName, new RepositoryException(exc));
                }
            }
        }
        finally {
            this.queueLock.writeLock().unlock();
        }
        if (CndUtils.isDebugMode() && !(clearQueue = this.queue.clearQueue(new UnitFilter(unitName))).isEmpty()) {
            System.err.println("UNSAVED ENTRIES FOR " + unitName);
            for (KeyValueQueue.Entry<Key, Persistent> entry : clearQueue) {
                System.err.printf("\t%s\n\t%s\n", entry.getKey(), entry.getValue());
            }
        }
        StorageAllocator allocator = StorageAllocator.getInstance();
        if (cleanRepository) {
            allocator.deleteUnitFiles(unitName, true);
        }
        allocator.closeUnit(unitName);
        RepositoryTranslatorImpl.closeUnit(unitName, requiredUnits);
        RepositoryListenersManager.getInstance().fireUnitClosedEvent(unitName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeUnit(CharSequence unitName) {
        int unitId = this.translator.getUnitId(CharSequences.create((CharSequence)unitName));
        Object object = this.getUnitLock(unitId);
        synchronized (object) {
            this.closeUnit(unitName, true, Collections.<CharSequence>emptySet());
            RepositoryTranslatorImpl.removeUnit(unitName);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void debugClear() {
        ArrayList<Map.Entry<Integer, Unit>> entries = new ArrayList<Map.Entry<Integer, Unit>>(this.units.entrySet());
        for (Map.Entry entry : entries) {
            ((Unit)entry.getValue()).debugClear();
        }
        try {
            this.queueLock.writeLock().lock();
            this.cleanAndWriteQueue();
        }
        finally {
            this.queueLock.writeLock().unlock();
        }
    }

    private void cleanAndWriteQueue() {
        Collection<KeyValueQueue.Entry<Key, Persistent>> removedEntries = this.queue.clearQueue(new AllFilter());
        for (KeyValueQueue.Entry<Key, Persistent> entry : removedEntries) {
            this.write(entry.getKey(), entry.getValue());
        }
    }

    public void cleanCaches() {
        StorageAllocator.getInstance().cleanRepositoryCaches();
    }

    public void registerRepositoryListener(RepositoryListener aListener) {
    }

    public void unregisterRepositoryListener(RepositoryListener aListener) {
    }

    public void startup(int persistMechanismVersion) {
    }

    public void debugDistribution() {
        for (Unit unit : this.units.values()) {
            System.err.println("UNIT " + unit.getName());
            unit.debugDistribution();
        }
    }

    private static int getMaintenanceWeight(Unit unit) {
        try {
            return unit.getMaintenanceWeight();
        }
        catch (IOException ex) {
            RepositoryListenersManager.getInstance().fireAnException(unit.getName(), new RepositoryException((Throwable)ex));
            return 0;
        }
    }

    private CharSequence getUnitNameSafe(Key key) {
        return this.translator.getUnitNameSafe(key.getUnitId());
    }

    private static final class NamedLock {
        private final String name;

        public NamedLock(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }

        public boolean equals(Object obj) {
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            NamedLock other = (NamedLock)obj;
            return !(this.name == null ? other.name != null : !this.name.equals(other.name));
        }

        public int hashCode() {
            int hash = 5;
            hash = 97 * hash + (this.name != null ? this.name.hashCode() : 0);
            return hash;
        }
    }

    private static class MaintenanceComparator
    implements Comparator<Unit>,
    Serializable {
        private static final long serialVersionUID = 7249069246763182397L;

        private MaintenanceComparator() {
        }

        @Override
        public int compare(Unit o1, Unit o2) {
            return DiskRepositoryManager.getMaintenanceWeight(o2) - DiskRepositoryManager.getMaintenanceWeight(o1);
        }
    }

    private static class AllFilter
    implements RepositoryQueue.Filter {
        private AllFilter() {
        }

        @Override
        public boolean accept(Key key, Persistent value) {
            return true;
        }
    }

    private static class UnitFilter
    implements RepositoryQueue.Filter {
        private CharSequence unitName;

        public UnitFilter(CharSequence unitName) {
            this.unitName = unitName;
        }

        @Override
        public boolean accept(Key key, Persistent value) {
            return key.getUnit().equals(this.unitName);
        }
    }

    private static class RemovedPersistent
    implements Persistent {
        private RemovedPersistent() {
        }
    }

    private static final class UnitLock {
        private UnitLock() {
        }
    }
}

