/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.repository.queue;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import org.netbeans.modules.cnd.repository.queue.BaseQueue;

public class KeyValueQueue<K, V>
extends BaseQueue {
    protected final Map<K, Entry<K, V>> map = new HashMap<K, Entry<K, V>>();
    private final EventsDispatcher<K, V> dispatcher = new EventsDispatcher(this);
    protected boolean active = true;

    public KeyValueQueue() {
        super(new BaseQueue.Queue());
        this.dispatcher.start();
    }

    public void addLast(K key, V value) {
        if (this.needsTrace()) {
            System.err.printf("%s: addLast %s\n", this.getTraceName(), key.toString());
        }
        this.dispatcher.newEvent(this.createEntry(key, value));
    }

    protected final void pushLastFromDispatcher() {
        ((EventsDispatcher)this.dispatcher).pushLast();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addLastImpl(K key, V value) {
        Object object = this.lock;
        synchronized (object) {
            Entry<K, V> entry = this.map.get(key);
            if (entry == null) {
                this.doAddLast(key, value);
                if (this.needsTrace()) {
                    System.err.printf("%s: added last %s\n", this.getTraceName(), key.toString());
                }
            } else {
                this.doReplaceAddLast(key, value, entry);
                if (this.needsTrace()) {
                    System.err.printf("%s: replaced last %s\n", this.getTraceName(), key.toString());
                }
            }
            this.lock.notifyAll();
        }
    }

    private Entry<K, V> doAddLast(K key, V value) {
        Entry<K, V> entry = this.createEntry(key, value);
        this.map.put(key, entry);
        this.queue.addLast(entry);
        return entry;
    }

    protected Entry<K, V> createEntry(K key, V value) {
        return new Entry<K, V>(key, value);
    }

    protected void doReplaceAddLast(K key, V value, Entry<K, V> existent) {
        ((Entry)existent).value = value;
    }

    protected void doReplaceAddFirst(K key, V value, Entry<K, V> existent) {
        ((Entry)existent).value = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Entry<K, V> poll() throws InterruptedException {
        if (this.needsTrace()) {
            System.err.printf("%s: Polling...\n", this.getTraceName());
        }
        Object object = this.lock;
        synchronized (object) {
            Entry entry;
            try {
                Entry e = (Entry)this.queue.poll();
                if (e != null) {
                    this.doPostPoll(e);
                    if (this.needsTrace()) {
                        System.err.printf("    %s: polling -> %s\n", this.getTraceName(), e.getKey());
                    }
                }
                entry = e;
                this.lock.notifyAll();
            }
            catch (Throwable throwable) {
                this.lock.notifyAll();
                throw throwable;
            }
            return entry;
        }
    }

    protected void doPostPoll(Entry<K, V> polled) {
        this.map.remove(polled.getKey());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(K key) {
        if (this.needsTrace()) {
            System.err.printf("%s: Removing %s\n", this.getTraceName(), key);
        }
        Object object = this.lock;
        synchronized (object) {
            Entry<K, V> e = this.map.remove(key);
            if (e != null) {
                this.queue.remove(e);
            }
            this.lock.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitReady() throws InterruptedException {
        Object object = this.lock;
        synchronized (object) {
            while (this.active && !this.isReady()) {
                if (this.needsTrace()) {
                    System.err.printf("%s: waitReady() ...\n", this.getTraceName());
                }
                this.lock.wait();
                if (!this.needsTrace()) continue;
                System.err.printf("%s: waiting finished\n", this.getTraceName());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isReady() {
        Object object = this.lock;
        synchronized (object) {
            return !this.queue.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean disposable() {
        Object object = this.lock;
        synchronized (object) {
            return this.queue.isEmpty();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        this.active = false;
        this.dispatcher.interrupt();
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }

    private static final class EventsDispatcher<KK, VV>
    extends Thread {
        private final KeyValueQueue<KK, VV> delegate;
        private final BlockingQueue<Entry<KK, VV>> queue = new LinkedBlockingQueue<Entry<KK, VV>>();
        private AtomicLong request = new AtomicLong(0L);
        private AtomicLong response = new AtomicLong(0L);

        public EventsDispatcher(KeyValueQueue<KK, VV> delegate) {
            super("CND Repository Queue Dispatcher");
            this.delegate = delegate;
        }

        void newEvent(Entry<KK, VV> entry) {
            this.request.incrementAndGet();
            this.queue.add(entry);
        }

        void handleEvent(KK key, VV value) {
            ((KeyValueQueue)this.delegate).addLastImpl(key, value);
            this.response.incrementAndGet();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                while (!this.isInterrupted()) {
                    try {
                        Entry<KK, VV> event;
                        try {
                            event = this.queue.take();
                        }
                        catch (InterruptedException ex) {
                            break;
                        }
                        this.handleEvent(((Entry)event).key, ((Entry)event).value);
                    }
                    catch (Throwable th) {
                        th.printStackTrace(System.err);
                    }
                }
            }
            finally {
                this.response.set(0x3FFFFFFFFFFFFFFFL);
            }
        }

        private void pushLast() {
            long last = this.request.get();
            do {
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            } while (last > this.response.get());
        }
    }

    public static class Entry<KK, VV>
    extends BaseQueue.AbstractEntry {
        private KK key;
        private VV value;

        protected Entry(KK key, VV value) {
            assert (key != null);
            assert (value != null);
            this.key = key;
            this.value = value;
        }

        public KK getKey() {
            return this.key;
        }

        public VV getValue() {
            return this.value;
        }
    }
}

