/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.vmd.api.model;

import java.util.Collection;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.CompoundEdit;
import javax.swing.undo.UndoableEdit;
import org.netbeans.modules.vmd.api.model.Debug;
import org.netbeans.modules.vmd.api.model.DescriptorRegistry;
import org.netbeans.modules.vmd.api.model.DesignComponent;
import org.netbeans.modules.vmd.api.model.DesignDocument;
import org.netbeans.modules.vmd.api.model.DesignEvent;
import org.netbeans.modules.vmd.api.model.ListenerManager;
import org.netbeans.modules.vmd.api.model.Presenter;
import org.netbeans.modules.vmd.api.model.PropertyValue;
import org.openide.ErrorManager;
import org.openide.util.Mutex;

public final class TransactionManager {
    private final DesignDocument document;
    private final DescriptorRegistry descriptorRegistry;
    private final ListenerManager listenerManager;
    private final Mutex mutex = new Mutex();
    private boolean notRootLevelWriteAccess = false;
    private boolean assertEventAllowed = false;
    private boolean rollback = false;
    private boolean useUndoManager = false;
    private boolean discardAllEdits = false;
    private TransactionEdit transactionEdit;

    TransactionManager(DesignDocument document, DescriptorRegistry descriptorRegistry, ListenerManager listenerManager) {
        assert (Debug.isFriend(DesignDocument.class, "<init>"));
        this.document = document;
        this.descriptorRegistry = descriptorRegistry;
        this.listenerManager = listenerManager;
    }

    public void readAccess(final Runnable runnable) {
        this.descriptorRegistry.readAccess(new Runnable(){

            @Override
            public void run() {
                TransactionManager.this.mutex.readAccess(runnable);
            }
        });
    }

    public long writeAccess(final Runnable runnable) {
        final long[] eventID = new long[]{0L};
        this.descriptorRegistry.readAccess(new Runnable(){

            @Override
            public void run() {
                TransactionManager.this.mutex.writeAccess(new Runnable(){

                    @Override
                    public void run() {
                        TransactionManager.this.writeAccessCore(runnable);
                        eventID[0] = TransactionManager.this.listenerManager.getEventID();
                    }
                });
            }
        });
        return eventID[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeAccessCore(Runnable runnable) {
        boolean rootLevel = !this.notRootLevelWriteAccess;
        this.notRootLevelWriteAccess = true;
        if (rootLevel) {
            this.writeAccessRootBegin();
        }
        try {
            runnable.run();
        }
        finally {
            if (rootLevel) {
                this.writeAccessRootEnd();
            }
        }
    }

    private void writeAccessRootBegin() {
        this.assertEventAllowed = true;
        this.rollback = false;
        this.useUndoManager = true;
        this.discardAllEdits = false;
        this.transactionEdit = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeAccessRootEnd() {
        this.assertEventAllowed = false;
        DesignEvent event = null;
        try {
            if (this.rollback) {
                this.rollbackCore();
            }
            event = this.listenerManager.fireEvent();
        }
        finally {
            try {
                if (this.useUndoManager) {
                    if (this.discardAllEdits) {
                        this.document.getDocumentInterface().discardAllEdits();
                    } else if (this.transactionEdit != null) {
                        this.transactionEdit.end();
                        this.document.getDocumentInterface().undoableEditHappened(this.transactionEdit);
                    }
                }
            }
            finally {
                this.notRootLevelWriteAccess = false;
                if (event != null && event.isStructureChanged()) {
                    this.document.getDocumentInterface().notifyModified();
                }
            }
        }
    }

    public boolean isAccess() {
        return this.mutex.isReadAccess() || this.mutex.isWriteAccess();
    }

    public boolean isWriteAccess() {
        return this.mutex.isWriteAccess();
    }

    public void rollback() {
        assert (this.assertEventAllowed);
        this.rollback = true;
        this.useUndoManager = false;
    }

    private void rollbackCore() {
        if (this.discardAllEdits) {
            ErrorManager.getDefault().log(65536, "Cannot rollback operation");
            return;
        }
        ErrorManager.getDefault().log(65536, "Rollback is not supported");
    }

    void rootChangeHappened(DesignComponent root) {
        assert (Debug.isFriend(DesignDocument.class, "setRootComponent"));
        assert (this.assertEventAllowed);
        this.listenerManager.addAffectedComponentHierarchy(root);
        this.discardAllEdits = true;
    }

    void componentDescriptorChangeHappened(DesignComponent component, Collection<? extends Presenter> presentersToRemove, Collection<Presenter> presentersToAdd, boolean useUndo) {
        assert (Debug.isFriend(DesignComponent.class, "setComponentDescriptor"));
        assert (this.assertEventAllowed);
        this.listenerManager.addComponentDescriptorChanged(component, presentersToRemove, presentersToAdd);
        if (useUndo) {
            this.discardAllEdits = true;
        }
    }

    void parentChangeHappened(DesignComponent previousParent, DesignComponent parent, DesignComponent child) {
        assert (Debug.isFriend(DesignComponent.class, "addComponent") || Debug.isFriend(DesignComponent.class, "removeComponent"));
        assert (this.assertEventAllowed);
        this.listenerManager.addAffectedComponentHierarchy(previousParent);
        this.listenerManager.addAffectedComponentHierarchy(parent);
        this.listenerManager.addAffectedComponentHierarchy(child);
        this.undoableEditHappened(new SetParentEdit(previousParent, parent, child));
    }

    void writePropertyHappened(DesignComponent component, String propertyName, PropertyValue oldValue, PropertyValue newValue) {
        assert (Debug.isFriend(DesignComponent.class, "writeProperty"));
        assert (this.assertEventAllowed);
        this.listenerManager.addAffectedDesignComponent(component, propertyName, oldValue);
        this.undoableEditHappened(new WritePropertyEdit(component, propertyName, oldValue, newValue));
    }

    void selectComponentsHappened(Collection<DesignComponent> oldSelection, Collection<DesignComponent> newSelection) {
        assert (Debug.isFriend(DesignDocument.class, "setSelectedComponents"));
        assert (this.assertEventAllowed);
        this.listenerManager.setSelectionChanged();
        this.undoableEditHappened(new SelectionEdit(this.document, oldSelection, newSelection));
    }

    public void undoableEditHappened(UndoableEdit edit) {
        assert (this.isWriteAccess());
        assert (!edit.isSignificant());
        if (this.transactionEdit == null) {
            this.transactionEdit = new TransactionEdit();
        }
        this.transactionEdit.addEdit(edit);
    }

    public class SelectionEdit
    extends AbstractUndoableEdit {
        private DesignDocument document;
        private Collection<DesignComponent> oldSelection;
        private Collection<DesignComponent> newSelection;

        public SelectionEdit(DesignDocument document, Collection<DesignComponent> oldSelection, Collection<DesignComponent> newSelection) {
            this.document = document;
            this.oldSelection = oldSelection;
            this.newSelection = newSelection;
        }

        @Override
        public boolean isSignificant() {
            return false;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            this.document.setSelectedComponents(null, this.oldSelection);
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            this.document.setSelectedComponents(null, this.newSelection);
        }
    }

    public class WritePropertyEdit
    extends AbstractUndoableEdit {
        private DesignComponent component;
        private String propertyName;
        private PropertyValue oldValue;
        private PropertyValue newValue;

        public WritePropertyEdit(DesignComponent component, String propertyName, PropertyValue oldValue, PropertyValue newValue) {
            this.component = component;
            this.propertyName = propertyName;
            this.oldValue = oldValue;
            this.newValue = newValue;
        }

        @Override
        public boolean isSignificant() {
            return false;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            this.component.writeProperty(this.propertyName, this.oldValue);
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            this.component.writeProperty(this.propertyName, this.newValue);
        }
    }

    public class SetParentEdit
    extends AbstractUndoableEdit {
        private DesignComponent oldParent;
        private DesignComponent newParent;
        private DesignComponent child;

        public SetParentEdit(DesignComponent oldParent, DesignComponent newParent, DesignComponent child) {
            this.oldParent = oldParent;
            this.newParent = newParent;
            this.child = child;
        }

        @Override
        public boolean isSignificant() {
            return false;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            if (this.newParent != null) {
                this.newParent.removeComponent(this.child);
            }
            if (this.oldParent != null) {
                this.oldParent.addComponent(this.child);
            }
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            if (this.oldParent != null) {
                this.oldParent.removeComponent(this.child);
            }
            if (this.newParent != null) {
                this.newParent.addComponent(this.child);
            }
        }
    }

    private class TransactionEdit
    extends CompoundEdit {
        private TransactionEdit() {
        }

        @Override
        public boolean isSignificant() {
            return true;
        }

        @Override
        public void undo() throws CannotUndoException {
            final boolean[] error = new boolean[1];
            TransactionManager.this.writeAccess(new Runnable(){

                @Override
                public void run() {
                    TransactionManager.this.useUndoManager = false;
                    try {
                        TransactionEdit.super.undo();
                    }
                    catch (CannotUndoException e) {
                        error[0] = true;
                        ErrorManager.getDefault().notify(65536, (Throwable)e);
                    }
                }
            });
            if (error[0]) {
                throw new CannotUndoException();
            }
        }

        @Override
        public void redo() throws CannotRedoException {
            final boolean[] error = new boolean[1];
            TransactionManager.this.writeAccess(new Runnable(){

                @Override
                public void run() {
                    TransactionManager.this.useUndoManager = false;
                    try {
                        TransactionEdit.super.redo();
                    }
                    catch (CannotRedoException e) {
                        error[0] = true;
                        ErrorManager.getDefault().notify(65536, (Throwable)e);
                    }
                }
            });
            if (error[0]) {
                throw new CannotRedoException();
            }
        }
    }
}

