/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.php.findusages;

import javax.swing.Icon;
import javax.swing.text.Position;
import org.netbeans.editor.BaseDocument;
import org.netbeans.editor.Utilities;
import org.netbeans.modules.csl.api.OffsetRange;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.refactoring.php.findusages.RefactoringUtils;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.PositionBounds;
import org.openide.text.PositionRef;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public class WhereUsedElement
extends SimpleRefactoringElementImplementation {
    private PositionBounds bounds;
    private String displayText;
    private FileObject parentFile;
    private final Icon icon;
    private final String name;

    public WhereUsedElement(PositionBounds bounds, String displayText, FileObject parentFile, String name, OffsetRange range, Icon icon) {
        this.bounds = bounds;
        this.displayText = displayText;
        this.parentFile = parentFile;
        this.name = name;
        this.icon = icon;
    }

    public String getDisplayText() {
        return this.displayText;
    }

    public Lookup getLookup() {
        FileObject composite = this.parentFile;
        return Lookups.singleton((Object)composite);
    }

    public PositionBounds getPosition() {
        return this.bounds;
    }

    public String getText() {
        return this.displayText;
    }

    public void performChange() {
    }

    public FileObject getFile() {
        return this.parentFile;
    }

    public FileObject getParentFile() {
        return this.getFile();
    }

    public static String extractVariableName(Variable var) {
        if (var.getName() instanceof Identifier) {
            Identifier id = (Identifier)var.getName();
            StringBuilder varName = new StringBuilder();
            if (var.isDollared()) {
                varName.append("$");
            }
            varName.append(id.getName());
            return varName.toString();
        }
        if (var.getName() instanceof Variable) {
            Variable name = (Variable)var.getName();
            return WhereUsedElement.extractVariableName(name);
        }
        return null;
    }

    public static WhereUsedElement create(String name, FileObject fo, OffsetRange range, Icon icon) {
        int start = range.getStart();
        int end = range.getEnd();
        int sta = start;
        int en = start;
        String content = null;
        try {
            BaseDocument bdoc = null;
            DataObject od = DataObject.find((FileObject)fo);
            EditorCookie ec = (EditorCookie)od.getCookie(EditorCookie.class);
            if (ec == null) {
                return null;
            }
            bdoc = (BaseDocument)ec.openDocument();
            content = bdoc.getText(0, bdoc.getLength());
            sta = Utilities.getRowFirstNonWhite((BaseDocument)bdoc, (int)start);
            if (sta == -1) {
                sta = Utilities.getRowStart((BaseDocument)bdoc, (int)start);
            }
            en = (en = Utilities.getRowLastNonWhite((BaseDocument)bdoc, (int)start)) == -1 ? Utilities.getRowEnd((BaseDocument)bdoc, (int)start) : ++en;
            if (end > en && (end = start + name.length()) > bdoc.getLength()) {
                end = bdoc.getLength();
            }
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        StringBuilder sb = new StringBuilder();
        if (end < sta) {
            sta = end;
        }
        if (start < sta) {
            start = sta;
        }
        if (en < end) {
            en = end;
        }
        sb.append(RefactoringUtils.getHtml(((Object)content.subSequence(sta, start)).toString()));
        sb.append("<b>");
        sb.append(content.subSequence(start, end));
        sb.append("</b>");
        sb.append(RefactoringUtils.getHtml(((Object)content.subSequence(end, en)).toString()));
        CloneableEditorSupport ces = RefactoringUtils.findCloneableEditorSupport(fo);
        PositionRef ref1 = ces.createPositionRef(start, Position.Bias.Forward);
        PositionRef ref2 = ces.createPositionRef(end, Position.Bias.Forward);
        PositionBounds bounds = new PositionBounds(ref1, ref2);
        return new WhereUsedElement(bounds, sb.toString().trim(), fo, name, new OffsetRange(start, end), icon);
    }

    public Icon getIcon() {
        return this.icon;
    }

    public String getName() {
        return this.name;
    }
}

