/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.management.api;

import java.awt.BorderLayout;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.netbeans.modules.dlight.api.datafilter.DataFilterListener;
import org.netbeans.modules.dlight.api.dataprovider.DataModelScheme;
import org.netbeans.modules.dlight.api.execution.DLightSessionConfiguration;
import org.netbeans.modules.dlight.api.execution.DLightTarget;
import org.netbeans.modules.dlight.api.execution.DLightToolkitManagement;
import org.netbeans.modules.dlight.api.impl.DLightSessionConfigurationAccessor;
import org.netbeans.modules.dlight.api.impl.DLightSessionHandlerAccessor;
import org.netbeans.modules.dlight.api.impl.DLightSessionInternalReference;
import org.netbeans.modules.dlight.api.impl.DLightToolkitManager;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.api.tool.DLightConfiguration;
import org.netbeans.modules.dlight.api.tool.DLightConfigurationManager;
import org.netbeans.modules.dlight.api.tool.DLightTool;
import org.netbeans.modules.dlight.api.visualizer.TableBasedVisualizerConfiguration;
import org.netbeans.modules.dlight.api.visualizer.VisualizerConfiguration;
import org.netbeans.modules.dlight.management.api.DLightSession;
import org.netbeans.modules.dlight.management.api.DLightSessionListener;
import org.netbeans.modules.dlight.management.api.ExecutionContext;
import org.netbeans.modules.dlight.management.api.SessionStateListener;
import org.netbeans.modules.dlight.management.api.SharedStorageDLightSession;
import org.netbeans.modules.dlight.management.api.impl.DLightSessionAccessor;
import org.netbeans.modules.dlight.management.api.impl.DLightSessionsStorage;
import org.netbeans.modules.dlight.management.api.impl.DataProvidersManager;
import org.netbeans.modules.dlight.management.api.impl.DataStorageManager;
import org.netbeans.modules.dlight.management.api.impl.SessionDataFiltersSupport;
import org.netbeans.modules.dlight.management.api.impl.VisualizerProvider;
import org.netbeans.modules.dlight.management.ui.spi.DetailsViewEmptyContentProvider;
import org.netbeans.modules.dlight.management.ui.spi.EmptyVisualizerContainerProvider;
import org.netbeans.modules.dlight.management.ui.spi.IndicatorsComponentProvider;
import org.netbeans.modules.dlight.spi.dataprovider.DataProvider;
import org.netbeans.modules.dlight.spi.dataprovider.DataProviderFactory;
import org.netbeans.modules.dlight.spi.impl.IndicatorAccessor;
import org.netbeans.modules.dlight.spi.impl.IndicatorActionListener;
import org.netbeans.modules.dlight.spi.indicator.Indicator;
import org.netbeans.modules.dlight.spi.indicator.SharedIndicator;
import org.netbeans.modules.dlight.spi.storage.DataStorage;
import org.netbeans.modules.dlight.spi.storage.ServiceInfoDataStorage;
import org.netbeans.modules.dlight.spi.visualizer.Visualizer;
import org.netbeans.modules.dlight.spi.visualizer.VisualizerContainer;
import org.netbeans.modules.dlight.spi.visualizer.VisualizerDataProvider;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class DLightManager
implements DLightToolkitManager,
IndicatorActionListener {
    private static final Logger log = DLightLogger.getLogger(DLightManager.class);
    private final CopyOnWriteArrayList<DLightSessionListener> sessionListeners = new CopyOnWriteArrayList();
    private final List<DLightSession> sessions = new ArrayList<DLightSession>();
    private DLightSession activeSession;
    private final DLightManagerSessionStateListener sessionStateListener = new DLightManagerSessionStateListener();
    private Map<String, Map<String, Visualizer<?>>> visualizers = null;
    private final Map<String, SharedStorageDLightSession> sharedSessions;

    public DLightManager() {
        for (DLightSessionListener dLightSessionListener : IndicatorsComponentProvider.getInstance().getIndicatorComponentListeners()) {
            this.addDLightSessionListener(dLightSessionListener);
        }
        this.sharedSessions = new HashMap<String, SharedStorageDLightSession>();
    }

    public static DLightManager getDefault() {
        return (DLightManager)Lookup.getDefault().lookup(DLightToolkitManager.class);
    }

    public SharedStorageDLightSession getSharedSession(String storageUniqueKey) {
        if (this.sharedSessions.containsKey(storageUniqueKey)) {
            return this.sharedSessions.get(storageUniqueKey);
        }
        SharedStorageDLightSession newSession = new SharedStorageDLightSession(storageUniqueKey);
        this.sharedSessions.put(storageUniqueKey, newSession);
        return newSession;
    }

    private DLightSession createNewSession(DLightTarget target, String configurationName) {
        return this.createNewSession(target, configurationName, null);
    }

    private DLightSession createNewSession(DLightTarget target, String configurationName, String sessionName) {
        return this.createNewSession(target, DLightConfigurationManager.getInstance().getConfigurationByName(configurationName), sessionName);
    }

    private DLightSession createNewSession(DLightTarget target, DLightConfiguration configuration) {
        return this.createNewSession(target, configuration, null);
    }

    private DLightSession createNewSession(DLightTarget target, DLightConfiguration configuration, String sessionName) {
        DLightSession session = this.newSession(null, target, configuration, sessionName);
        this.setActiveSession(session);
        if (session != null) {
            session.addSessionStateListener(this.sessionStateListener);
        }
        return session;
    }

    public DLightSession createNewSession(DLightSessionConfiguration sessionConfiguration) {
        DLightSessionConfigurationAccessor accessor = DLightSessionConfigurationAccessor.getDefault();
        DLightConfiguration configuration = accessor.getDLightConfiguration(sessionConfiguration);
        if (configuration == null) {
            configuration = DLightConfigurationManager.getInstance().getConfigurationByName(accessor.getDLightConfigurationName(sessionConfiguration));
        }
        DLightSession session = this.newSession(accessor.getSharedStorageUniqueKey(sessionConfiguration), accessor.getDLightTarget(sessionConfiguration), configuration, accessor.getSessionName(sessionConfiguration));
        this.setActiveSession(session);
        if (accessor.getSessionMode(sessionConfiguration) == DLightSessionConfiguration.Mode.ANALYZE) {
            session.setState(DLightSession.SessionState.ANALYZE);
        }
        if (session != null) {
            session.addSessionStateListener(this.sessionStateListener);
        }
        return session;
    }

    public DLightToolkitManagement.DLightSessionHandler createSession(DLightSessionConfiguration sessionConfiguration) {
        return DLightSessionHandlerAccessor.getDefault().create((DLightSessionInternalReference)this.createNewSession(sessionConfiguration));
    }

    public void closeSessionOnExit(DLightSession session) {
        DLightSession.SessionState currentSessionState = session.getState();
        if (currentSessionState != DLightSession.SessionState.ANALYZE) {
            session.closeOnExit();
        } else {
            session.close();
        }
    }

    public void closeSharedSession(String storageUniqueKey) {
        Collection<DLightSession> sessionsToClose = this.getSessionsByStorageKey(storageUniqueKey);
        for (DLightSession session : sessionsToClose) {
            session.close();
        }
    }

    private void cleanupSession(DLightSession session) {
        List<Visualizer<?>> sessionVisualizer = session.getVisualizers();
        if (sessionVisualizer != null) {
            for (Visualizer<?> v : sessionVisualizer) {
                VisualizerContainer vc = (VisualizerContainer)SwingUtilities.getAncestorOfClass(VisualizerContainer.class, v.getComponent());
                if (vc == null) continue;
                String storageUniqueID = DLightSessionAccessor.getDefault().getSharedStorageUniqueKey(session);
                if (storageUniqueID == null) {
                    vc.removeVisualizer(v);
                    continue;
                }
                this.removeVisualizer(storageUniqueID, v);
                vc.removeVisualizer(v);
            }
        }
        List<Indicator<?>> indicators = session.getIndicators();
        for (Indicator<?> ind : indicators) {
            if (ind instanceof SharedIndicator) continue;
            IndicatorAccessor.getDefault().removeIndicatorActionListener(ind, (IndicatorActionListener)this);
        }
        this.sessions.remove(session);
        this.notifySessionRemoved(session);
        if (this.sessions.isEmpty()) {
            this.setActiveSession(null);
        } else {
            this.setActiveSession(this.sessions.get(this.sessions.size() - 1));
        }
    }

    public void closeSession(DLightSession session) {
        if (session.isRunning()) {
            Object result = DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)DLightManager.loc("DLightManager.disposeRunningContext.Message", session.getDescription()), DLightManager.loc("DLightManager.disposeRunningContext.Title"), 0));
            if (result == NotifyDescriptor.NO_OPTION) {
                return;
            }
            session.stop();
            session.close();
        }
    }

    public DLightSession getActiveSession() {
        return this.activeSession;
    }

    public Collection<DLightSession> getSessionsByStorageKey(String storageUniqueKey) {
        ArrayList<DLightSession> result = new ArrayList<DLightSession>();
        for (DLightSession session : this.sessions) {
            DLightSessionAccessor accessor = DLightSessionAccessor.getDefault();
            if (!accessor.isUsingSharedStorage(session) || !storageUniqueKey.equals(accessor.getSharedStorageUniqueKey(session))) continue;
            result.add(session);
        }
        return result;
    }

    public List<DLightSession> getSessionsList() {
        return this.sessions;
    }

    public Collection<DataStorage> getStorageByKey(String storageUniqueKey) {
        return DataStorageManager.getInstance().getStorages(storageUniqueKey);
    }

    public DataProvider createDataProvider(String storageUniqueKey, DataModelScheme dataModelScheme, DataTableMetadata dataMetadata) {
        Collection<DataProviderFactory> providerFactories = DataProvidersManager.getInstance().getDataProviderFactories(dataModelScheme);
        if (providerFactories.isEmpty()) {
            return null;
        }
        Collection<DataStorage> availableStorages = DataStorageManager.getInstance().getDataStorage(storageUniqueKey, Arrays.asList(dataMetadata));
        for (DataProviderFactory providerFactory : providerFactories) {
            for (DataStorage storage : availableStorages) {
                if (!providerFactory.validate(storage) || dataMetadata != null && !storage.hasData(dataMetadata)) continue;
                DataProvider provider = DataProvidersManager.getInstance().createProvider(providerFactory);
                provider.attachTo(storage);
                ServiceInfoDataStorage serviceInfoDataStorage = DataStorageManager.getInstance().getServiceInfoDataStorageFor(storageUniqueKey);
                provider.attachTo(serviceInfoDataStorage);
                SessionDataFiltersSupport sessionFilterSupport = (SessionDataFiltersSupport)DLightSession.sharedDataFilterSupports.get(storageUniqueKey);
                if (sessionFilterSupport != null) {
                    provider.dataFiltersChanged(sessionFilterSupport.getFilters(), false);
                    sessionFilterSupport.addDataFilterListener((DataFilterListener)provider);
                }
                return provider;
            }
        }
        return null;
    }

    public DLightSession setActiveSession(DLightSession newActiveSession) {
        DLightSession oldActiveSession = this.activeSession;
        if (newActiveSession != oldActiveSession) {
            this.activeSession = newActiveSession;
            if (oldActiveSession != null) {
                oldActiveSession.setActive(false);
            }
            if (newActiveSession != null) {
                newActiveSession.setActive(true);
            }
            this.notifySessionActivated(oldActiveSession, newActiveSession);
        }
        return this.activeSession;
    }

    public void startSession(DLightSession dlightSession) {
        this.setActiveSession(dlightSession);
        dlightSession.start();
    }

    public void stopActiveSession() {
        this.activeSession.stop();
    }

    public void stopSession(DLightSession session) {
        session.stop();
    }

    public void addDLightSessionListener(DLightSessionListener listener) {
        if (listener == null) {
            return;
        }
        if (this.sessionListeners.addIfAbsent(listener)) {
            for (DLightSession s : this.sessions) {
                listener.sessionAdded(s);
            }
            listener.activeSessionChanged(null, this.activeSession);
        }
    }

    public void removeDLightSessionListener(DLightSessionListener listener) {
        this.sessionListeners.remove(listener);
    }

    private DLightSession newSession(String sharedStorageKey, DLightTarget target, DLightConfiguration configuration, String sessionName) {
        DLightSession session = new DLightSession(sharedStorageKey, sessionName);
        session.setExecutionContext(new ExecutionContext(target, configuration));
        this.sessions.add(session);
        List<Indicator<?>> indicators = session.getIndicators();
        for (Indicator<?> ind : indicators) {
            IndicatorAccessor.getDefault().addIndicatorActionListener(ind, (IndicatorActionListener)this);
        }
        this.notifySessionAdded(session);
        return session;
    }

    private DLightSession findIndicatorOwner(Indicator<?> ind) {
        for (DLightSession session : this.sessions) {
            if (!session.containsIndicator(ind)) continue;
            return session;
        }
        return this.activeSession;
    }

    void removeVisualizer(String storageUniqueKey, Visualizer v) {
        if (this.visualizers == null || !this.visualizers.containsKey(storageUniqueKey)) {
            return;
        }
        Map<String, Visualizer<?>> toolVisualizers = this.visualizers.get(storageUniqueKey);
        toolVisualizers.remove(v.getVisualizerConfiguration().getID());
        if (toolVisualizers.isEmpty()) {
            this.visualizers.remove(storageUniqueKey);
        } else {
            this.visualizers.put(storageUniqueKey, toolVisualizers);
        }
    }

    Visualizer<?> getVisualizer(String storageUniqueKey, String visualizerID) {
        if (this.visualizers == null || !this.visualizers.containsKey(storageUniqueKey)) {
            return null;
        }
        Map<String, Visualizer<?>> toolVisualizers = this.visualizers.get(storageUniqueKey);
        return toolVisualizers.get(visualizerID);
    }

    Visualizer<?> putVisualizer(String storageUniqueKey, String id, Visualizer<?> visualizer) {
        Map<String, Visualizer<?>> toolVisualizers;
        if (this.visualizers == null) {
            this.visualizers = new HashMap();
        }
        if ((toolVisualizers = this.visualizers.get(storageUniqueKey)) == null) {
            toolVisualizers = new HashMap();
            this.visualizers.put(storageUniqueKey, toolVisualizers);
        }
        Visualizer<?> oldVis = toolVisualizers.put(id, visualizer);
        return oldVis;
    }

    private Visualizer<?> openVisualizer(String toolID, VisualizerConfiguration visualizerConfiguration, String storageUniqueKey) {
        Visualizer<?> visualizer = null;
        if (this.hasVisualizer(storageUniqueKey, visualizerConfiguration.getID())) {
            Visualizer<?> v = visualizer = this.getVisualizer(storageUniqueKey, visualizerConfiguration.getID());
            v.updateVisualizerConfiguration(visualizerConfiguration);
            VisualizerContainer container = visualizer.getDefaultContainer();
            DLightTool tool = DLightConfigurationManager.getInstance().getDefaultConfiguration().getToolByID(toolID);
            if (tool != null) {
                container.addVisualizer(toolID, tool.getDetailedName(), visualizer);
            } else {
                tool = DLightConfigurationManager.getInstance().getDefaultConfiguration().getToolByID(toolID);
                container.addVisualizer(toolID, tool.getDetailedName(), visualizer);
            }
            container.showup();
            visualizer.refresh();
            return visualizer;
        }
        DataProvider dataProvider = null;
        DataModelScheme visualizerDataScheme = visualizerConfiguration.getSupportedDataScheme();
        if (visualizerConfiguration instanceof TableBasedVisualizerConfiguration) {
            TableBasedVisualizerConfiguration vc = (TableBasedVisualizerConfiguration)visualizerConfiguration;
            DataTableMetadata tableMetadata = vc.getMetadata();
            dataProvider = this.createDataProvider(storageUniqueKey, visualizerDataScheme, tableMetadata);
        } else {
            dataProvider = this.createDataProvider(storageUniqueKey, visualizerDataScheme, null);
        }
        if (dataProvider != null) {
            visualizer = VisualizerProvider.getInstance().createVisualizer(visualizerConfiguration, (VisualizerDataProvider)dataProvider);
        }
        if (visualizer == null) {
            VisualizerDataProvider visDataProvider = DataProvidersManager.getInstance().getDataProviderFor(visualizerConfiguration.getSupportedDataScheme());
            if (visDataProvider != null && !(visDataProvider instanceof DataProvider)) {
                visDataProvider.attachTo(DataStorageManager.getInstance().getServiceInfoDataStorageFor(storageUniqueKey));
            }
            if (visDataProvider != null) {
                visualizer = VisualizerProvider.getInstance().createVisualizer(visualizerConfiguration, visDataProvider);
            }
        }
        if (visualizer == null) {
            log.log(Level.FINE, "Unable to find factory to create Visualizer with ID == {0}", visualizerConfiguration.getID());
            return null;
        }
        VisualizerContainer container = visualizer.getDefaultContainer();
        DLightTool tool = DLightConfigurationManager.getInstance().getDefaultConfiguration().getToolByID(toolID);
        if (tool != null) {
            container.addVisualizer(toolID, tool.getDetailedName(), visualizer);
        } else {
            container.addVisualizer(toolID, toolID, visualizer);
        }
        this.putVisualizer(storageUniqueKey, visualizerConfiguration.getID(), visualizer);
        container.showup();
        return visualizer;
    }

    boolean hasVisualizer(String toolID, String visualizerID) {
        if (this.visualizers == null || !this.visualizers.containsKey(toolID)) {
            return false;
        }
        Map<String, Visualizer<?>> toolVisualizers = this.visualizers.get(toolID);
        return toolVisualizers.containsKey(visualizerID);
    }

    private Visualizer<?> openVisualizer(String toolID, VisualizerConfiguration visualizerConfiguration, DLightSession dlightSession) {
        VisualizerDataProvider visDataProvider;
        Visualizer<?> visualizer = null;
        if (dlightSession.hasVisualizer(toolID, visualizerConfiguration.getID())) {
            Visualizer<?> v = visualizer = dlightSession.getVisualizer(toolID, visualizerConfiguration.getID());
            v.updateVisualizerConfiguration(visualizerConfiguration);
            if (visualizer instanceof SessionStateListener) {
                dlightSession.addSessionStateListener((SessionStateListener)visualizer);
                ((SessionStateListener)visualizer).sessionStateChanged(dlightSession, null, dlightSession.getState());
            }
            VisualizerContainer container = visualizer.getDefaultContainer();
            DLightTool tool = dlightSession.getToolByID(toolID);
            if (tool != null) {
                container.addVisualizer(toolID, tool.getDetailedName(), visualizer);
            } else {
                tool = DLightConfigurationManager.getInstance().getDefaultConfiguration().getToolByID(toolID);
                container.addVisualizer(toolID, tool.getDetailedName(), visualizer);
            }
            container.showup();
            visualizer.refresh();
            return visualizer;
        }
        DataProvider dataProvider = null;
        DataModelScheme visualizerDataScheme = visualizerConfiguration.getSupportedDataScheme();
        DLightSessionAccessor accessor = DLightSessionAccessor.getDefault();
        if (visualizerConfiguration instanceof TableBasedVisualizerConfiguration) {
            TableBasedVisualizerConfiguration vc = (TableBasedVisualizerConfiguration)visualizerConfiguration;
            DataTableMetadata tableMetadata = vc.getMetadata();
            dataProvider = accessor.isUsingSharedStorage(dlightSession) ? this.createDataProvider(accessor.getSharedStorageUniqueKey(dlightSession), visualizerDataScheme, tableMetadata) : dlightSession.createDataProvider(visualizerDataScheme, tableMetadata);
        } else {
            dataProvider = accessor.isUsingSharedStorage(dlightSession) ? this.createDataProvider(accessor.getSharedStorageUniqueKey(dlightSession), visualizerDataScheme, null) : dlightSession.createDataProvider(visualizerDataScheme, null);
        }
        if (dataProvider != null && (visualizer = VisualizerProvider.getInstance().createVisualizer(visualizerConfiguration, (VisualizerDataProvider)dataProvider)) instanceof SessionStateListener) {
            dlightSession.addSessionStateListener((SessionStateListener)visualizer);
            ((SessionStateListener)visualizer).sessionStateChanged(dlightSession, null, dlightSession.getState());
        }
        if (visualizer == null && (visDataProvider = dlightSession.createVisualizerDataProvider(visualizerConfiguration.getSupportedDataScheme())) != null && (visualizer = VisualizerProvider.getInstance().createVisualizer(visualizerConfiguration, visDataProvider)) instanceof SessionStateListener) {
            dlightSession.addSessionStateListener((SessionStateListener)visualizer);
            ((SessionStateListener)visualizer).sessionStateChanged(dlightSession, null, dlightSession.getState());
        }
        if (visualizer == null) {
            log.log(Level.FINE, "Unable to find factory to create Visualizer with ID == {0}", visualizerConfiguration.getID());
            return null;
        }
        VisualizerContainer container = visualizer.getDefaultContainer();
        DLightTool tool = dlightSession.getToolByID(toolID);
        if (tool != null) {
            container.addVisualizer(toolID, tool.getDetailedName(), visualizer);
        } else {
            container.addVisualizer(toolID, toolID, visualizer);
        }
        container.showup();
        dlightSession.putVisualizer(toolID, visualizerConfiguration.getID(), visualizer);
        return visualizer;
    }

    private void openEmptyVisualizer(String vcID, String toolID, DLightSession session) {
        VisualizerContainer vC;
        DetailsViewEmptyContentProvider emptyContentProvider = (DetailsViewEmptyContentProvider)Lookup.getDefault().lookup(DetailsViewEmptyContentProvider.class);
        if (emptyContentProvider == null) {
            emptyContentProvider = DefaultDetailsViewEmptyContentProvider.instance;
        }
        JComponent view = null;
        boolean isFirstView = true;
        if (Lookup.getDefault().lookup(EmptyVisualizerContainerProvider.class) == null) {
            return;
        }
        DLightTool tool = session.getToolByID(toolID);
        if (tool == null) {
            return;
        }
        Collection providers = Lookup.getDefault().lookupAll(EmptyVisualizerContainerProvider.class);
        VisualizerContainer container = ((EmptyVisualizerContainerProvider)Lookup.getDefault().lookup(EmptyVisualizerContainerProvider.class)).getEmptyVisualizerContainer();
        if (vcID != null) {
            for (EmptyVisualizerContainerProvider provider : providers) {
                vC = provider.getEmptyVisualizerContainer(vcID);
                if (vC == null) continue;
                container = vC;
                break;
            }
        }
        if (container == null) {
            for (EmptyVisualizerContainerProvider provider : providers) {
                vC = provider.getEmptyVisualizerContainer();
                if (vC == null) continue;
                container = vC;
                break;
            }
        }
        if (container == null) {
            return;
        }
        String name = toolID;
        if (tool != null) {
            name = tool.getDetailedName();
        }
        for (ExecutionContext context : session.getExecutionContexts()) {
            view = emptyContentProvider.getEmptyView(context.getDLightConfiguration(), tool, context.getTarget());
            if (isFirstView) {
                container.setContent(name, view);
                isFirstView = false;
                continue;
            }
            container.addContent(name, view);
        }
        container.showup();
    }

    private void notifySessionRemoved(DLightSession session) {
        for (DLightSessionListener l : this.sessionListeners) {
            l.sessionRemoved(session);
        }
    }

    private void notifySessionAdded(DLightSession session) {
        for (DLightSessionListener l : this.sessionListeners) {
            l.sessionAdded(session);
        }
    }

    private void notifySessionActivated(DLightSession oldActiveSession, DLightSession newActiveSession) {
        for (DLightSessionListener l : this.sessionListeners) {
            l.activeSessionChanged(oldActiveSession, newActiveSession);
        }
    }

    private void resetContext(ExecutionContext context) {
    }

    private static String loc(String key) {
        return NbBundle.getMessage(DLightManager.class, (String)key);
    }

    private static String loc(String key, Object param1) {
        return NbBundle.getMessage(DLightManager.class, (String)key, (Object)param1);
    }

    public void startSession(DLightToolkitManagement.DLightSessionHandler handler) {
        DLightSessionInternalReference reference = DLightSessionHandlerAccessor.getDefault().getSessionReferenceImpl(handler);
        if (!(reference instanceof DLightSession)) {
            throw new IllegalArgumentException("Illegal Argument, reference you are trying to use to start D-Light session is invalid");
        }
        this.startSession((DLightSession)reference);
    }

    public void stopSession(DLightToolkitManagement.DLightSessionHandler handler) {
        DLightSessionInternalReference reference = DLightSessionHandlerAccessor.getDefault().getSessionReferenceImpl(handler);
        if (!(reference instanceof DLightSession)) {
            throw new IllegalArgumentException("Illegal Argument, reference you are trying to use to stop D-Light session is invalid");
        }
        this.stopSession((DLightSession)reference);
    }

    public void revalidateSessions() {
        for (DLightSession session : this.sessions) {
            session.revalidate();
        }
    }

    public void openVisualizerForIndicator(Indicator<?> source, VisualizerConfiguration vc) {
        boolean found;
        DLightSession session = this.findIndicatorOwner(source);
        this.setActiveSession(session);
        boolean bl = found = this.openVisualizer(IndicatorAccessor.getDefault().getToolID(source), vc, session) != null;
        if (!found) {
            this.openEmptyVisualizer(vc.getID(), IndicatorAccessor.getDefault().getToolID(source), session);
        }
    }

    public final DataProvider getDataProviderFor(String storageUniqueKey, VisualizerConfiguration visualizerConfiguration) {
        DataProvider dataProvider = null;
        DataModelScheme visualizerDataScheme = visualizerConfiguration.getSupportedDataScheme();
        if (visualizerConfiguration instanceof TableBasedVisualizerConfiguration) {
            TableBasedVisualizerConfiguration vc = (TableBasedVisualizerConfiguration)visualizerConfiguration;
            DataTableMetadata tableMetadata = vc.getMetadata();
            dataProvider = this.createDataProvider(storageUniqueKey, visualizerDataScheme, tableMetadata);
        } else {
            dataProvider = this.createDataProvider(storageUniqueKey, visualizerDataScheme, null);
        }
        return dataProvider;
    }

    public final void openVisualizer(DLightSession session, String toolID, VisualizerConfiguration vc) {
        boolean found;
        this.setActiveSession(session);
        boolean bl = found = this.openVisualizer(toolID, vc, session) != null;
        if (!found) {
            this.openEmptyVisualizer(vc.getID(), toolID, session);
        }
    }

    public void mouseClickedOnIndicator(Indicator<?> source) {
        String storageUniqueKey = null;
        if (source instanceof SharedIndicator) {
            storageUniqueKey = ((SharedIndicator)source).getCurrentStorageID();
        }
        DLightSession session = this.findIndicatorOwner(source);
        this.setActiveSession(session);
        List list = IndicatorAccessor.getDefault().getVisualizerConfigurations(source);
        boolean found = false;
        if (list != null) {
            for (VisualizerConfiguration vc : list) {
                if (storageUniqueKey == null) {
                    if (this.openVisualizer(IndicatorAccessor.getDefault().getToolID(source), vc, session) == null) continue;
                    found = true;
                    break;
                }
                if (this.openVisualizer(IndicatorAccessor.getDefault().getToolID(source), vc, storageUniqueKey) == null) continue;
                found = true;
                break;
            }
        }
        if (!found) {
            this.openEmptyVisualizer(null, IndicatorAccessor.getDefault().getToolID(source), session);
        }
    }

    public DLightToolkitManagement.DLightSessionHandler open(String filePath) {
        return DLightSessionHandlerAccessor.getDefault().create((DLightSessionInternalReference)DLightSessionsStorage.getInstance().openSession(filePath));
    }

    public void save(String sourceDir, String sessionName, DLightToolkitManagement.DLightSessionHandler handler) {
        DLightSessionInternalReference reference = DLightSessionHandlerAccessor.getDefault().getSessionReferenceImpl(handler);
        if (!(reference instanceof DLightSession)) {
            throw new IllegalArgumentException("Illegal Argument, reference you are trying to use to save DLight session is invalid");
        }
        DLightSession session = (DLightSession)reference;
    }

    private static final class DefaultDetailsViewEmptyContentProvider
    implements DetailsViewEmptyContentProvider {
        private static final DefaultDetailsViewEmptyContentProvider instance = new DefaultDetailsViewEmptyContentProvider();
        private final JPanel p = new JPanel();

        DefaultDetailsViewEmptyContentProvider() {
            this.p.setLayout(new BorderLayout());
            this.p.add((Component)new JLabel(DLightManager.loc("DLightManager.noData")), "Center");
        }

        @Override
        public JComponent getEmptyView(DLightConfiguration configuration, DLightTool tool, DLightTarget targetToValidateWith) {
            return this.p;
        }
    }

    private class DLightManagerSessionStateListener
    implements SessionStateListener {
        private DLightManagerSessionStateListener() {
        }

        @Override
        public void sessionStateChanged(DLightSession session, DLightSession.SessionState oldState, DLightSession.SessionState newState) {
            if (newState == DLightSession.SessionState.CLOSED) {
                DLightManager.this.cleanupSession(session);
            }
        }
    }
}

