/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.management.api;

import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.dlight.api.datafilter.DataFilter;
import org.netbeans.modules.dlight.api.datafilter.DataFilterListener;
import org.netbeans.modules.dlight.api.datafilter.DataFilterManager;
import org.netbeans.modules.dlight.api.datafilter.support.TimeIntervalDataFilter;
import org.netbeans.modules.dlight.api.dataprovider.DataModelScheme;
import org.netbeans.modules.dlight.api.execution.DLightTarget;
import org.netbeans.modules.dlight.api.execution.DLightTargetChangeEvent;
import org.netbeans.modules.dlight.api.execution.DLightTargetListener;
import org.netbeans.modules.dlight.api.execution.SubstitutableTarget;
import org.netbeans.modules.dlight.api.execution.TerminatedTarget;
import org.netbeans.modules.dlight.api.impl.DLightSessionInternalReference;
import org.netbeans.modules.dlight.api.impl.DLightTargetAccessor;
import org.netbeans.modules.dlight.api.impl.DLightToolAccessor;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.api.tool.DLightTool;
import org.netbeans.modules.dlight.impl.ServiceInfoDataStorageImpl;
import org.netbeans.modules.dlight.management.api.DLightSessionIOProvider;
import org.netbeans.modules.dlight.management.api.ExecutionContext;
import org.netbeans.modules.dlight.management.api.ExecutionContextListener;
import org.netbeans.modules.dlight.management.api.SessionStateListener;
import org.netbeans.modules.dlight.management.api.impl.DLightSessionAccessor;
import org.netbeans.modules.dlight.management.api.impl.DataFiltersManager;
import org.netbeans.modules.dlight.management.api.impl.DataProvidersManager;
import org.netbeans.modules.dlight.management.api.impl.DataStorageManager;
import org.netbeans.modules.dlight.management.api.impl.SessionDataFiltersSupport;
import org.netbeans.modules.dlight.spi.collector.DataCollector;
import org.netbeans.modules.dlight.spi.collector.DataCollectorListener;
import org.netbeans.modules.dlight.spi.dataprovider.DataProvider;
import org.netbeans.modules.dlight.spi.dataprovider.DataProviderFactory;
import org.netbeans.modules.dlight.spi.impl.DataCollectorProvider;
import org.netbeans.modules.dlight.spi.impl.IndicatorAccessor;
import org.netbeans.modules.dlight.spi.impl.IndicatorDataProviderAccessor;
import org.netbeans.modules.dlight.spi.impl.IndicatorRepairActionProviderAccessor;
import org.netbeans.modules.dlight.spi.indicator.Indicator;
import org.netbeans.modules.dlight.spi.indicator.IndicatorDataProvider;
import org.netbeans.modules.dlight.spi.indicator.IndicatorNotificationsListener;
import org.netbeans.modules.dlight.spi.storage.DataStorage;
import org.netbeans.modules.dlight.spi.storage.DataStorageType;
import org.netbeans.modules.dlight.spi.storage.ServiceInfoDataStorage;
import org.netbeans.modules.dlight.spi.visualizer.Visualizer;
import org.netbeans.modules.dlight.spi.visualizer.VisualizerDataProvider;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;
import org.openide.windows.InputOutput;

public final class DLightSession
implements DLightTargetListener,
DataFilterManager,
DLightSessionIOProvider,
DLightSessionInternalReference,
DataCollectorListener {
    private long startTimestamp = 0L;
    private static int sessionCount;
    private static final Logger log;
    private List<ExecutionContext> contexts = new ArrayList<ExecutionContext>();
    private List<SessionStateListener> sessionStateListeners = null;
    private List<IndicatorDataProvider<?>> idps;
    private final List<IndicatorNotificationsListener> indicatorNotificationListeners = Collections.synchronizedList(new ArrayList());
    private List<DataStorage> storages = null;
    private final ServiceInfoDataStorage serviceInfoDataStorage;
    private List<DataCollector<?>> collectors = null;
    private Map<String, Map<String, Visualizer<?>>> visualizers = null;
    private SessionState state;
    private final int sessionID;
    private String description = null;
    private boolean isActive;
    private final String name;
    private boolean closeOnExit = false;
    private final SessionDataFiltersSupport dataFiltersSupport;
    private InputOutput io;
    private final String sharedStorageID;
    private final boolean useSharedStorage;
    private CountDownLatch collectorsDoneFlag;
    private final List<DataCollectorListener> collectorListeners = new ArrayList<DataCollectorListener>();
    static final ConcurrentMap<String, SessionDataFiltersSupport> sharedDataFilterSupports;

    DLightSession(String sharedStorageID, String name) {
        this.state = SessionState.CONFIGURATION;
        this.name = name;
        this.sharedStorageID = sharedStorageID;
        this.useSharedStorage = sharedStorageID != null;
        this.sessionID = sessionCount++;
        SessionDataFiltersSupport newSupport = new SessionDataFiltersSupport();
        if (this.useSharedStorage) {
            SessionDataFiltersSupport old = sharedDataFilterSupports.putIfAbsent(sharedStorageID, newSupport);
            if (old != null) {
                newSupport = old;
            }
            this.serviceInfoDataStorage = DataStorageManager.getInstance().getServiceInfoDataStorageFor(sharedStorageID);
        } else {
            this.serviceInfoDataStorage = new ServiceInfoDataStorageImpl();
        }
        this.dataFiltersSupport = newSupport;
    }

    public final long getStartTime() {
        return this.startTimestamp;
    }

    public void collectorStateChanged(DataCollector<?> source, DataCollector.CollectorState state) {
        if (this.collectors.contains(source) && (state == DataCollector.CollectorState.STOPPED || state == DataCollector.CollectorState.FAILED || state == DataCollector.CollectorState.TERMINATED || state == DataCollector.CollectorState.DONE)) {
            this.collectorsDoneFlag.countDown();
            if (this.collectorsDoneFlag.getCount() == 0L) {
                DLightTarget target = this.contexts.get(0).getTarget();
                if (!(target instanceof TerminatedTarget)) {
                    return;
                }
                switch (target.getState()) {
                    case RUNNING: 
                    case STARTING: 
                    case INIT: {
                        DLightTargetAccessor.getDefault().getDLightTargetExecution(target).terminate(target);
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addDataCollectorListener(DataCollectorListener listener) {
        if (listener == null) {
            return;
        }
        DLightSession dLightSession = this;
        synchronized (dLightSession) {
            if (!this.collectorListeners.contains(listener)) {
                this.collectorListeners.add(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeDataCollectorListener(DataCollectorListener listener) {
        DLightSession dLightSession = this;
        synchronized (dLightSession) {
            this.collectorListeners.remove(listener);
        }
    }

    public final String getID() {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    public void targetStateChanged(DLightTargetChangeEvent event) {
        switch (event.state) {
            case RUNNING: {
                this.startTimestamp = 0L;
                this.serviceInfoDataStorage.put("service.storage.session_start_time.nanoseconds", this.startTimestamp + "");
                this.targetStarted(event.target);
                break;
            }
            case FAILED: {
                this.targetFinished(event.target);
                break;
            }
            case TERMINATED: {
                this.targetFinished(event.target);
                break;
            }
            case DONE: {
                this.targetFinished(event.target);
                break;
            }
            case STOPPED: {
                this.targetFinished(event.target);
                return;
            }
        }
    }

    void cleanVisualizers() {
        if (this.visualizers == null) {
            return;
        }
        this.visualizers.clear();
        this.visualizers = null;
    }

    List<ExecutionContext> getExecutionContexts() {
        return Collections.unmodifiableList(this.contexts);
    }

    void addExecutionContext(ExecutionContext context) {
        this.contexts.add(context);
        context.validateTools();
        DLightTarget.Info targetInfo = DLightTargetAccessor.getDefault().getDLightTargetInfo(context.getTarget());
        for (Map.Entry entry : targetInfo.getInfo().entrySet()) {
            this.serviceInfoDataStorage.put((String)entry.getKey(), (String)entry.getValue());
        }
    }

    void setExecutionContext(ExecutionContext context) {
        this.clearExecutionContext();
        this.addExecutionContext(context);
    }

    void clearExecutionContext() {
        this.assertState(SessionState.CONFIGURATION);
        for (ExecutionContext c : this.contexts) {
            c.clear();
        }
        this.contexts.clear();
    }

    public void addSessionStateListener(SessionStateListener listener) {
        if (this.sessionStateListeners == null) {
            this.sessionStateListeners = new ArrayList<SessionStateListener>();
        }
        if (!this.sessionStateListeners.contains(listener)) {
            this.sessionStateListeners.add(listener);
        }
    }

    public void removeSessionStateListener(SessionStateListener listener) {
        if (this.sessionStateListeners == null) {
            return;
        }
        this.sessionStateListeners.remove(listener);
    }

    public SessionState getState() {
        return this.state;
    }

    public synchronized String getDescription() {
        if (this.description == null) {
            String targets;
            if (this.contexts.isEmpty()) {
                targets = DLightSession.loc("DLightSession.description.noTargets", new String[0]);
            } else {
                StringBuilder sb = new StringBuilder();
                for (ExecutionContext context : this.contexts) {
                    sb.append(context.getTarget().toString()).append("; ");
                }
                targets = sb.toString();
            }
            this.description = DLightSession.loc("DLightSession.description", String.valueOf(this.sessionID), targets);
        }
        return this.description;
    }

    public String getDisplayName() {
        return this.name == null ? this.getDescription() : this.name;
    }

    boolean isRunning() {
        return this.state == SessionState.RUNNING;
    }

    boolean hasVisualizer(String toolID, String visualizerID) {
        if (this.visualizers == null || !this.visualizers.containsKey(toolID)) {
            return false;
        }
        Map<String, Visualizer<?>> toolVisualizers = this.visualizers.get(toolID);
        return toolVisualizers.containsKey(visualizerID);
    }

    List<Visualizer<?>> getVisualizers() {
        if (this.visualizers == null) {
            return Collections.emptyList();
        }
        ArrayList result = new ArrayList();
        for (Map.Entry<String, Map<String, Visualizer<?>>> mapEntry : this.visualizers.entrySet()) {
            for (Map.Entry<String, Visualizer<?>> entry : mapEntry.getValue().entrySet()) {
                result.add(entry.getValue());
            }
        }
        return result;
    }

    Visualizer<?> getVisualizer(String toolID, String visualizerID) {
        if (this.visualizers == null || !this.visualizers.containsKey(toolID)) {
            return null;
        }
        Map<String, Visualizer<?>> toolVisualizers = this.visualizers.get(toolID);
        return toolVisualizers.get(visualizerID);
    }

    Visualizer<?> putVisualizer(String toolName, String id, Visualizer<?> visualizer) {
        Map<String, Visualizer<?>> toolVisualizers;
        if (this.visualizers == null) {
            this.visualizers = new HashMap();
        }
        if ((toolVisualizers = this.visualizers.get(toolName)) == null) {
            toolVisualizers = new HashMap();
            this.visualizers.put(toolName, toolVisualizers);
        }
        Visualizer<?> oldVis = toolVisualizers.put(id, visualizer);
        return oldVis;
    }

    public void revalidate() {
        for (ExecutionContext c : this.contexts) {
            c.validateTools();
        }
    }

    void closeOnExit() {
        this.closeOnExit = true;
    }

    synchronized void stop() {
        if (this.state == SessionState.ANALYZE) {
            return;
        }
        this.setState(SessionState.ANALYZE);
        for (ExecutionContext c : this.contexts) {
            final DLightTarget target = c.getTarget();
            target.removeTargetListener((DLightTargetListener)this);
            DLightExecutorService.submit((Runnable)new Runnable(){

                @Override
                public void run() {
                    DLightTargetAccessor.getDefault().getDLightTargetExecution(target).terminate(target);
                }
            }, (String)("Stop DLight session's target " + target.toString()));
        }
    }

    void start() {
        Runnable sessionRunnable = new Runnable(){

            @Override
            public void run() {
                DataStorageManager.getInstance().clearActiveStorages(DLightSession.this);
                if (DLightSession.this.storages != null) {
                    DLightSession.this.storages.clear();
                }
                if (DLightSession.this.collectors != null) {
                    DLightSession.this.collectors.clear();
                }
                for (ExecutionContext context : DLightSession.this.contexts) {
                    DLightSession.this.prepareContext(context);
                }
                DLightSession.this.setState(SessionState.STARTING);
                boolean f = false;
                DLightTargetAccessor targetAccess = DLightTargetAccessor.getDefault();
                for (ExecutionContext context : DLightSession.this.contexts) {
                    DLightTarget target = context.getTarget();
                    if (!f) {
                        target.addTargetListener((DLightTargetListener)DLightSession.this);
                        f = true;
                    }
                    DLightTarget.ExecutionEnvVariablesProvider envProvider = context.getDLightTargetExecutionEnvProvider();
                    DLightSession.this.io = targetAccess.getDLightTargetExecution(target).start(target, envProvider);
                }
            }
        };
        DLightExecutorService.submit((Runnable)sessionRunnable, (String)"DLight session");
    }

    public void addDataFilterListener(DataFilterListener listener) {
        this.dataFiltersSupport.addDataFilterListener(listener);
    }

    public void removeDataFilterListener(DataFilterListener listener) {
        this.dataFiltersSupport.removeDataFilterListener(listener);
    }

    public DLightSessionIOProvider getDLigthSessionIOProvider() {
        return this;
    }

    @Override
    public InputOutput getInputOutput() {
        if (this.state == SessionState.CONFIGURATION) {
            return null;
        }
        return this.io;
    }

    public void addDataFilter(final DataFilter filter, final boolean isAdjusting) {
        if (EventQueue.isDispatchThread()) {
            DLightExecutorService.submit((Runnable)new Runnable(){

                @Override
                public void run() {
                    DLightSession.this.addDataFilterImpl(filter, isAdjusting);
                }
            }, (String)"DLigthSession.addDataFIlter should be invoked in Non-AWT thread");
        } else {
            this.addDataFilterImpl(filter, isAdjusting);
        }
    }

    private void addDataFilterImpl(DataFilter filter, boolean isAdjusting) {
        if (filter instanceof TimeIntervalDataFilter) {
            this.dataFiltersSupport.cleanAll(TimeIntervalDataFilter.class, false);
        }
        this.dataFiltersSupport.addFilter(filter, isAdjusting);
        if (!isAdjusting) {
            for (Visualizer<?> v : this.getVisualizers()) {
                v.refresh();
            }
        }
    }

    public void cleanAllDataFilter() {
        this.cleanAllDataFilter(true);
    }

    public void cleanAllDataFilter(boolean notify) {
        this.dataFiltersSupport.cleanAll();
        if (!notify) {
            return;
        }
        for (Visualizer<?> v : this.getVisualizers()) {
            v.refresh();
        }
    }

    public void cleanAllDataFilter(Class<?> clazz, boolean notify) {
        this.dataFiltersSupport.cleanAll(clazz);
        if (!notify) {
            return;
        }
        for (Visualizer<?> v : this.getVisualizers()) {
            v.refresh();
        }
    }

    public void cleanAllDataFilter(Class<?> clazz) {
        this.cleanAllDataFilter(clazz, true);
    }

    public <T extends DataFilter> Collection<T> getDataFilter(Class<T> clazz) {
        return this.dataFiltersSupport.getDataFilter(clazz);
    }

    public boolean removeDataFilter(DataFilter filter) {
        return this.dataFiltersSupport.removeFilter(filter);
    }

    public final void addIndicatorNotificationListener(IndicatorNotificationsListener l) {
        if (l == null) {
            return;
        }
        if (!this.indicatorNotificationListeners.contains(l)) {
            this.indicatorNotificationListeners.add(l);
        }
        if (this.idps == null || this.idps.isEmpty()) {
            return;
        }
        for (IndicatorDataProvider<?> idp : this.idps) {
            IndicatorDataProviderAccessor.getDefault().addIndicatorDataProviderListener(idp, l);
        }
    }

    public final boolean removeIndicatorNotificationListener(IndicatorNotificationsListener l) {
        if (l == null) {
            return false;
        }
        return this.indicatorNotificationListeners.remove(l);
    }

    private boolean prepareContext(ExecutionContext context) {
        DLightTarget target = context.getTarget();
        DataCollectorProvider.getInstance().reset();
        context.validateTools(context.getDLightConfiguration().getConfigurationOptions(false).validateToolsRequiredUserInteraction());
        ArrayList<DLightTool> validTools = new ArrayList<DLightTool>();
        StringBuilder toolNames = new StringBuilder();
        for (DLightTool tool : context.getTools()) {
            validTools.add(tool);
            toolNames.append(tool.getName()).append(":");
        }
        if (validTools.isEmpty()) {
            return false;
        }
        DataCollector<?> notAttachableDataCollector = null;
        if (this.collectors == null) {
            this.collectors = new ArrayList();
        }
        if (context.getDLightConfiguration().getConfigurationOptions(false).areCollectorsTurnedOn()) {
            for (DLightTool dLightTool : validTools) {
                List toolCollectors = context.getDLightConfiguration().getConfigurationOptions(false).getCollectors(dLightTool);
                for (DataCollector c : toolCollectors) {
                    if (this.collectors.contains(c) || !c.getValidationStatus().isValid()) continue;
                    this.collectors.add(c);
                }
            }
        } else {
            for (DataCollector dataCollector : this.collectors) {
                dataCollector.removeDataCollectorListener((DataCollectorListener)this);
                for (DataCollectorListener l : this.collectorListeners) {
                    dataCollector.removeDataCollectorListener(l);
                }
            }
            this.collectors.clear();
        }
        ArrayList idproviders = new ArrayList();
        StringBuilder stringBuilder = new StringBuilder();
        StringBuilder collectorNames = new StringBuilder();
        for (DLightTool tool : validTools) {
            List indicators;
            ArrayList<Indicator> arrayList = new ArrayList<Indicator>();
            this.idps = context.getDLightConfiguration().getConfigurationOptions(false).getIndicatorDataProviders(tool);
            if (this.idps != null) {
                for (IndicatorDataProvider<?> idp : this.idps) {
                    if (!idp.getValidationStatus().isValid()) continue;
                    if (idp instanceof DLightTarget.ExecutionEnvVariablesProvider) {
                        context.addDLightTargetExecutionEnviromentProvider((DLightTarget.ExecutionEnvVariablesProvider)idp);
                    }
                    if (idp instanceof DataCollector) {
                        DataCollector<?> dataCollector = (DataCollector<?>)idp;
                        if (!this.collectors.contains(dataCollector)) {
                            this.collectors.add(dataCollector);
                        }
                        if (notAttachableDataCollector == null && !dataCollector.isAttachable()) {
                            notAttachableDataCollector = dataCollector;
                        }
                    } else {
                        idproviders.add(idp);
                    }
                    for (IndicatorNotificationsListener l : this.indicatorNotificationListeners) {
                        IndicatorDataProviderAccessor.getDefault().addIndicatorDataProviderListener(idp, l);
                    }
                    stringBuilder.append(idp.getName()).append(":");
                    List indicators2 = DLightToolAccessor.getDefault().getIndicators(tool);
                    for (Indicator i : indicators2) {
                        i.setIndicatorActionsProviderContext(Lookups.fixed((Object[])new Object[]{context.getDLightConfiguration(), tool, i}));
                        target.addTargetListener((DLightTargetListener)i);
                        boolean wasSubscribed = idp.subscribe(i);
                        if (wasSubscribed) {
                            if (!arrayList.contains(i)) {
                                arrayList.add(i);
                            }
                            target.addTargetListener(idp);
                            if (log.isLoggable(Level.FINE)) {
                                log.log(Level.FINE, "I have subscribed indicator {0} to indicatorDataProvider {1}", new Object[]{i, idp});
                            }
                        }
                        if (!(i instanceof DataFilterListener)) continue;
                        this.addDataFilterListener((DataFilterListener)i);
                    }
                }
            }
            if ((indicators = DLightToolAccessor.getDefault().getIndicators(tool)) == null) continue;
            for (Indicator i : indicators) {
                if (arrayList.contains(i)) continue;
                IndicatorAccessor.getDefault().setRepairActionProviderFor(i, IndicatorRepairActionProviderAccessor.getDefault().createNew(context.getDLightConfiguration(), tool, target));
            }
        }
        DLightTarget.Info targetInfo = DLightTargetAccessor.getDefault().getDLightTargetInfo(target);
        this.serviceInfoDataStorage.put("service.storage.tools", toolNames.toString());
        this.serviceInfoDataStorage.put("service.storage.configuration.name", context.getDLightConfiguration().getConfigurationName());
        this.serviceInfoDataStorage.put("service.storage.idp.names", stringBuilder.toString());
        this.serviceInfoDataStorage.put("service.storage.collector.names", collectorNames.toString());
        if (this.useSharedStorage) {
            this.serviceInfoDataStorage.put("storage.unique.key", this.sharedStorageID);
            targetInfo.getInfo().put("storage.unique.key", this.sharedStorageID);
        }
        if (this.collectors != null && !this.collectors.isEmpty()) {
            for (DataCollector<?> dataCollector : this.collectors) {
                collectorNames.append(dataCollector.getName()).append(":");
                Map<DataStorageType, DataStorage> currentStorages = DataStorageManager.getInstance().getDataStoragesFor(this, dataCollector);
                if (dataCollector instanceof DLightTarget.ExecutionEnvVariablesProvider) {
                    context.addDLightTargetExecutionEnviromentProvider((DLightTarget.ExecutionEnvVariablesProvider)dataCollector);
                }
                if (currentStorages != null && !currentStorages.isEmpty()) {
                    if (this.storages == null) {
                        this.storages = new ArrayList<DataStorage>();
                    }
                    for (DataStorage storage : currentStorages.values()) {
                        if (this.storages.contains(storage)) continue;
                        storage.attachTo(this.serviceInfoDataStorage);
                        this.storages.add(storage);
                    }
                    dataCollector.init(this.serviceInfoDataStorage);
                    dataCollector.init(currentStorages, target);
                    this.addDataFilterListener((DataFilterListener)dataCollector);
                    if (notAttachableDataCollector == null && !dataCollector.isAttachable()) {
                        notAttachableDataCollector = dataCollector;
                    }
                } else {
                    log.log(Level.SEVERE, "Cannot find storage for collector {0}", dataCollector);
                }
                target.addTargetListener(dataCollector);
            }
            for (DataCollector<?> dataCollector : this.collectors) {
                dataCollector.addDataCollectorListener((DataCollectorListener)this);
                for (DataCollectorListener l : this.collectorListeners) {
                    dataCollector.addDataCollectorListener(l);
                }
            }
            this.collectorsDoneFlag = new CountDownLatch(this.collectors.size());
            for (IndicatorDataProvider indicatorDataProvider : idproviders) {
                indicatorDataProvider.init(this.serviceInfoDataStorage);
                this.addDataFilterListener((DataFilterListener)indicatorDataProvider);
            }
        }
        Map info = targetInfo.getInfo();
        for (Map.Entry entry : info.entrySet()) {
            DataFilter filter = DataFiltersManager.getInstance().createFilter((String)entry.getKey(), (String)entry.getValue());
            if (filter == null) continue;
            this.dataFiltersSupport.addFilter(filter, false);
        }
        if (notAttachableDataCollector != null && target instanceof SubstitutableTarget) {
            ((SubstitutableTarget)target).substitute(notAttachableDataCollector.getCmd(), notAttachableDataCollector.getArgs());
        }
        return true;
    }

    List<DataStorage> getStorages() {
        return this.storages == null ? Collections.emptyList() : this.storages;
    }

    public ServiceInfoDataStorage getServiceInfoDataStorage() {
        return this.serviceInfoDataStorage;
    }

    public DataProvider createDataProvider(DataModelScheme dataModelScheme, DataTableMetadata dataMetadata) {
        Collection<DataProviderFactory> providerFactories = DataProvidersManager.getInstance().getDataProviderFactories(dataModelScheme);
        if (providerFactories.isEmpty()) {
            return null;
        }
        List<DataStorage> availableStorages = this.getStorages();
        for (DataProviderFactory providerFactory : providerFactories) {
            for (DataStorage storage : availableStorages) {
                if (!providerFactory.validate(storage) || dataMetadata != null && !storage.hasData(dataMetadata)) continue;
                DataProvider provider = DataProvidersManager.getInstance().createProvider(providerFactory);
                provider.attachTo(storage);
                provider.attachTo(this.serviceInfoDataStorage);
                provider.dataFiltersChanged(this.dataFiltersSupport.getFilters(), false);
                this.addDataFilterListener((DataFilterListener)provider);
                return provider;
            }
        }
        return null;
    }

    public VisualizerDataProvider createVisualizerDataProvider(DataModelScheme dataModelScheme) {
        VisualizerDataProvider dataProvider = DataProvidersManager.getInstance().getDataProviderFor(dataModelScheme);
        if (dataProvider != null && !(dataProvider instanceof DataProvider)) {
            dataProvider.attachTo(this.serviceInfoDataStorage);
            return dataProvider;
        }
        return null;
    }

    void close() {
        this.setState(SessionState.CLOSED);
        if (this.sessionStateListeners != null) {
            this.sessionStateListeners.clear();
            this.sessionStateListeners = null;
        }
        this.dataFiltersSupport.removeAllListeners();
        if (!EventQueue.isDispatchThread()) {
            DataStorageManager.getInstance().closeSession(this);
            this.cleanVisualizers();
        } else {
            DLightExecutorService.submit((Runnable)new Runnable(){

                @Override
                public void run() {
                    DataStorageManager.getInstance().closeSession(DLightSession.this);
                    DLightSession.this.cleanVisualizers();
                }
            }, (String)("DLight Session " + this.getDisplayName() + " is closing.."));
        }
    }

    private void targetStarted(DLightTarget target) {
        this.setState(SessionState.RUNNING);
    }

    private void targetFinished(DLightTarget target) {
        this.setState(SessionState.ANALYZE);
        target.removeTargetListener((DLightTargetListener)this);
        if (this.closeOnExit) {
            this.close();
        }
    }

    void setState(SessionState state) {
        SessionState oldState = this.state;
        this.state = state;
        if (this.sessionStateListeners != null) {
            for (SessionStateListener l : this.sessionStateListeners.toArray(new SessionStateListener[0])) {
                l.sessionStateChanged(this, oldState, state);
            }
        }
    }

    public void addExecutionContextListener(ExecutionContextListener listener) {
        for (ExecutionContext c : this.contexts) {
            c.addListener(listener);
        }
    }

    public void removeExecutionContextListener(ExecutionContextListener listener) {
        for (ExecutionContext c : this.contexts) {
            c.removeListener(listener);
        }
    }

    public List<DLightTool> getTools() {
        ArrayList<DLightTool> result = new ArrayList<DLightTool>();
        for (ExecutionContext c : this.contexts) {
            result.addAll(c.getTools());
        }
        return result;
    }

    DLightTool getToolByName(String toolName) {
        if (toolName == null) {
            throw new IllegalArgumentException("Cannot use NULL as a tool name ");
        }
        for (ExecutionContext c : this.contexts) {
            DLightTool tool = c.getToolByName(toolName);
            if (tool == null) continue;
            return tool;
        }
        return null;
    }

    DLightTool getToolByID(String toolID) {
        if (toolID == null) {
            throw new IllegalArgumentException("Cannot use NULL as a tool name ");
        }
        for (ExecutionContext c : this.contexts) {
            DLightTool tool = c.getToolByID(toolID);
            if (tool == null) continue;
            return tool;
        }
        return null;
    }

    public List<Indicator<?>> getIndicators() {
        ArrayList result = new ArrayList();
        for (ExecutionContext c : this.contexts) {
            result.addAll(c.getIndicators());
        }
        return result;
    }

    boolean containsIndicator(Indicator<?> indicator) {
        return this.getIndicators().contains(indicator);
    }

    private void assertState(SessionState expectedState) {
        if (this.state != expectedState) {
            throw new IllegalStateException("Session is in illegal state " + (Object)((Object)this.state) + "; Must be in " + (Object)((Object)expectedState));
        }
    }

    public boolean isActive() {
        return this.isActive;
    }

    void setActive(boolean b) {
        this.isActive = b;
    }

    private static String loc(String key, String ... params) {
        return NbBundle.getMessage(DLightSession.class, (String)key, (Object[])params);
    }

    static {
        DLightSessionAccessor.setDefault(new DLightSessionAccessorImpl());
        sessionCount = 0;
        log = DLightLogger.getLogger(DLightSession.class);
        sharedDataFilterSupports = new ConcurrentHashMap<String, SessionDataFiltersSupport>();
    }

    private static final class DLightSessionAccessorImpl
    extends DLightSessionAccessor {
        private DLightSessionAccessorImpl() {
        }

        @Override
        public boolean isUsingSharedStorage(DLightSession session) {
            return session.useSharedStorage;
        }

        @Override
        public String getSharedStorageUniqueKey(DLightSession session) {
            return session.sharedStorageID;
        }

        @Override
        public SessionDataFiltersSupport getSessionDataFiltersSupport(DLightSession session) {
            return session.dataFiltersSupport;
        }
    }

    public static enum SessionState {
        CONFIGURATION,
        STARTING,
        RUNNING,
        PAUSED,
        ANALYZE,
        CLOSED;

    }
}

