/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.management.api.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.impl.ServiceInfoDataStorageImpl;
import org.netbeans.modules.dlight.management.api.DLightSession;
import org.netbeans.modules.dlight.management.api.impl.DLightSessionAccessor;
import org.netbeans.modules.dlight.spi.collector.DataCollector;
import org.netbeans.modules.dlight.spi.storage.DataStorage;
import org.netbeans.modules.dlight.spi.storage.DataStorageFactory;
import org.netbeans.modules.dlight.spi.storage.DataStorageType;
import org.netbeans.modules.dlight.spi.storage.PersistentDataStorage;
import org.netbeans.modules.dlight.spi.storage.PersistentDataStorageFactory;
import org.netbeans.modules.dlight.spi.storage.ProxyDataStorage;
import org.netbeans.modules.dlight.spi.storage.ServiceInfoDataStorage;
import org.netbeans.modules.dlight.util.DLightLogger;
import org.openide.util.Lookup;

public final class DataStorageManager {
    private Collection<? extends DataStorageFactory> dataStorageFactories;
    private final Collection<? extends PersistentDataStorageFactory> perstistentDataStorageFactories;
    private Map<DLightSession, List<DataStorage>> activeDataStorages = new HashMap<DLightSession, List<DataStorage>>();
    private Map<String, List<DataStorage>> activeStorages = new HashMap<String, List<DataStorage>>();
    private Map<String, List<DLightSession>> sharedStoragesSessions = new HashMap<String, List<DLightSession>>();
    private Map<String, ServiceInfoDataStorage> serviceInfoStorages = new HashMap<String, ServiceInfoDataStorage>();
    private static final Logger log = DLightLogger.getLogger(DataStorageManager.class);
    private static final DataStorageManager instance = new DataStorageManager();
    private DLightSession lastSession;

    private DataStorageManager() {
        this.dataStorageFactories = Lookup.getDefault().lookupAll(DataStorageFactory.class);
        log.log(Level.FINE, "{0} data storage(s) found!", this.dataStorageFactories.size());
        this.perstistentDataStorageFactories = Lookup.getDefault().lookupAll(PersistentDataStorageFactory.class);
        log.log(Level.FINE, "{0} persistent data storage(s) found!", this.dataStorageFactories.size());
    }

    public static DataStorageManager getInstance() {
        return instance;
    }

    public void closeSession(DLightSession session) {
        List<DLightSession> sessions;
        String storageUniqueKey;
        if (session == null) {
            return;
        }
        List<DataStorage> storages = this.activeDataStorages.get(session);
        if (storages != null) {
            for (DataStorage storage : storages) {
                if (!storage.shutdown()) {
                    log.log(Level.FINEST, "DataStorage {0} is not closed", storage);
                    continue;
                }
                log.log(Level.FINEST, "DataStorage {0} successfully closed", storage);
            }
        }
        if ((storageUniqueKey = DLightSessionAccessor.getDefault().getSharedStorageUniqueKey(session)) != null && (sessions = this.sharedStoragesSessions.get(storageUniqueKey)).contains(session)) {
            sessions.remove(session);
            if (sessions.isEmpty()) {
                Collection sharedStorages = this.activeStorages.get(storageUniqueKey);
                for (DataStorage storage : sharedStorages) {
                    if (!storage.shutdown()) {
                        log.log(Level.FINEST, "Shared storage with key {0} DataStorage {1} is not closed", new Object[]{storageUniqueKey, storage});
                        continue;
                    }
                    log.log(Level.FINEST, "DataStorage with key {0} {1} successfully closed", new Object[]{storageUniqueKey, storage});
                }
                this.activeStorages.remove(storageUniqueKey);
            }
        }
        this.activeDataStorages.remove(session);
    }

    public void clearActiveStorages(DLightSession session) {
        List<DataStorage> storages = this.activeDataStorages.get(session);
        if (storages != null) {
            storages.clear();
        }
        this.lastSession = session;
    }

    public synchronized Map<DataStorageType, DataStorage> getDataStoragesFor(DLightSession session, DataCollector<?> collector) {
        HashMap<DataStorageType, DataStorage> result = new HashMap<DataStorageType, DataStorage>();
        for (DataStorageType type : collector.getRequiredDataStorageTypes()) {
            result.put(type, this.getDataStorageFor(session, type, collector.getDataTablesMetadata()));
        }
        return result;
    }

    public synchronized ServiceInfoDataStorage getServiceInfoDataStorageFor(String uniqueKey) {
        if (uniqueKey == null) {
            return null;
        }
        ServiceInfoDataStorage result = this.serviceInfoStorages.get(uniqueKey);
        if (result == null) {
            result = new ServiceInfoDataStorageImpl();
            this.serviceInfoStorages.put(uniqueKey, result);
        }
        return result;
    }

    public synchronized Collection<DataStorage> getDataStorage(String uniqueKey, List<DataTableMetadata> tableMetadatas) {
        DataStorage backendStorage;
        ProxyDataStorage proxyStorage;
        PersistentDataStorage newStorage;
        if (uniqueKey == null) {
            return null;
        }
        List<DataStorage> uniqueStorages = this.activeStorages.get(uniqueKey);
        ArrayList<DataStorage> result = new ArrayList<DataStorage>();
        if (uniqueStorages != null) {
            for (DataStorage dataStorage : uniqueStorages) {
                dataStorage.createTables(tableMetadatas);
                result.add(dataStorage);
            }
            return result;
        }
        DLightLogger.getLogger(DataStorageManager.class).log(Level.FINE, "DataStorageManager.getDataStorage(Session, String, DataStorageType, DataTableMetadat) NO STORAGE  found  in the list: NEED TO OPEN again ={0} ", uniqueKey);
        if (this.perstistentDataStorageFactories != null) {
            for (PersistentDataStorageFactory persistentDataStorageFactory : this.perstistentDataStorageFactories) {
                newStorage = persistentDataStorageFactory.openStorage(uniqueKey);
                if (newStorage == null) continue;
                if (newStorage instanceof ProxyDataStorage) {
                    proxyStorage = (ProxyDataStorage)newStorage;
                    backendStorage = this.getDataStorage(null, uniqueKey, proxyStorage.getBackendDataStorageType(), proxyStorage.getBackendTablesMetadata());
                    proxyStorage.attachTo(backendStorage);
                    uniqueStorages = this.activeStorages.get(uniqueKey);
                }
                newStorage.createTables(tableMetadatas);
                if (uniqueStorages == null) {
                    uniqueStorages = new ArrayList<DataStorage>();
                }
                uniqueStorages.add((DataStorage)newStorage);
                this.activeStorages.put(uniqueKey, uniqueStorages);
            }
        }
        for (DataStorageFactory dataStorageFactory : this.dataStorageFactories) {
            if (dataStorageFactory instanceof PersistentDataStorageFactory && !this.perstistentDataStorageFactories.contains((PersistentDataStorageFactory)dataStorageFactory)) {
                newStorage = ((PersistentDataStorageFactory)dataStorageFactory).openStorage(uniqueKey);
                if (newStorage == null) {
                    newStorage = dataStorageFactory.createStorage();
                }
                if (newStorage != null && newStorage instanceof ProxyDataStorage) {
                    proxyStorage = (ProxyDataStorage)newStorage;
                    backendStorage = this.getDataStorage(null, uniqueKey, proxyStorage.getBackendDataStorageType(), proxyStorage.getBackendTablesMetadata());
                    proxyStorage.attachTo(backendStorage);
                    uniqueStorages = this.activeStorages.get(uniqueKey);
                }
                if (newStorage == null) continue;
                newStorage.createTables(tableMetadatas);
                if (uniqueStorages == null) {
                    uniqueStorages = new ArrayList<DataStorage>();
                }
                uniqueStorages.add((DataStorage)newStorage);
                this.activeStorages.put(uniqueKey, uniqueStorages);
                continue;
            }
            if (dataStorageFactory instanceof PersistentDataStorageFactory) continue;
            newStorage = dataStorageFactory.createStorage();
            if (newStorage != null && newStorage instanceof ProxyDataStorage) {
                proxyStorage = (ProxyDataStorage)newStorage;
                backendStorage = this.getDataStorage(null, uniqueKey, proxyStorage.getBackendDataStorageType(), proxyStorage.getBackendTablesMetadata());
                proxyStorage.attachTo(backendStorage);
                uniqueStorages = this.activeStorages.get(uniqueKey);
            }
            if (newStorage == null) continue;
            newStorage.createTables(tableMetadatas);
            if (uniqueStorages == null) {
                uniqueStorages = new ArrayList<DataStorage>();
            }
            uniqueStorages.add((DataStorage)newStorage);
            this.activeStorages.put(uniqueKey, uniqueStorages);
        }
        return this.activeStorages.get(uniqueKey);
    }

    public synchronized Collection<DataStorage> getStorages(String uniqueKey, DataTableMetadata dataMetadata) {
        if (uniqueKey == null) {
            return null;
        }
        List<DataStorage> result = this.activeStorages.get(uniqueKey);
        if (result != null) {
            return result;
        }
        result = new ArrayList<DataStorage>();
        for (PersistentDataStorageFactory persistentDataStorageFactory : this.perstistentDataStorageFactories) {
            try {
                DLightLogger.getLogger(DataStorageManager.class).log(Level.FINE, "Trying to open storage with the uniqueID={0} from the DataStorageManager", new String[]{uniqueKey});
                PersistentDataStorage storage = persistentDataStorageFactory.openStorage(uniqueKey);
                if (storage == null) continue;
                result.add((DataStorage)storage);
            }
            catch (Throwable e) {}
        }
        if (!result.isEmpty()) {
            this.activeStorages.put(uniqueKey, result);
        }
        return result;
    }

    public synchronized Collection<DataStorage> getStorages(String uniqueKey) {
        if (uniqueKey == null) {
            return null;
        }
        List<DataStorage> result = this.activeStorages.get(uniqueKey);
        if (result != null) {
            return result;
        }
        result = new ArrayList<DataStorage>();
        for (PersistentDataStorageFactory persistentDataStorageFactory : this.perstistentDataStorageFactories) {
            try {
                DLightLogger.getLogger(DataStorageManager.class).log(Level.FINE, "Trying to open storage with the uniqueID={0} from the DataStorageManager", new String[]{uniqueKey});
                PersistentDataStorage storage = persistentDataStorageFactory.openStorage(uniqueKey);
                if (storage == null) continue;
                result.add((DataStorage)storage);
            }
            catch (Throwable e) {}
        }
        if (!result.isEmpty()) {
            this.activeStorages.put(uniqueKey, result);
        }
        return result;
    }

    public synchronized DataStorage getDataStorage(DLightSession session, String uniqueKey, DataStorageType storageType, List<DataTableMetadata> tableMetadatas) {
        if (uniqueKey == null) {
            return null;
        }
        List<DataStorage> uniqueStorages = this.activeStorages.get(uniqueKey);
        if (uniqueStorages != null) {
            for (DataStorage dataStorage : uniqueStorages) {
                if (!dataStorage.supportsType(storageType)) continue;
                dataStorage.createTables(tableMetadatas);
                return dataStorage;
            }
        }
        DLightLogger.getLogger(DataStorageManager.class).log(Level.FINE, "DataStorageManager.getDataStorage(Session, String, DataStorageType, DataTableMetadat) NO STORAGE  found  in the list: NEED TO OPEN again ={0} ", uniqueKey);
        if (this.perstistentDataStorageFactories != null) {
            for (PersistentDataStorageFactory persistentDataStorageFactory : this.perstistentDataStorageFactories) {
                if (!persistentDataStorageFactory.getStorageTypes().contains(storageType)) continue;
                PersistentDataStorage newStorage = persistentDataStorageFactory.openStorage(uniqueKey);
                if (newStorage != null) {
                    if (newStorage instanceof ProxyDataStorage) {
                        ProxyDataStorage proxyStorage = (ProxyDataStorage)newStorage;
                        DataStorage backendStorage = this.getDataStorage(session, uniqueKey, proxyStorage.getBackendDataStorageType(), proxyStorage.getBackendTablesMetadata());
                        proxyStorage.attachTo(backendStorage);
                        uniqueStorages = this.activeStorages.get(uniqueKey);
                    }
                    newStorage.createTables(tableMetadatas);
                    if (uniqueStorages == null) {
                        uniqueStorages = new ArrayList<DataStorage>();
                    }
                    uniqueStorages.add((DataStorage)newStorage);
                    if (session != null) {
                        List<DLightSession> sessions = this.sharedStoragesSessions.get(uniqueKey);
                        if (sessions == null) {
                            sessions = new ArrayList<DLightSession>();
                        }
                        if (!sessions.contains(session)) {
                            sessions.add(session);
                            this.sharedStoragesSessions.put(uniqueKey, sessions);
                        }
                    }
                    this.activeStorages.put(uniqueKey, uniqueStorages);
                    return newStorage;
                }
                newStorage = persistentDataStorageFactory.createStorage(uniqueKey);
                if (newStorage instanceof ProxyDataStorage) {
                    ProxyDataStorage proxyStorage = (ProxyDataStorage)newStorage;
                    DataStorage backendStorage = this.getDataStorage(session, uniqueKey, proxyStorage.getBackendDataStorageType(), proxyStorage.getBackendTablesMetadata());
                    proxyStorage.attachTo(backendStorage);
                    uniqueStorages = this.activeStorages.get(uniqueKey);
                }
                newStorage.createTables(tableMetadatas);
                if (uniqueStorages == null) {
                    uniqueStorages = new ArrayList<DataStorage>();
                }
                uniqueStorages.add((DataStorage)newStorage);
                if (session != null) {
                    List<DLightSession> sessions = this.sharedStoragesSessions.get(uniqueKey);
                    if (sessions == null) {
                        sessions = new ArrayList<DLightSession>();
                    }
                    if (!sessions.contains(session)) {
                        sessions.add(session);
                        this.sharedStoragesSessions.put(uniqueKey, sessions);
                    }
                }
                this.activeStorages.put(uniqueKey, uniqueStorages);
                return newStorage;
            }
        }
        for (DataStorageFactory dataStorageFactory : this.dataStorageFactories) {
            List<DLightSession> sessions;
            DataStorage backendStorage;
            ProxyDataStorage proxyStorage;
            DataStorage newStorage;
            if (dataStorageFactory instanceof PersistentDataStorageFactory && dataStorageFactory.getStorageTypes().contains(storageType)) {
                newStorage = ((PersistentDataStorageFactory)dataStorageFactory).openStorage(uniqueKey);
                if (newStorage instanceof ProxyDataStorage) {
                    proxyStorage = (ProxyDataStorage)newStorage;
                    backendStorage = this.getDataStorage(session, uniqueKey, proxyStorage.getBackendDataStorageType(), proxyStorage.getBackendTablesMetadata());
                    proxyStorage.attachTo(backendStorage);
                    uniqueStorages = this.activeStorages.get(uniqueKey);
                }
                if (newStorage == null) continue;
                newStorage.createTables(tableMetadatas);
                if (uniqueStorages == null) {
                    uniqueStorages = new ArrayList<DataStorage>();
                }
                uniqueStorages.add(newStorage);
                if (session != null) {
                    sessions = this.sharedStoragesSessions.get(uniqueKey);
                    if (sessions == null) {
                        sessions = new ArrayList<DLightSession>();
                    }
                    if (!sessions.contains(session)) {
                        sessions.add(session);
                        this.sharedStoragesSessions.put(uniqueKey, sessions);
                    }
                }
                this.activeStorages.put(uniqueKey, uniqueStorages);
                return newStorage;
            }
            if (!dataStorageFactory.getStorageTypes().contains(storageType)) continue;
            newStorage = dataStorageFactory.createStorage();
            if (newStorage instanceof ProxyDataStorage) {
                proxyStorage = (ProxyDataStorage)newStorage;
                backendStorage = this.getDataStorage(session, uniqueKey, proxyStorage.getBackendDataStorageType(), proxyStorage.getBackendTablesMetadata());
                proxyStorage.attachTo(backendStorage);
                uniqueStorages = this.activeStorages.get(uniqueKey);
            }
            if (newStorage == null) continue;
            newStorage.createTables(tableMetadatas);
            if (uniqueStorages == null) {
                uniqueStorages = new ArrayList<DataStorage>();
            }
            uniqueStorages.add(newStorage);
            if (session != null) {
                sessions = this.sharedStoragesSessions.get(uniqueKey);
                if (sessions == null) {
                    sessions = new ArrayList<DLightSession>();
                }
                if (!sessions.contains(session)) {
                    sessions.add(session);
                    this.sharedStoragesSessions.put(uniqueKey, sessions);
                }
            }
            this.activeStorages.put(uniqueKey, uniqueStorages);
            return newStorage;
        }
        return null;
    }

    private synchronized DataStorage getDataStorageFor(DLightSession session, DataStorageType storageType, List<DataTableMetadata> tableMetadatas) {
        DataStorage backendStorage;
        ProxyDataStorage proxyStorage;
        DataStorage newStorage;
        if (session == null) {
            return null;
        }
        DLightSessionAccessor accessor = DLightSessionAccessor.getDefault();
        if (accessor.isUsingSharedStorage(session)) {
            return this.getDataStorage(session, accessor.getSharedStorageUniqueKey(session), storageType, tableMetadatas);
        }
        List<DataStorage> activeSessionStorages = this.activeDataStorages.get(session);
        if (activeSessionStorages != null) {
            for (DataStorage dataStorage : activeSessionStorages) {
                if (!dataStorage.supportsType(storageType)) continue;
                dataStorage.createTables(tableMetadatas);
                return dataStorage;
            }
        }
        for (DataStorageFactory dataStorageFactory : this.dataStorageFactories) {
            if (!dataStorageFactory.getStorageTypes().contains(storageType)) continue;
            newStorage = dataStorageFactory.createStorage();
            if (newStorage instanceof ProxyDataStorage) {
                proxyStorage = (ProxyDataStorage)newStorage;
                backendStorage = this.getDataStorageFor(session, proxyStorage.getBackendDataStorageType(), proxyStorage.getBackendTablesMetadata());
                proxyStorage.attachTo(backendStorage);
            }
            if (newStorage == null) continue;
            newStorage.createTables(tableMetadatas);
            if (activeSessionStorages == null) {
                activeSessionStorages = new ArrayList<DataStorage>();
            }
            activeSessionStorages.add(newStorage);
            this.activeDataStorages.put(session, activeSessionStorages);
            return newStorage;
        }
        if (this.perstistentDataStorageFactories != null) {
            for (PersistentDataStorageFactory persistentDataStorageFactory : this.perstistentDataStorageFactories) {
                if (!persistentDataStorageFactory.getStorageTypes().contains(storageType) || (newStorage = persistentDataStorageFactory.createStorage()) == null) continue;
                if (newStorage instanceof ProxyDataStorage) {
                    proxyStorage = (ProxyDataStorage)newStorage;
                    backendStorage = this.getDataStorageFor(session, proxyStorage.getBackendDataStorageType(), proxyStorage.getBackendTablesMetadata());
                    proxyStorage.attachTo(backendStorage);
                }
                newStorage.createTables(tableMetadatas);
                return newStorage;
            }
        }
        return null;
    }
}

