/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbverification.rules;

import com.sun.source.tree.ClassTree;
import java.util.Collection;
import java.util.LinkedList;
import java.util.Set;
import javax.lang.model.element.Element;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.ElementHandle;
import org.netbeans.modules.j2ee.ejbverification.EJBProblemContext;
import org.netbeans.modules.j2ee.ejbverification.EJBVerificationRule;
import org.netbeans.modules.j2ee.ejbverification.HintsUtils;
import org.netbeans.modules.j2ee.ejbverification.fixes.MakeClassPublic;
import org.netbeans.modules.j2ee.ejbverification.fixes.RemoveModifier;
import org.netbeans.spi.editor.hints.ErrorDescription;
import org.openide.util.NbBundle;

public class LegalModifiers
extends EJBVerificationRule {
    @Override
    public Collection<ErrorDescription> check(EJBProblemContext ctx) {
        if (ctx.getEjb() != null) {
            ErrorDescription err;
            Object fix;
            LinkedList<ErrorDescription> problemsFounds = new LinkedList<ErrorDescription>();
            Set<Modifier> modifiers = ctx.getClazz().getModifiers();
            if (!modifiers.contains((Object)Modifier.PUBLIC)) {
                fix = new MakeClassPublic(ctx.getFileObject(), (ElementHandle<TypeElement>)ElementHandle.create((Element)ctx.getClazz()));
                err = HintsUtils.createProblem((Element)ctx.getClazz(), ctx.getComplilationInfo(), NbBundle.getMessage(LegalModifiers.class, (String)"MSG_BeanClassMustBePublic"), fix);
                problemsFounds.add(err);
            }
            if (modifiers.contains((Object)Modifier.FINAL)) {
                fix = new RemoveModifier(ctx.getFileObject(), (ElementHandle<TypeElement>)ElementHandle.create((Element)ctx.getClazz()), Modifier.FINAL);
                err = HintsUtils.createProblem((Element)ctx.getClazz(), ctx.getComplilationInfo(), NbBundle.getMessage(LegalModifiers.class, (String)"MSG_BeanClassMustNotBeFinal"), fix);
                problemsFounds.add(err);
            }
            if (modifiers.contains((Object)Modifier.ABSTRACT)) {
                if (this.isInterface(ctx)) {
                    ErrorDescription err2 = HintsUtils.createProblem(ctx.getClazz(), ctx.getComplilationInfo(), NbBundle.getMessage(LegalModifiers.class, (String)"MSG_BeanClassMustNotBeAbstract"));
                    problemsFounds.add(err2);
                } else {
                    fix = new RemoveModifier(ctx.getFileObject(), (ElementHandle<TypeElement>)ElementHandle.create((Element)ctx.getClazz()), Modifier.ABSTRACT);
                    err = HintsUtils.createProblem((Element)ctx.getClazz(), ctx.getComplilationInfo(), NbBundle.getMessage(LegalModifiers.class, (String)"MSG_BeanClassMustNotBeAbstract"), fix);
                    problemsFounds.add(err);
                }
            }
            return problemsFounds;
        }
        return null;
    }

    private boolean isInterface(EJBProblemContext ctx) {
        ClassTree classTree = ctx.getComplilationInfo().getTrees().getTree(ctx.getClazz());
        return ctx.getComplilationInfo().getTreeUtilities().isInterface(classTree);
    }
}

