/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.core.stack.dataprovider.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.netbeans.modules.dlight.api.datafilter.DataFilter;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.core.stack.api.FunctionCall;
import org.netbeans.modules.dlight.core.stack.api.FunctionCallWithMetric;
import org.netbeans.modules.dlight.core.stack.api.FunctionMetric;
import org.netbeans.modules.dlight.core.stack.api.ThreadDumpProvider;
import org.netbeans.modules.dlight.core.stack.dataprovider.FunctionCallTreeTableNode;
import org.netbeans.modules.dlight.core.stack.dataprovider.StackDataProvider;
import org.netbeans.modules.dlight.core.stack.storage.StackDataStorage;
import org.netbeans.modules.dlight.core.stack.utils.FunctionNameUtils;
import org.netbeans.modules.dlight.spi.SourceFileInfoProvider;
import org.netbeans.modules.dlight.spi.storage.DataStorage;
import org.netbeans.modules.dlight.spi.storage.ServiceInfoDataStorage;
import org.openide.util.Lookup;

final class StackDataProviderImpl
implements StackDataProvider {
    private final List<FunctionMetric> metricsList = Arrays.asList(FunctionMetric.CpuTimeInclusiveMetric, FunctionMetric.CpuTimeExclusiveMetric);
    private StackDataStorage storage;
    private ServiceInfoDataStorage serviceInfoDataStorage;
    private final Lock lock = new Lock();
    private final List<DataFilter> filters = new ArrayList<DataFilter>();

    StackDataProviderImpl() {
    }

    public void attachTo(DataStorage storage) {
        this.storage = (StackDataStorage)storage;
    }

    public void attachTo(ServiceInfoDataStorage serviceInfoDataStorage) {
        this.serviceInfoDataStorage = serviceInfoDataStorage;
    }

    @Override
    public List<FunctionMetric> getMetricsList() {
        return this.metricsList;
    }

    @Override
    public List<FunctionCallWithMetric> getCallers(List<FunctionCallWithMetric> path, List<DataTableMetadata.Column> columns, List<DataTableMetadata.Column> orderBy, boolean aggregate) {
        return this.storage.getCallers(path, columns, orderBy, aggregate);
    }

    @Override
    public List<FunctionCallWithMetric> getCallees(List<FunctionCallWithMetric> path, List<DataTableMetadata.Column> columns, List<DataTableMetadata.Column> orderBy, boolean aggregate) {
        return this.storage.getCallees(path, columns, orderBy, aggregate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FunctionCallWithMetric> getHotSpotFunctions(List<DataTableMetadata.Column> columns, List<DataTableMetadata.Column> orderBy, int limit) {
        ArrayList<DataFilter> filtersCopy = null;
        Lock lock = this.lock;
        synchronized (lock) {
            filtersCopy = new ArrayList<DataFilter>(this.filters);
        }
        return this.storage.getHotSpotFunctions(FunctionMetric.CpuTimeInclusiveMetric, filtersCopy, limit);
    }

    @Override
    public List<FunctionCall> getCallStack(int stackId) {
        return this.storage.getCallStack(stackId);
    }

    public List<FunctionCallTreeTableNode> getTableView(List<DataTableMetadata.Column> columns, List<DataTableMetadata.Column> orderBy, int limit) {
        return FunctionCallTreeTableNode.getFunctionCallTreeTableNodes(this.getHotSpotFunctions(null, null, limit));
    }

    public List<FunctionCallTreeTableNode> getChildren(List<FunctionCallTreeTableNode> path, List<DataTableMetadata.Column> columns, List<DataTableMetadata.Column> orderBy) {
        List<FunctionCallWithMetric> fcPath = FunctionCallTreeTableNode.getFunctionCalls(path);
        List<FunctionCallWithMetric> callers = this.getCallees(fcPath, columns, orderBy, false);
        return FunctionCallTreeTableNode.getFunctionCallTreeTableNodes(callers);
    }

    public FunctionCallTreeTableNode getValueAt(int row) {
        return null;
    }

    public String getTableValueAt(DataTableMetadata.Column column, int row) {
        return null;
    }

    @Override
    public SourceFileInfoProvider.SourceFileInfo getSourceFileInfo(FunctionCall functionCall) {
        SourceFileInfoProvider.SourceFileInfo info = FunctionNameUtils.getSourceFileInfo(functionCall.getFunction().getSignature());
        if (info != null) {
            return info;
        }
        Collection sourceInfoProviders = Lookup.getDefault().lookupAll(SourceFileInfoProvider.class);
        for (SourceFileInfoProvider provider : sourceInfoProviders) {
            SourceFileInfoProvider.SourceFileInfo sourceInfo;
            long offset = functionCall.getOffset();
            if (offset > 0L) {
                --offset;
            }
            if ((sourceInfo = provider.getSourceFileInfo(functionCall.getFunction().getQuilifiedName(), -1, offset, this.serviceInfoDataStorage.getInfo())) == null || !sourceInfo.isSourceKnown()) continue;
            return sourceInfo;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dataFiltersChanged(List<DataFilter> newSet, boolean isAdjusting) {
        if (isAdjusting) {
            return;
        }
        Lock lock = this.lock;
        synchronized (lock) {
            this.filters.clear();
            this.filters.addAll(newSet);
        }
    }

    @Override
    public ThreadDumpProvider getThreadDumpProvider() {
        if (this.storage instanceof ThreadDumpProvider) {
            return (ThreadDumpProvider)((Object)this.storage);
        }
        return null;
    }

    private static final class Lock {
        private Lock() {
        }
    }
}

