/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.core.stack.storage.impl;

import java.util.HashMap;

final class MetricsCache {
    private final HashMap<Long, HashMap<Long, Metrics>> funcCache = new HashMap();
    private final HashMap<Long, HashMap<Long, Metrics>> nodeCache = new HashMap();

    MetricsCache() {
    }

    public void updateFunctionMetrics(long funcID, long bucket, long duration, boolean addIncl, boolean addExcl) {
        this.updateMetrics(this.funcCache, funcID, bucket, duration, addIncl, addExcl);
    }

    public void updateNodeMetrics(long nodeID, long bucket, long duration, boolean addIncl, boolean addExcl) {
        this.updateMetrics(this.nodeCache, nodeID, bucket, duration, addIncl, addExcl);
    }

    public Metrics getAndResetFunctionMetrics(long funcID, long bucket) {
        return this.getAndResetMetrics(this.funcCache, funcID, bucket);
    }

    public Metrics getAndResetNodeMetrics(long nodeID, long bucket) {
        return this.getAndResetMetrics(this.nodeCache, nodeID, bucket);
    }

    private synchronized void updateMetrics(HashMap<Long, HashMap<Long, Metrics>> cache, long objectID, long bucket, long duration, boolean addIncl, boolean addExcl) {
        Metrics m;
        HashMap<Long, Metrics> objMetrics = cache.get(objectID);
        if (objMetrics == null) {
            objMetrics = new HashMap();
            cache.put(objectID, objMetrics);
        }
        if ((m = objMetrics.get(bucket)) == null) {
            m = new Metrics();
            objMetrics.put(bucket, m);
        }
        if (addIncl) {
            m.incl += duration;
        }
        if (addExcl) {
            m.excl += duration;
        }
    }

    private synchronized Metrics getAndResetMetrics(HashMap<Long, HashMap<Long, Metrics>> cache, long objectID, long bucket) {
        HashMap<Long, Metrics> objMetrics = cache.get(objectID);
        if (objMetrics == null || objMetrics.isEmpty()) {
            return null;
        }
        return objMetrics.remove(bucket);
    }

    public static class Metrics {
        long incl;
        long excl;
    }
}

