/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.core.stack.storage.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.netbeans.modules.dlight.api.datafilter.DataFilter;
import org.netbeans.modules.dlight.api.datafilter.support.TimeIntervalDataFilter;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.api.storage.DataTableMetadataFilterSupport;
import org.netbeans.modules.dlight.api.storage.types.Time;
import org.netbeans.modules.dlight.core.stack.api.Function;
import org.netbeans.modules.dlight.core.stack.api.FunctionCall;
import org.netbeans.modules.dlight.core.stack.api.FunctionCallWithMetric;
import org.netbeans.modules.dlight.core.stack.api.FunctionMetric;
import org.netbeans.modules.dlight.core.stack.api.ThreadDump;
import org.netbeans.modules.dlight.core.stack.api.ThreadDumpProvider;
import org.netbeans.modules.dlight.core.stack.api.ThreadDumpQuery;
import org.netbeans.modules.dlight.core.stack.api.ThreadSnapshot;
import org.netbeans.modules.dlight.core.stack.api.ThreadSnapshotQuery;
import org.netbeans.modules.dlight.core.stack.api.ThreadState;
import org.netbeans.modules.dlight.core.stack.api.support.FunctionDatatableDescription;
import org.netbeans.modules.dlight.core.stack.api.support.FunctionMetricsFactory;
import org.netbeans.modules.dlight.core.stack.storage.StackDataStorage;
import org.netbeans.modules.dlight.core.stack.storage.impl.MetricsCache;
import org.netbeans.modules.dlight.core.stack.storage.impl.SQLStackRequestsProvider;
import org.netbeans.modules.dlight.core.stack.storage.impl.SnapshotImpl;
import org.netbeans.modules.dlight.core.stack.storage.impl.ThreadDumpImpl;
import org.netbeans.modules.dlight.core.stack.utils.FunctionNameUtils;
import org.netbeans.modules.dlight.spi.CppSymbolDemangler;
import org.netbeans.modules.dlight.spi.CppSymbolDemanglerFactory;
import org.netbeans.modules.dlight.spi.SourceFileInfoProvider;
import org.netbeans.modules.dlight.spi.storage.DataStorage;
import org.netbeans.modules.dlight.spi.storage.DataStorageType;
import org.netbeans.modules.dlight.spi.storage.ProxyDataStorage;
import org.netbeans.modules.dlight.spi.storage.ServiceInfoDataStorage;
import org.netbeans.modules.dlight.spi.support.DataStorageTypeFactory;
import org.netbeans.modules.dlight.spi.support.SQLDataStorage;
import org.netbeans.modules.dlight.spi.support.SQLRequest;
import org.netbeans.modules.dlight.spi.support.SQLRequestsProcessor;
import org.netbeans.modules.dlight.spi.support.SQLStatementsCache;
import org.netbeans.modules.dlight.util.Util;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;

public class SQLStackDataStorage
implements ProxyDataStorage,
StackDataStorage,
ThreadDumpProvider {
    private final List<DataTableMetadata> tableMetadatas;
    private final Map<CharSequence, Long> funcCache;
    private final Map<NodeCacheKey, Long> nodeCache;
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private MetricsCache metricsCache;
    private SQLRequestsProcessor requestsProcessor;
    private SQLStackRequestsProvider requestsProvider;
    private SQLStatementsCache stmtCache;
    private SQLDataStorage sqlStorage;
    private CppSymbolDemangler demangler;
    private ServiceInfoDataStorage serviceInfoDataStorage;
    private long funcIdSequence = 0L;
    private long nodeIdSequence = 0L;

    public SQLStackDataStorage() {
        this.tableMetadatas = new ArrayList<DataTableMetadata>();
        this.funcCache = new HashMap<CharSequence, Long>();
        this.nodeCache = new HashMap<NodeCacheKey, Long>();
    }

    public void syncAddData(String tableName, List<DataRow> data) {
        this.addData(tableName, data);
    }

    public final void attachTo(ServiceInfoDataStorage serviceInfoStorage) {
        this.serviceInfoDataStorage = serviceInfoStorage;
        CppSymbolDemanglerFactory factory = (CppSymbolDemanglerFactory)Lookup.getDefault().lookup(CppSymbolDemanglerFactory.class);
        this.demangler = factory != null ? factory.getForCurrentSession(serviceInfoStorage.getInfo()) : null;
    }

    public DataStorageType getBackendDataStorageType() {
        return DataStorageTypeFactory.getInstance().getDataStorageType("db:sql");
    }

    public List<DataTableMetadata> getBackendTablesMetadata() {
        return Collections.emptyList();
    }

    public synchronized void attachTo(DataStorage storage) {
        if (this.sqlStorage != null) {
            throw new IllegalStateException("Already attached");
        }
        this.sqlStorage = (SQLDataStorage)storage;
        this.stmtCache = SQLStatementsCache.getFor((SQLDataStorage)this.sqlStorage);
        this.metricsCache = new MetricsCache();
        this.requestsProvider = new SQLStackRequestsProvider(this.stmtCache, this.metricsCache);
        this.requestsProcessor = this.sqlStorage.getRequestsProcessor();
        try {
            this.initTables();
        }
        catch (Exception ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
    }

    private <T extends DataFilter> Collection<T> getDataFilters(List<DataFilter> filters, Class<T> clazz) {
        ArrayList<T> result = new ArrayList<T>();
        for (DataFilter f : filters) {
            if (f.getClass() != clazz) continue;
            result.add(clazz.cast(f));
        }
        return result;
    }

    public boolean hasData(DataTableMetadata data) {
        return data.isProvidedBy(this.tableMetadatas);
    }

    public void addData(String tableName, List<DataRow> data) {
    }

    public Collection<DataStorageType> getStorageTypes() {
        return Collections.singletonList(DataStorageTypeFactory.getInstance().getDataStorageType("stack"));
    }

    public boolean supportsType(DataStorageType storageType) {
        return this.getStorageTypes().contains(storageType);
    }

    public void createTables(List<DataTableMetadata> tableMetadatas) {
        this.tableMetadatas.addAll(tableMetadatas);
    }

    public boolean shutdown(boolean shutdownSqlStorage) {
        boolean result = this.shutdown();
        if (shutdownSqlStorage) {
            result = this.sqlStorage.shutdown() && result;
        }
        return result;
    }

    public boolean shutdown() {
        if (this.closed.compareAndSet(false, true)) {
            this.funcCache.clear();
            this.nodeCache.clear();
            this.metricsCache = null;
            this.requestsProvider = null;
            try {
                this.stmtCache.close();
            }
            catch (SQLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
            this.stmtCache = null;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initTables() throws SQLException, IOException {
        InputStream is = SQLStackDataStorage.class.getClassLoader().getResourceAsStream("org/netbeans/modules/dlight/core/stack/resources/schema.sql");
        BufferedReader reader = new BufferedReader(new InputStreamReader(is));
        try {
            String line;
            Pattern autoIncrementPattern = Pattern.compile("\\{AUTO_INCREMENT\\}");
            StringBuilder buf = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("-- ")) continue;
                line = autoIncrementPattern.matcher(line).replaceAll(this.sqlStorage.getAutoIncrementExpresion());
                buf.append(line);
                if (!line.endsWith(";")) continue;
                String sql = buf.toString();
                buf.setLength(0);
                String sqlToExecute = sql.substring(0, sql.length() - 1);
                try {
                    this.sqlStorage.executeUpdate(sqlToExecute);
                }
                catch (SQLException e) {}
            }
        }
        finally {
            reader.close();
        }
    }

    @Override
    public long putStack(List<CharSequence> stack) {
        return this.putSample(stack, -1L, -1L);
    }

    @Override
    public long putSample(List<CharSequence> stack, long timestamp, long duration) {
        long callerId = 0L;
        HashSet<Long> funcs = new HashSet<Long>();
        for (int i = stack.size() - 1; i >= 0; --i) {
            boolean isLeaf = i == 0;
            CharSequence funcName = stack.get(i);
            SourceFileInfoProvider.SourceFileInfo sourceFile = FunctionNameUtils.getSourceFileInfo(((Object)funcName).toString());
            long funcId = this.generateFuncId(funcName, sourceFile);
            this.updateMetrics(funcId, false, timestamp, duration, !funcs.contains(funcId), isLeaf);
            funcs.add(funcId);
            long nodeId = this.generateNodeId(callerId, funcId, this.getOffset(funcName), sourceFile == null ? -1 : sourceFile.getLine());
            this.updateMetrics(nodeId, true, timestamp, duration, true, isLeaf);
            callerId = nodeId;
        }
        return callerId;
    }

    public void flush() {
        this.requestsProcessor.flush();
    }

    @Override
    public List<FunctionMetric> getMetricsList() {
        return METRICS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FunctionCallWithMetric> getCallers(List<FunctionCallWithMetric> path, List<DataTableMetadata.Column> columns, List<DataTableMetadata.Column> orderBy, boolean aggregate) {
        try {
            ArrayList<FunctionCallWithMetric> result = new ArrayList<FunctionCallWithMetric>();
            ResultSet rs = this.sqlStorage.select(null, null, this.prepareCallersSelect(path));
            try {
                while (rs.next()) {
                    HashMap<FunctionMetric, Object> metrics = new HashMap<FunctionMetric, Object>();
                    metrics.put(FunctionMetric.CpuTimeInclusiveMetric, new Time(rs.getLong(3)));
                    metrics.put(FunctionMetric.CpuTimeExclusiveMetric, new Time(rs.getLong(4)));
                    String funcName = rs.getString(2);
                    String fileName = rs.getString(5);
                    long line_number = rs.getLong(6);
                    String createdFullName = funcName + (fileName != null ? ":" + fileName + ":" + line_number : "");
                    result.add(new FunctionCallImpl((Function)new FunctionImpl(rs.getInt(1), funcName, createdFullName, fileName), metrics));
                }
            }
            finally {
                rs.close();
            }
            this.demangle(result);
            return result;
        }
        catch (SQLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return Collections.emptyList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FunctionCallWithMetric> getCallees(List<FunctionCallWithMetric> path, List<DataTableMetadata.Column> columns, List<DataTableMetadata.Column> orderBy, boolean aggregate) {
        try {
            ArrayList<FunctionCallWithMetric> result = new ArrayList<FunctionCallWithMetric>();
            ResultSet rs = this.sqlStorage.select(null, null, this.prepareCalleesSelect(path));
            try {
                while (rs.next()) {
                    HashMap<FunctionMetric, Object> metrics = new HashMap<FunctionMetric, Object>();
                    metrics.put(FunctionMetric.CpuTimeInclusiveMetric, new Time(rs.getLong(3)));
                    metrics.put(FunctionMetric.CpuTimeExclusiveMetric, new Time(rs.getLong(4)));
                    String funcName = rs.getString(2);
                    String fileName = rs.getString(5);
                    long line_number = rs.getLong(6);
                    String createdFullName = funcName + (fileName != null ? ":" + fileName + ":" + line_number : "");
                    result.add(new FunctionCallImpl((Function)new FunctionImpl(rs.getInt(1), funcName, createdFullName, fileName), metrics));
                }
            }
            finally {
                rs.close();
            }
            this.demangle(result);
            return result;
        }
        catch (SQLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return Collections.emptyList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FunctionCallWithMetric> getHotSpotFunctions(FunctionMetric metric, List<DataFilter> filters, int limit) {
        try {
            ArrayList<FunctionCallWithMetric> funcList = new ArrayList<FunctionCallWithMetric>();
            TimeIntervalDataFilter timeFilter = (TimeIntervalDataFilter)Util.firstInstanceOf(TimeIntervalDataFilter.class, filters);
            PreparedStatement select = this.stmtCache.getPreparedStatement("SELECT Func.func_id, Func.func_name, SUM(FuncMetricAggr.time_incl) AS time_incl, SUM(FuncMetricAggr.time_excl) AS time_excl, SourceFiles.source_file, Func.line_number   FROM Func LEFT JOIN FuncMetricAggr ON Func.func_id = FuncMetricAggr.func_id  LEFT JOIN SourceFiles ON Func.func_source_file_id = SourceFiles.id " + (timeFilter != null ? "WHERE ? <= FuncMetricAggr.bucket_id AND FuncMetricAggr.bucket_id < ? " : "") + "GROUP BY Func.func_id, Func.func_name,  SourceFiles.source_file, Func.line_number " + "ORDER BY " + metric.getMetricID() + " DESC");
            if (timeFilter != null) {
                select.setLong(1, SQLStackDataStorage.timeToBucketId((Long)timeFilter.getInterval().getStart()));
                select.setLong(2, SQLStackDataStorage.timeToBucketId((Long)timeFilter.getInterval().getEnd()));
            }
            select.setMaxRows(limit);
            ResultSet rs = select.executeQuery();
            try {
                while (rs.next()) {
                    HashMap<FunctionMetric, Object> metrics = new HashMap<FunctionMetric, Object>();
                    metrics.put(FunctionMetric.CpuTimeInclusiveMetric, new Time(rs.getLong(3)));
                    metrics.put(FunctionMetric.CpuTimeExclusiveMetric, new Time(rs.getLong(4)));
                    String name = rs.getString(2);
                    String fileName = rs.getString(5);
                    long line_number = rs.getLong(6);
                    String createdFullName = name + (fileName != null ? ":" + fileName + ":" + line_number : "");
                    funcList.add(new FunctionCallImpl((Function)new FunctionImpl(rs.getInt(1), name, createdFullName, fileName), metrics));
                }
            }
            finally {
                rs.close();
            }
            this.demangle(funcList);
            return funcList;
        }
        catch (SQLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return Collections.emptyList();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FunctionCallWithMetric> getFunctionsList(DataTableMetadata metadata, List<DataTableMetadata.Column> metricsColumn, FunctionDatatableDescription functionDescription, List<DataFilter> filters) {
        try {
            ArrayList<FunctionMetric> metrics = new ArrayList<FunctionMetric>();
            for (DataTableMetadata.Column metricColumn : metricsColumn) {
                FunctionMetric metric = FunctionMetricsFactory.getInstance().getFunctionMetric(new FunctionMetric.FunctionMetricConfiguration(metricColumn.getColumnName(), metricColumn.getColumnUName(), metricColumn.getColumnClass()));
                metrics.add(metric);
            }
            String functionColumnName = functionDescription.getNameColumn();
            String offesetColumnName = functionDescription.getOffsetColumn();
            String functionUniqueID = functionDescription.getUniqueColumnName();
            ArrayList<FunctionCallWithMetric> funcList = new ArrayList<FunctionCallWithMetric>();
            Collection<TimeIntervalDataFilter> timeFilters = this.getDataFilters(filters, TimeIntervalDataFilter.class);
            ArrayList tableFilters = new ArrayList();
            DataTableMetadataFilterSupport filtersSupport = DataTableMetadataFilterSupport.getInstance();
            for (TimeIntervalDataFilter timeFilter : timeFilters) {
                tableFilters.addAll(filtersSupport.createFilters(metadata, timeFilter));
            }
            ResultSet rs = this.sqlStorage.select(metadata, tableFilters);
            try {
                while (rs.next()) {
                    HashMap<FunctionMetric, Object> metricValues = new HashMap<FunctionMetric, Object>();
                    for (FunctionMetric m : metrics) {
                        try {
                            rs.findColumn(m.getMetricID());
                            Object value = rs.getObject(m.getMetricID());
                            if (m.getMetricValueClass() == Time.class && value != null) {
                                value = new Time(Long.valueOf(value + "").longValue());
                            }
                            metricValues.put(m, value);
                        }
                        catch (SQLException e) {
                            Exceptions.printStackTrace((Throwable)e);
                        }
                    }
                    String funcName = rs.getString(functionColumnName);
                    funcList.add(new FunctionCallImpl((Function)new FunctionImpl(rs.getInt(functionUniqueID), funcName, funcName), offesetColumnName != null ? rs.getLong(offesetColumnName) : -1L, metricValues));
                }
            }
            finally {
                rs.close();
            }
            this.demangle(funcList);
            return funcList;
        }
        catch (SQLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return Collections.emptyList();
        }
    }

    private void updateMetrics(long id, boolean funcOrNode, long timestamp, long duration, boolean addIncl, boolean addExcl) {
        if (duration > 0L) {
            SQLRequest request;
            long bucket = SQLStackDataStorage.timeToBucketId(timestamp);
            if (funcOrNode) {
                this.metricsCache.updateNodeMetrics(id, bucket, duration, addIncl, addExcl);
                request = this.requestsProvider.updateNodeMetrics(id, bucket);
            } else {
                this.metricsCache.updateFunctionMetrics(id, bucket, duration, addIncl, addExcl);
                request = this.requestsProvider.updateFunctionMetrics(id, bucket);
            }
            this.requestsProcessor.queueRequest(request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long generateNodeId(long callerId, long funcId, long offset, int lineNumber) {
        Map<NodeCacheKey, Long> map = this.nodeCache;
        synchronized (map) {
            NodeCacheKey cacheKey;
            Long nodeId;
            long lastNodeKey = offset;
            if (lineNumber != -1) {
                lastNodeKey = lineNumber;
            }
            if ((nodeId = this.nodeCache.get(cacheKey = new NodeCacheKey(callerId, funcId, lastNodeKey))) == null) {
                nodeId = ++this.nodeIdSequence;
                SQLStackRequestsProvider.AddNodeRequest cmd = this.requestsProvider.addNode(nodeId, callerId, funcId, offset, lineNumber);
                this.requestsProcessor.queueRequest((SQLRequest)cmd);
                this.nodeCache.put(cacheKey, nodeId);
            }
            return nodeId;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long generateFuncId(CharSequence fname, SourceFileInfoProvider.SourceFileInfo sourceFileInfo) {
        int plusPos;
        String funcName;
        String fullFuncName = funcName = ((Object)fname).toString();
        int source_file_index = -1;
        int line_number = -1;
        if (sourceFileInfo != null && sourceFileInfo.getFileName() != null) {
            line_number = sourceFileInfo.getLine();
            plusPos = this.lastIndexOf(funcName, '+');
            if (0 <= plusPos) {
                funcName = funcName.substring(0, plusPos);
            }
            try {
                PreparedStatement ps = this.stmtCache.getPreparedStatement("SELECT id from SourceFiles where source_file=?");
                ps.setString(1, sourceFileInfo.getFileName());
                ResultSet rs = ps.executeQuery();
                if (rs != null && rs.next()) {
                    source_file_index = rs.getInt("id");
                } else {
                    ResultSet generatedKeys;
                    PreparedStatement stmt = this.stmtCache.getPreparedStatement("INSERT INTO SourceFiles (source_file) VALUES (?)");
                    stmt.setString(1, sourceFileInfo.getFileName());
                    int r = stmt.executeUpdate();
                    if (r > 0 && (generatedKeys = stmt.getGeneratedKeys()) != null && generatedKeys.next() && generatedKeys.getMetaData().getColumnCount() > 0) {
                        source_file_index = generatedKeys.getInt(1);
                    }
                }
            }
            catch (SQLException ex) {
                Exceptions.printStackTrace((Throwable)ex);
            }
        } else {
            plusPos = this.lastIndexOf(funcName, '+');
            if (0 <= plusPos) {
                funcName = funcName.substring(0, plusPos);
            }
            fullFuncName = funcName;
        }
        Map<CharSequence, Long> map = this.funcCache;
        synchronized (map) {
            Long funcId = this.funcCache.get(funcName);
            if (funcId == null) {
                funcId = ++this.funcIdSequence;
                SQLStackRequestsProvider.AddFunctionRequest cmd = this.requestsProvider.addFunction(funcId, funcName, source_file_index, line_number);
                this.requestsProcessor.queueRequest((SQLRequest)cmd);
                this.funcCache.put(funcName, funcId);
            }
            return funcId;
        }
    }

    private long getOffset(CharSequence cs) {
        int plusPos = this.lastIndexOf(cs, '+');
        if (0 <= plusPos) {
            try {
                return Long.parseLong(((Object)cs.subSequence(plusPos + 3, cs.length())).toString(), 16);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return 0L;
    }

    private int lastIndexOf(CharSequence cs, char c) {
        for (int i = cs.length() - 1; 0 <= i; --i) {
            if (cs.charAt(i) != c) continue;
            return i;
        }
        return -1;
    }

    private String prepareCallersSelect(List<FunctionCallWithMetric> path) throws SQLException {
        int i;
        StringBuilder buf = new StringBuilder();
        int size = path.size();
        buf.append(" SELECT F.func_id, F.func_name, SUM(N.time_incl), SUM(N.time_excl),  S.source_file, N.line_number  FROM Node AS N ");
        buf.append(" LEFT JOIN Func AS F ON N.func_id = F.func_id ");
        buf.append(" LEFT JOIN SourceFiles AS S ON F.func_source_file_id = S.id  ");
        buf.append(" INNER JOIN Node N1 ON N.node_id = N1.caller_id ");
        for (i = 1; i < size; ++i) {
            buf.append(" INNER JOIN Node AS N").append(i + 1);
            buf.append(" ON N").append(i).append(".node_id = N").append(i + 1).append(".caller_id ");
        }
        buf.append(" WHERE ");
        for (i = 0; i < size; ++i) {
            if (0 < i) {
                buf.append("AND ");
            }
            buf.append("N").append(i + 1).append(".func_id = ");
            buf.append(((FunctionImpl)path.get(i).getFunction()).getId());
        }
        buf.append(" GROUP BY F.func_id, F.func_name, S.source_file, N.line_number");
        return buf.toString();
    }

    private String prepareCalleesSelect(List<FunctionCallWithMetric> path) throws SQLException {
        int i;
        StringBuilder buf = new StringBuilder();
        int size = path.size();
        buf.append("SELECT F.func_id, F.func_name,  SUM(N.time_incl), SUM(N.time_excl),  S.source_file, N1.line_number  FROM Node AS N1 ");
        for (i = 1; i < size; ++i) {
            buf.append(" INNER JOIN Node AS N").append(i + 1);
            buf.append(" ON N").append(i).append(".node_id = N").append(i + 1).append(".caller_id ");
        }
        buf.append(" INNER JOIN Node N ON N").append(size).append(".node_id = N.caller_id ");
        buf.append(" LEFT JOIN Func AS F ON N.func_id = F.func_id ");
        buf.append(" LEFT JOIN SourceFiles  AS S ON F.func_source_file_id = S.id  ");
        buf.append(" WHERE ");
        for (i = 0; i < size; ++i) {
            if (0 < i) {
                buf.append(" AND ");
            }
            buf.append(" N").append(i + 1).append(".func_id = ");
            buf.append(((FunctionImpl)path.get(i).getFunction()).getId());
        }
        buf.append(" GROUP BY F.func_id, F.func_name, S.source_file, N1.line_number");
        return buf.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ThreadSnapshot fetchSnapshot(int threadId, long timestamp, boolean fullMsa) throws SQLException {
        PreparedStatement s = this.stmtCache.getPreparedStatement("SELECT stack_id, mstate FROM CallStack WHERE thread_id = ? AND timestamp = ?");
        s.setInt(1, threadId);
        s.setLong(2, timestamp);
        ResultSet rs = s.executeQuery();
        try {
            if (rs.next()) {
                SnapshotImpl snapshotImpl = new SnapshotImpl(this, timestamp, threadId, rs.getInt(1), ThreadState.MSAState.fromCode(rs.getInt(2), fullMsa));
                return snapshotImpl;
            }
            ThreadSnapshot threadSnapshot = null;
            return threadSnapshot;
        }
        finally {
            rs.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<ThreadSnapshot> getThreadSnapshots(ThreadSnapshotQuery query) {
        ThreadSnapshotQuery.TimeFilter timeFilter;
        ArrayList<String> conditions = new ArrayList<String>(3);
        ThreadSnapshotQuery.ThreadFilter threadFilter = (ThreadSnapshotQuery.ThreadFilter)Util.firstInstanceOf(ThreadSnapshotQuery.ThreadFilter.class, query.getFilters());
        if (threadFilter != null) {
            StringBuilder where = new StringBuilder("thread_id IN (");
            boolean first = true;
            for (int threadId : threadFilter.getThreadIds()) {
                if (first) {
                    first = false;
                } else {
                    where.append(',');
                }
                where.append(threadId);
            }
            where.append(')');
            conditions.add(where.toString());
        }
        if ((timeFilter = (ThreadSnapshotQuery.TimeFilter)Util.firstInstanceOf(ThreadSnapshotQuery.TimeFilter.class, query.getFilters())) != null) {
            if (0L <= timeFilter.getStartTime()) {
                conditions.add(timeFilter.getStartTime() + " <= timestamp");
            }
            if (0L <= timeFilter.getEndTime()) {
                conditions.add("timestamp <= " + timeFilter.getEndTime());
            }
        }
        StringBuilder select = new StringBuilder("SELECT thread_id, ");
        if (timeFilter != null) {
            switch (timeFilter.getMode()) {
                case FIRST: {
                    select.append("MIN(timestamp) ");
                    break;
                }
                case LAST: {
                    select.append("MAX(timestamp) ");
                    break;
                }
                default: {
                    select.append("timestamp ");
                    break;
                }
            }
        } else {
            select.append("timestamp ");
        }
        select.append("FROM CallStack ");
        if (!conditions.isEmpty()) {
            select.append("WHERE ");
            boolean first = true;
            for (String condition : conditions) {
                if (first) {
                    first = false;
                } else {
                    select.append("AND ");
                }
                select.append(condition).append(' ');
            }
        }
        if (timeFilter != null && timeFilter.getMode() != ThreadSnapshotQuery.TimeFilter.Mode.ALL) {
            select.append("GROUP BY thread_id");
        }
        try {
            ArrayList<ThreadSnapshot> snapshots = new ArrayList<ThreadSnapshot>();
            ResultSet rs = this.sqlStorage.select(null, null, select.toString());
            try {
                if (rs != null) {
                    while (rs.next()) {
                        ThreadSnapshot snapshot = this.fetchSnapshot(rs.getInt(1), rs.getLong(2), query.isFullMSA());
                        if (snapshot == null) continue;
                        snapshots.add(snapshot);
                    }
                }
            }
            finally {
                if (rs != null) {
                    rs.close();
                }
            }
            return snapshots;
        }
        catch (SQLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
            return Collections.emptyList();
        }
    }

    @Override
    public ThreadDump getThreadDump(ThreadDumpQuery query) {
        ThreadDump res = this._getThreadDump(query);
        if (res == null) {
            return null;
        }
        ThreadDumpImpl result = new ThreadDumpImpl(res.getTimestamp());
        block0: for (Integer i : query.getShowThreads()) {
            for (ThreadSnapshot dump : res.getThreadStates()) {
                if (dump.getThreadInfo().getThreadId() != i.intValue()) continue;
                result.addStack(dump);
                continue block0;
            }
        }
        return result;
    }

    private ThreadState.MSAState getTrueState(ThreadSnapshot dump, ThreadDumpQuery query) {
        ThreadState.MSAState state = dump.getState();
        return state;
    }

    private ThreadDump _getThreadDump(ThreadDumpQuery query) {
        long start = query.getThreadState().getTimeStamp();
        long middle = query.getThreadState().getTimeStamp() + query.getThreadState().getMSASamplePeriod() / 2L;
        long end = query.getThreadState().getTimeStamp() + query.getThreadState().getMSASamplePeriod();
        ThreadSnapshotQuery.TimeFilter time = new ThreadSnapshotQuery.TimeFilter(start, end, ThreadSnapshotQuery.TimeFilter.Mode.ALL);
        ThreadSnapshotQuery.ThreadFilter threads = new ThreadSnapshotQuery.ThreadFilter(query.getShowThreads());
        Collection res = this.getThreadSnapshots(new ThreadSnapshotQuery(query.isFullMode(), time, threads));
        ThreadSnapshot found = null;
        long foundTimeSamp = -1L;
        for (ThreadSnapshot dump : res) {
            if (query.getThreadID() != (long)dump.getThreadInfo().getThreadId() || query.getPreferredState() != this.getTrueState(dump, query)) continue;
            found = dump;
            foundTimeSamp = found.getTimestamp();
            break;
        }
        if (found == null) {
            time = new ThreadSnapshotQuery.TimeFilter(0L, middle, ThreadSnapshotQuery.TimeFilter.Mode.LAST);
            threads = new ThreadSnapshotQuery.ThreadFilter(Collections.singletonList((int)query.getThreadID()));
            Collection res2 = this.getThreadSnapshots(new ThreadSnapshotQuery(query.isFullMode(), time, threads));
            long foundAny = -1L;
            for (ThreadSnapshot dump : res2) {
                foundAny = dump.getTimestamp();
                if (query.getThreadID() != (long)dump.getThreadInfo().getThreadId() || query.getPreferredState() != this.getTrueState(dump, query)) continue;
                found = dump;
                foundTimeSamp = middle;
                break;
            }
            if (found == null && foundAny > 0L) {
                time = new ThreadSnapshotQuery.TimeFilter(foundAny - 1000000L, foundAny + 1L, ThreadSnapshotQuery.TimeFilter.Mode.ALL);
                threads = new ThreadSnapshotQuery.ThreadFilter(Collections.singletonList((int)query.getThreadID()));
                res2 = this.getThreadSnapshots(new ThreadSnapshotQuery(query.isFullMode(), time, threads));
                for (ThreadSnapshot dump : res2) {
                    foundAny = dump.getTimestamp();
                    if (query.getThreadID() != (long)dump.getThreadInfo().getThreadId() || query.getPreferredState() != this.getTrueState(dump, query)) continue;
                    found = dump;
                    foundTimeSamp = middle;
                    break;
                }
                if (found == null) {
                    for (ThreadSnapshot dump : res2) {
                        foundAny = dump.getTimestamp();
                        if (query.getThreadID() != (long)dump.getThreadInfo().getThreadId()) continue;
                        found = dump;
                        foundTimeSamp = middle;
                        break;
                    }
                }
            }
        }
        if (found != null) {
            HashMap<Integer, ThreadSnapshot> map = new HashMap<Integer, ThreadSnapshot>();
            map.put(found.getThreadInfo().getThreadId(), found);
            for (ThreadSnapshot dump : res) {
                if (dump.getThreadInfo().getThreadId() == found.getThreadInfo().getThreadId()) continue;
                int id = dump.getThreadInfo().getThreadId();
                ThreadSnapshot prev = (ThreadSnapshot)map.get(id);
                if (prev == null) {
                    map.put(id, dump);
                    continue;
                }
                if (Math.abs(prev.getTimestamp() - foundTimeSamp) <= Math.abs(dump.getTimestamp() - foundTimeSamp)) continue;
                map.put(id, dump);
            }
            HashSet<Integer> toAdd = new HashSet<Integer>(query.getShowThreads());
            ThreadDumpImpl result = new ThreadDumpImpl(foundTimeSamp);
            for (ThreadSnapshot dump : map.values()) {
                toAdd.remove(dump.getThreadInfo().getThreadId());
                result.addStack(dump);
            }
            if (!toAdd.isEmpty()) {
                time = new ThreadSnapshotQuery.TimeFilter(0L, foundTimeSamp, ThreadSnapshotQuery.TimeFilter.Mode.LAST);
                threads = new ThreadSnapshotQuery.ThreadFilter(toAdd);
                res = this.getThreadSnapshots(new ThreadSnapshotQuery(query.isFullMode(), time, threads));
                for (ThreadSnapshot dump : res) {
                    result.addStack(dump);
                }
            }
            return result;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized List<FunctionCall> getCallStack(long stackId) {
        ArrayList<FunctionCall> result = new ArrayList<FunctionCall>();
        try {
            long nodeID = stackId;
            while (0L < nodeID) {
                PreparedStatement ps = this.stmtCache.getPreparedStatement("SELECT Node.node_id, Node.caller_id, Node.func_id, Node.offset, Node.line_number, Func.func_name,  SourceFiles.source_file FROM Node LEFT JOIN Func ON Node.func_id = Func.func_id LEFT JOIN SourceFiles ON Func.func_source_file_id = SourceFiles.id WHERE node_id = ?");
                ps.setLong(1, nodeID);
                ResultSet rs = ps.executeQuery();
                try {
                    if (rs.next()) {
                        String funcName = rs.getString(6);
                        long line_number = rs.getLong(5);
                        String fileName = rs.getString(7);
                        long offset = rs.getLong(4);
                        String fullFuncName = funcName + "+0x" + Long.toHexString(offset) + (fileName != null ? ":" + fileName + ":" + line_number : "");
                        FunctionImpl func = new FunctionImpl(rs.getInt(3), funcName, fullFuncName, fileName);
                        result.add(new FunctionCallImpl((Function)func, offset, new HashMap<FunctionMetric, Object>()));
                        nodeID = rs.getInt(2);
                        continue;
                    }
                    break;
                }
                finally {
                    rs.close();
                }
            }
        }
        catch (SQLException ex) {
            Exceptions.printStackTrace((Throwable)ex);
        }
        this.demangle(result);
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private void demangle(List<? extends FunctionCall> calls) {
        if (this.demangler != null) {
            void var4_6;
            ArrayList<String> mangled = new ArrayList<String>(calls.size());
            for (FunctionCall functionCall : calls) {
                mangled.add(functionCall.getFunction().getName());
            }
            List demangled = this.demangler.demangle(mangled);
            boolean bl = false;
            while (var4_6 < calls.size()) {
                ((FunctionImpl)calls.get((int)var4_6).getFunction()).setName((String)demangled.get((int)var4_6));
                ++var4_6;
            }
        }
    }

    private static long timeToBucketId(long timestamp) {
        return timestamp / 1000L / 1000L / 1000L;
    }

    protected static class FunctionCallImpl
    extends FunctionCallWithMetric {
        private final Map<FunctionMetric, Object> metrics;
        private final int lineNumber;

        FunctionCallImpl(Function function, long offset, Map<FunctionMetric, Object> metrics) {
            super(function, offset);
            this.metrics = metrics;
            SourceFileInfoProvider.SourceFileInfo sourceFileInfo = FunctionNameUtils.getSourceFileInfo(function.getSignature());
            this.lineNumber = sourceFileInfo == null ? -1 : sourceFileInfo.getLine();
            this.setLineNumber(this.lineNumber);
        }

        FunctionCallImpl(Function function, Map<FunctionMetric, Object> metrics) {
            this(function, 0L, metrics);
        }

        @Override
        public String getDisplayedName() {
            if (this.hasLineNumber()) {
                return FunctionNameUtils.getFunctionName(this.getFunction().getSignature());
            }
            return this.getFunction().getName() + (this.hasOffset() ? "+0x" + Long.toHexString(this.getOffset()) : "");
        }

        @Override
        public Object getMetricValue(FunctionMetric metric) {
            return this.metrics.get(metric);
        }

        @Override
        public Object getMetricValue(String metric_id) {
            for (FunctionMetric metric : this.metrics.keySet()) {
                if (!metric.getMetricID().equals(metric_id)) continue;
                return this.metrics.get(metric);
            }
            return null;
        }

        @Override
        public boolean hasMetric(String metric_id) {
            for (FunctionMetric metric : this.metrics.keySet()) {
                if (!metric.getMetricID().equals(metric_id)) continue;
                return true;
            }
            return false;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder();
            buf.append("FunctionCall{ function=").append(this.getFunction());
            buf.append(", metrics=").append(this.metrics).append(" }");
            return buf.toString();
        }

        @Override
        public int getLineNumber() {
            return this.lineNumber;
        }
    }

    protected static class FunctionImpl
    implements Function {
        private final long id;
        private String name;
        private final String quilifiedName;
        private final String module_name;
        private final String module_offset;
        private final String source_file;

        public FunctionImpl(long id, String name, String qualifiedName) {
            this(id, name, qualifiedName, FunctionNameUtils.getFunctionModule(qualifiedName), FunctionNameUtils.getFunctionModuleOffset(qualifiedName), FunctionNameUtils.getSourceFileInfo(qualifiedName) == null ? null : FunctionNameUtils.getSourceFileInfo(qualifiedName).getFileName());
        }

        public FunctionImpl(long id, String name, String qualifiedName, String source_file) {
            this(id, name, qualifiedName, FunctionNameUtils.getFunctionModule(qualifiedName), FunctionNameUtils.getFunctionModuleOffset(qualifiedName), source_file);
        }

        public FunctionImpl(long id, String name, String qualifiedName, String module_name, String module_offset, String source_file) {
            this.id = id;
            this.name = name;
            this.quilifiedName = qualifiedName;
            this.module_name = module_name;
            this.module_offset = module_offset;
            this.source_file = source_file;
        }

        public long getId() {
            return this.id;
        }

        @Override
        public String getName() {
            return this.name;
        }

        private void setName(String name) {
            this.name = name;
        }

        @Override
        public String getSignature() {
            return this.quilifiedName;
        }

        public String toString() {
            return this.name;
        }

        @Override
        public String getQuilifiedName() {
            return FunctionNameUtils.getFunctionQName(this.name);
        }

        @Override
        public String getModuleName() {
            return FunctionNameUtils.getFunctionModule(this.name);
        }

        String getFullName() {
            return FunctionNameUtils.getFullFunctionName(this.quilifiedName);
        }

        @Override
        public String getModuleOffset() {
            return this.module_offset;
        }

        @Override
        public String getSourceFile() {
            return this.source_file;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof FunctionImpl)) {
                return false;
            }
            FunctionImpl that = (FunctionImpl)obj;
            return this.id == that.id && this.getFullName().equals(that.getFullName());
        }

        public int hashCode() {
            int hash = 5;
            hash = 29 * hash + (this.getFullName() != null ? this.getFullName().hashCode() : 0);
            hash = 29 * hash + (int)(this.id ^ this.id >>> 32);
            return hash;
        }
    }

    private static class NodeCacheKey {
        private final long callerId;
        private final long funcId;
        private final long offset;

        public NodeCacheKey(long callerId, long funcId, long offset) {
            this.callerId = callerId;
            this.funcId = funcId;
            this.offset = offset;
        }

        public boolean equals(Object obj) {
            if (!(obj instanceof NodeCacheKey)) {
                return false;
            }
            NodeCacheKey that = (NodeCacheKey)obj;
            return this.callerId == that.callerId && this.funcId == that.funcId && this.offset == that.offset;
        }

        public int hashCode() {
            return 13 * ((int)(this.callerId >> 32) | (int)this.callerId) + 17 * ((int)(this.funcId >> 32) | (int)this.funcId) + ((int)(this.offset >> 32) | (int)this.offset);
        }
    }
}

