/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.core.stack.storage.impl;

import java.util.List;
import org.netbeans.modules.dlight.core.stack.api.FunctionCall;
import org.netbeans.modules.dlight.core.stack.api.ThreadInfo;
import org.netbeans.modules.dlight.core.stack.api.ThreadSnapshot;
import org.netbeans.modules.dlight.core.stack.api.ThreadState;
import org.netbeans.modules.dlight.core.stack.storage.impl.SQLStackDataStorage;

final class SnapshotImpl
implements ThreadSnapshot {
    private final Lock lock = new Lock();
    private final ThreadInfo threadInfo;
    private final SQLStackDataStorage storage;
    private final int stackID;
    private final long timestamp;
    private final ThreadState.MSAState state;
    private boolean stackLoaded = false;
    private List<FunctionCall> stack = null;

    public SnapshotImpl(SQLStackDataStorage storage, long timestamp, final int threadID, int stackID, ThreadState.MSAState state) {
        this.timestamp = timestamp;
        this.storage = storage;
        this.stackID = stackID;
        this.state = state;
        this.threadInfo = new ThreadInfo(){

            @Override
            public int getThreadId() {
                return threadID;
            }

            @Override
            public String getThreadName() {
                return "Thread " + threadID;
            }
        };
    }

    @Override
    public ThreadInfo getThreadInfo() {
        return this.threadInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<FunctionCall> getStack() {
        Lock lock = this.lock;
        synchronized (lock) {
            if (this.stackLoaded) {
                return this.stack;
            }
            this.stack = this.storage.getCallStack(this.stackID);
            this.stackLoaded = true;
            return this.stack;
        }
    }

    @Override
    public ThreadState.MSAState getState() {
        return this.state;
    }

    @Override
    public ThreadSnapshot.MemoryAccessType getMemoryAccessType() {
        return null;
    }

    @Override
    public long getTimestamp() {
        return this.timestamp;
    }

    private static final class Lock {
        private Lock() {
        }
    }
}

