/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.core.stack.ui;

import java.awt.Image;
import java.io.File;
import javax.swing.Action;
import org.netbeans.modules.dlight.core.stack.api.FunctionCall;
import org.netbeans.modules.dlight.core.stack.ui.CallStackTreeModel;
import org.netbeans.modules.dlight.core.stack.ui.CallStackUISupport;
import org.netbeans.modules.dlight.core.stack.ui.FunctionCallChildren;
import org.netbeans.modules.dlight.core.stack.ui.GoToSourceAction;
import org.netbeans.modules.dlight.spi.SourceFileInfoProvider;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;

final class FunctionCallNode
extends AbstractNode
implements GoToSourceAction.GoToSourceActionReadnessListener {
    private final FunctionCall functionCall;
    private GoToSourceAction action;
    private String plainDisplayName = null;
    private String htmlDisplayName = null;
    private String functionName = null;
    private boolean useHtmlFormat = true;

    FunctionCallNode(CallStackTreeModel stackModel, FunctionCall functionCall) {
        super((Children)(stackModel.getCallers(functionCall) == null ? Children.LEAF : new FunctionCallChildren(stackModel, stackModel.getCallers(functionCall))));
        this.functionCall = functionCall;
        this.action = new GoToSourceAction(stackModel.getSourceFileInfoProvider(), functionCall, this);
        this.plainDisplayName = functionCall.getDisplayedName();
        this.updateNames();
    }

    public Image getIcon(int type) {
        return ImageUtilities.mergeImages((Image)CallStackUISupport.functionIcon, (Image)CallStackUISupport.upBadge, (int)0, (int)0);
    }

    public Image getOpenedIcon(int type) {
        return this.getIcon(type);
    }

    public Action[] getActions(boolean context) {
        return new Action[]{this.action};
    }

    public Action getPreferredAction() {
        return this.action;
    }

    public synchronized String getDisplayName() {
        return this.useHtmlFormat ? this.htmlDisplayName : this.plainDisplayName;
    }

    public synchronized String getHtmlDisplayName() {
        return this.htmlDisplayName;
    }

    private String toHtml(String plain) {
        plain = plain.replace("&", "&amp;");
        plain = plain.replace("<", "&lt;");
        plain = plain.replace(">", "&gt;");
        plain = plain.replace(" ", "&nbsp;");
        return plain;
    }

    private synchronized void updateNames() {
        this.plainDisplayName = this.functionCall.getDisplayedName();
        String name = this.functionCall.getFunction().getName();
        String funcName = this.functionCall.getFunction().getQuilifiedName();
        int idx1 = name.indexOf(funcName);
        int idx2 = funcName.lastIndexOf(58);
        if (idx2 > 0) {
            idx1 += idx2 + 1;
            funcName = funcName.substring(idx2 + 1);
        }
        this.functionName = funcName;
        String prefix = name.substring(0, idx1);
        String suffix = name.substring(idx1 + funcName.length());
        prefix = this.toHtml(prefix);
        funcName = this.toHtml(funcName);
        suffix = this.toHtml(suffix);
        funcName = "<b>" + funcName + "</b>";
        String dispName = prefix + funcName + suffix + "&nbsp;";
        StringBuilder result = new StringBuilder("<html>");
        String infoSuffix = null;
        if (this.action.isEnabled()) {
            result.append("<font color='#000000'>").append(dispName).append("</font>");
            SourceFileInfoProvider.SourceFileInfo sourceInfo = this.action.getSource();
            if (sourceInfo != null && sourceInfo.isSourceKnown()) {
                String fname = new File(sourceInfo.getFileName()).getName();
                int line = sourceInfo.getLine();
                String infoPrefix = line > 0 ? FunctionCallNode.getMessage("FunctionCallNode.prefix.withLine") : FunctionCallNode.getMessage("FunctionCallNode.prefix.withoutLine");
                infoSuffix = infoPrefix + "&nbsp;" + fname + (line > 0 ? ":" + line : "");
                result.append("<font color='#808080'>").append(infoSuffix).append("</font>");
            }
        } else {
            result.append("<font color='#808080'>").append(dispName).append("</font>");
        }
        result.append("</html>");
        this.htmlDisplayName = result.toString();
    }

    @Override
    public void ready() {
        this.updateNames();
        this.fireDisplayNameChange(this.getDisplayName() + "_", this.getDisplayName());
    }

    private static String getMessage(String key) {
        return NbBundle.getMessage(FunctionCallNode.class, (String)key);
    }
}

