/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.core.stack.ui;

import java.awt.Component;
import java.awt.EventQueue;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;
import org.netbeans.modules.dlight.core.stack.api.FunctionCall;
import org.netbeans.modules.dlight.core.stack.dataprovider.SourceFileInfoDataProvider;
import org.netbeans.modules.dlight.core.stack.ui.MultipleCallStackRootNode;
import org.netbeans.modules.dlight.core.stack.ui.StackRootNode;
import org.openide.explorer.ExplorerManager;
import org.openide.explorer.ExplorerUtils;
import org.openide.explorer.view.BeanTreeView;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public final class MultipleCallStackPanel
extends JPanel
implements ExplorerManager.Provider,
Lookup.Provider {
    private final ExplorerManager manager = new ExplorerManager();
    private final MultipleCallStackRootNode rootNode;
    private final BeanTreeView treeView;
    private Lookup lookup;
    private final SourceFileInfoDataProvider sourceFileInfoDataProvider;
    private final boolean useHtmlFormat;

    private MultipleCallStackPanel(SourceFileInfoDataProvider sourceFileInfoDataProvider, boolean useHTML) {
        this.setLayout(new BoxLayout(this, 1));
        this.sourceFileInfoDataProvider = sourceFileInfoDataProvider;
        this.useHtmlFormat = useHTML;
        this.lookup = ExplorerUtils.createLookup((ExplorerManager)this.manager, (ActionMap)new ActionMap());
        this.treeView = new MyOwnBeanTreeView();
        this.treeView.setRootVisible(false);
        this.add((Component)this.treeView);
        AbstractAction expandAll = new AbstractAction(NbBundle.getMessage(MultipleCallStackPanel.class, (String)"ExpandAll")){

            @Override
            public void actionPerformed(ActionEvent e) {
                MultipleCallStackPanel.this.treeView.expandAll();
            }
        };
        this.rootNode = new MultipleCallStackRootNode(expandAll);
        this.manager.setRootContext((Node)this.rootNode);
        final JPopupMenu popup = new JPopupMenu();
        popup.add(expandAll);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (SwingUtilities.isRightMouseButton(e)) {
                    popup.show(MultipleCallStackPanel.this, e.getX(), e.getY());
                }
            }
        });
        ActionMap map = new ActionMap();
        map.put("org.openide.actions.PopupAction", expandAll);
        this.setActionMap(map);
        this.treeView.setPopupAllowed(true);
        this.treeView.setActionMap(map);
    }

    public static MultipleCallStackPanel createInstance() {
        return new MultipleCallStackPanel(null, false);
    }

    public static MultipleCallStackPanel createInstance(SourceFileInfoDataProvider sourceFileInfoDataProvider) {
        return new MultipleCallStackPanel(sourceFileInfoDataProvider, false);
    }

    public static MultipleCallStackPanel createInstance(SourceFileInfoDataProvider sourceFileInfoDataProvider, boolean useHTML) {
        return new MultipleCallStackPanel(sourceFileInfoDataProvider, useHTML);
    }

    @Override
    public boolean requestFocus(boolean temporary) {
        if (this.treeView != null) {
            return this.treeView.requestFocus(temporary);
        }
        return super.requestFocus(temporary);
    }

    public void clean() {
        this.rootNode.removeAll();
        this.treeView.setRootVisible(false);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.treeView.expandAll();
    }

    @Override
    public void requestFocus() {
        this.treeView.requestFocus();
    }

    @Override
    public boolean requestFocusInWindow() {
        return this.treeView.requestFocusInWindow();
    }

    public void expandAll() {
        if (this.manager.getRootContext() == null) {
            return;
        }
        this.treeView.expandAll();
    }

    public void scrollToRoot() {
        this.treeView.getViewport().setViewPosition(new Point(0, 0));
    }

    public void expandNode(Node node) {
        this.treeView.expandNode(node);
    }

    public void setRootVisible(String rootName) {
        this.treeView.setRootVisible(true);
        this.rootNode.setDisplayName(rootName);
    }

    public final void add(String rootName, Icon icon, List<FunctionCall> stack, Action[] actions) {
        this.rootNode.add(new StackRootNode(this.sourceFileInfoDataProvider, icon, rootName, stack, actions, this.useHtmlFormat));
    }

    public final void add(String rootName, Icon icon, List<FunctionCall> stack) {
        this.rootNode.add(new StackRootNode(this.sourceFileInfoDataProvider, icon, rootName, stack, this.useHtmlFormat));
    }

    public final void add(String rootName, boolean isRootVisible, List<FunctionCall> stack) {
        this.treeView.setRootVisible(false);
        this.rootNode.add(new StackRootNode(this.sourceFileInfoDataProvider, rootName, stack, this.useHtmlFormat));
    }

    public void update() {
    }

    public ExplorerManager getExplorerManager() {
        return this.manager;
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    private static final class MyOwnBeanTreeView
    extends BeanTreeView {
        MyOwnBeanTreeView() {
        }

        public void expandAll() {
            if (!EventQueue.isDispatchThread()) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        MyOwnBeanTreeView.super.expandAll();
                    }
                });
            } else {
                super.expandAll();
            }
        }
    }
}

