/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.dlight.core.stack.ui;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Vector;
import javax.swing.JComponent;
import org.netbeans.modules.dlight.api.storage.DataRow;
import org.netbeans.modules.dlight.api.storage.DataTableMetadata;
import org.netbeans.modules.dlight.api.storage.DataUtil;
import org.netbeans.modules.dlight.api.support.DataModelSchemeProvider;
import org.netbeans.modules.dlight.core.stack.api.FunctionCall;
import org.netbeans.modules.dlight.core.stack.dataprovider.StackDataProvider;
import org.netbeans.modules.dlight.core.stack.ui.MultipleCallStackPanel;
import org.netbeans.modules.dlight.management.api.DLightManager;
import org.netbeans.modules.dlight.management.api.DLightSession;
import org.netbeans.modules.dlight.util.DLightExecutorService;
import org.netbeans.modules.dlight.util.UIThread;
import org.netbeans.modules.dlight.util.ui.Renderer;

public final class StackRenderer
implements Renderer<DataRow> {
    private final Lock lock = new Lock();
    private final List<DataTableMetadata.Column> stackColumns;
    private final boolean useHMTL;
    private boolean stackDataProviderSearched;
    private StackDataProvider stackDataProvider;

    public StackRenderer(List<DataTableMetadata.Column> stackColumns) {
        this(stackColumns, false);
    }

    public StackRenderer(List<DataTableMetadata.Column> stackColumns, boolean useHtml) {
        this.stackColumns = Collections.unmodifiableList(new ArrayList<DataTableMetadata.Column>(stackColumns));
        this.useHMTL = useHtml;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JComponent render(final DataRow data) {
        Lock lock = this.lock;
        synchronized (lock) {
            final StackDataProvider stackProvider = this.findStackDataProvider();
            final MultipleCallStackPanel resultPanel = MultipleCallStackPanel.createInstance(stackProvider);
            if (stackProvider != null) {
                DLightExecutorService.submit((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        final Vector<List<FunctionCall>> stacks = new Vector<List<FunctionCall>>();
                        stacks.setSize(StackRenderer.this.stackColumns.size());
                        final DataTableMetadata.Column[] columns_array = StackRenderer.this.stackColumns.toArray(new DataTableMetadata.Column[0]);
                        int size = columns_array.length;
                        for (int i = 0; i < size; ++i) {
                            DataTableMetadata.Column column = columns_array[i];
                            int stackId = DataUtil.toInt((Object)data.getData(column.getColumnName()));
                            if (0 >= stackId) continue;
                            stacks.set(i, stackProvider.getCallStack(stackId));
                        }
                        UIThread.invoke((Runnable)new Runnable(){

                            @Override
                            public void run() {
                                int size = columns_array.length;
                                for (int i = 0; i < size; ++i) {
                                    DataTableMetadata.Column column = columns_array[i];
                                    List stack = (List)stacks.get(i);
                                    if (stack == null) continue;
                                    resultPanel.add(column.getColumnUName(), true, (List<FunctionCall>)stack);
                                }
                                resultPanel.expandAll();
                            }
                        });
                    }
                }, (String)"Fill-in panel for a stack in StackRenderer");
            }
            return resultPanel;
        }
    }

    public void reset() {
        this.stackDataProvider = null;
        this.stackDataProviderSearched = false;
    }

    private synchronized StackDataProvider findStackDataProvider() {
        if (this.stackDataProvider == null && !this.stackDataProviderSearched) {
            DLightSession session = DLightManager.getDefault().getActiveSession();
            this.stackDataProvider = (StackDataProvider)session.createDataProvider(DataModelSchemeProvider.getInstance().getScheme("model:stack"), null);
            this.stackDataProviderSearched = true;
        }
        return this.stackDataProvider;
    }

    private static final class Lock {
        private Lock() {
        }
    }
}

