/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.properties;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.lang.ref.Reference;
import java.lang.ref.SoftReference;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import org.netbeans.modules.properties.PropertiesDataObject;
import org.netbeans.modules.properties.PropertiesEncoding;
import org.netbeans.modules.properties.PropertiesFileEntry;
import org.openide.filesystems.FileObject;
import org.openide.loaders.ExtensionList;
import org.openide.loaders.MultiDataObject;
import org.openide.loaders.MultiFileLoader;
import org.openide.util.NbBundle;
import org.openide.util.io.SafeException;

public final class PropertiesDataLoader
extends MultiFileLoader {
    static final String PROPERTIES_EXTENSION = "properties";
    static final String PROPERTIES_MIME_TYPE = "text/x-properties";
    public static final char PRB_SEPARATOR_CHAR = '_';
    static final long serialVersionUID = 4384899552891479449L;
    public static final String PROP_EXTENSIONS = "extensions";
    private Reference<PropertiesEncoding> encodingRef;
    private static Set<String> knownLanguages;
    private static Set<String> knownCountries;
    private static boolean nestedView;

    public PropertiesDataLoader() {
        super("org.netbeans.modules.properties.PropertiesDataObject");
        ExtensionList extList = new ExtensionList();
        extList.addExtension(PROPERTIES_EXTENSION);
        extList.addExtension("impl");
        this.setExtensions(extList);
    }

    PropertiesEncoding getEncoding() {
        PropertiesEncoding encoding;
        if (this.encodingRef == null || (encoding = this.encodingRef.get()) == null) {
            encoding = new PropertiesEncoding();
            this.encodingRef = new SoftReference<PropertiesEncoding>(encoding);
        }
        return encoding;
    }

    protected String defaultDisplayName() {
        return NbBundle.getMessage(PropertiesDataLoader.class, (String)"PROP_PropertiesLoader_Name");
    }

    protected String actionsContext() {
        return "Loaders/text/x-properties/Actions/";
    }

    protected MultiDataObject createMultiObject(FileObject fo) throws IOException {
        return new PropertiesDataObject(fo, this);
    }

    protected FileObject findPrimaryFile(FileObject fo) {
        if (fo.isFolder()) {
            return null;
        }
        if (fo.getExt().equalsIgnoreCase(PROPERTIES_EXTENSION)) {
            String fName = fo.getName();
            if (nestedView) {
                int index = fName.indexOf(95);
                while (index != -1) {
                    FileObject candidate = fo.getParent().getFileObject(fName.substring(0, index), fo.getExt());
                    if (candidate != null && PropertiesDataLoader.isValidLocaleSuffix(fName.substring(index))) {
                        return candidate;
                    }
                    index = fName.indexOf(95, index + 1);
                }
            }
            return fo;
        }
        if (fo.getMIMEType().equalsIgnoreCase(PROPERTIES_MIME_TYPE)) {
            return fo;
        }
        return this.getExtensions().isRegistered(fo) ? fo : null;
    }

    private static boolean isValidLocaleSuffix(String s) {
        String s2;
        int n = s.length();
        if (n != 3 && (n <= 3 || s.charAt(3) != '_')) {
            return false;
        }
        String s1 = s.substring(1, 3).toLowerCase();
        if (n == 3) {
            s2 = null;
        } else if (n == 6 || n > 6 && s.charAt(6) == '_') {
            s2 = s.substring(4, 6).toUpperCase();
        } else {
            return false;
        }
        if (knownLanguages == null) {
            knownLanguages = new HashSet<String>(Arrays.asList(Locale.getISOLanguages()));
        }
        if (!knownLanguages.contains(s1)) {
            return false;
        }
        if (s2 != null) {
            if (knownCountries == null) {
                knownCountries = new HashSet<String>(Arrays.asList(Locale.getISOCountries()));
            }
            if (!knownCountries.contains(s2)) {
                return false;
            }
        }
        return true;
    }

    protected MultiDataObject.Entry createPrimaryEntry(MultiDataObject obj, FileObject primaryFile) {
        return new PropertiesFileEntry(obj, primaryFile);
    }

    protected MultiDataObject.Entry createSecondaryEntry(MultiDataObject obj, FileObject secondaryFile) {
        return new PropertiesFileEntry(obj, secondaryFile);
    }

    public void setExtensions(ExtensionList ext) {
        this.putProperty(PROP_EXTENSIONS, ext, true);
    }

    public ExtensionList getExtensions() {
        ExtensionList l = (ExtensionList)this.getProperty(PROP_EXTENSIONS);
        if (l == null) {
            l = new ExtensionList();
            this.putProperty(PROP_EXTENSIONS, l, false);
        }
        return l;
    }

    public void writeExternal(ObjectOutput oo) throws IOException {
        super.writeExternal(oo);
        oo.writeObject(this.getProperty(PROP_EXTENSIONS));
    }

    public void readExternal(ObjectInput oi) throws IOException, ClassNotFoundException {
        SafeException se;
        try {
            super.readExternal(oi);
            se = null;
        }
        catch (SafeException se2) {
            se = se2;
        }
        this.setExtensions((ExtensionList)oi.readObject());
        if (se != null) {
            throw se;
        }
    }

    static {
        nestedView = false;
    }
}

