/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.completion.impl.xref;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.cnd.api.model.CsmDeclaration;
import org.netbeans.modules.cnd.api.model.CsmEnum;
import org.netbeans.modules.cnd.api.model.CsmEnumerator;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmFunction;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmMacro;
import org.netbeans.modules.cnd.api.model.CsmObject;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmOffsetableDeclaration;
import org.netbeans.modules.cnd.api.model.CsmScope;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.CsmVariable;
import org.netbeans.modules.cnd.api.model.services.CsmSelect;
import org.netbeans.modules.cnd.api.model.util.CsmKindUtilities;
import org.netbeans.modules.cnd.api.model.util.UIDs;
import org.netbeans.modules.cnd.completion.csm.CsmContextUtilities;
import org.netbeans.modules.cnd.completion.csm.CsmProjectContentResolver;
import org.netbeans.modules.cnd.completion.impl.xref.SymTabCache;
import org.openide.util.CharSequences;

public final class FileReferencesContext {
    private CsmFile csmFile;
    private int lastOffset;
    private boolean isClened = false;
    private Map<String, List<CsmUID<CsmVariable>>> fileLocalVars;
    private Map<String, Collection<CsmEnumerator>> libEnumerators;
    private Map<String, CsmEnumerator> hotSpotEnumerators;
    private List<Offsets> fileObjectOffsets;
    private List<Offsets> fileDeclarationsOffsets;
    private Map<CharSequence, CsmUID<CsmMacro>> projectMacros;
    private SymTabCache symTabCache = new SymTabCache();

    FileReferencesContext(CsmScope csmScope) {
        if (CsmKindUtilities.isFile((CsmObject)csmScope)) {
            this.csmFile = (CsmFile)csmScope;
        } else if (CsmKindUtilities.isFunction((CsmObject)csmScope)) {
            this.csmFile = ((CsmFunction)csmScope).getContainingFile();
        } else if (CsmKindUtilities.isOffsetable((Object)csmScope)) {
            this.csmFile = ((CsmOffsetable)csmScope).getContainingFile();
        }
        this.lastOffset = 0;
    }

    public void clean() {
        this.isClened = true;
        this._clean();
    }

    private void _clean() {
        if (this.fileLocalVars != null) {
            this.fileLocalVars = null;
            this.fileDeclarationsOffsets = null;
            this.fileObjectOffsets = null;
            this.projectMacros = null;
            this.libEnumerators = null;
        }
        this.symTabCache.clear();
    }

    public boolean isCleaned() {
        return this.isClened;
    }

    public void advance(int offset) {
        if (this.csmFile == null) {
            return;
        }
        this.lastOffset = offset;
    }

    public SymTabCache getSymTabCache() {
        return this.symTabCache;
    }

    public void putHotSpotEnum(Collection<CsmEnumerator> enumerators) {
        if (this.isCleaned()) {
            return;
        }
        if (this.hotSpotEnumerators == null) {
            this.hotSpotEnumerators = new HashMap<String, CsmEnumerator>();
        }
        HashSet<CsmEnum> enums = new HashSet<CsmEnum>();
        for (CsmEnumerator csmEnumerator : enumerators) {
            enums.add(csmEnumerator.getEnumeration());
        }
        for (CsmEnum csmEnum : enums) {
            for (CsmEnumerator i : csmEnum.getEnumerators()) {
                this.hotSpotEnumerators.put(((Object)i.getName()).toString(), i);
            }
        }
    }

    public CsmEnumerator getHotSpotEnum(String name) {
        if (this.isCleaned()) {
            return null;
        }
        if (this.hotSpotEnumerators == null) {
            this.hotSpotEnumerators = new HashMap<String, CsmEnumerator>();
        }
        return this.hotSpotEnumerators.get(name);
    }

    public Collection<CsmEnumerator> getLibEnumerators(String name) {
        if (this.isCleaned()) {
            return null;
        }
        if (this.libEnumerators == null) {
            this.libEnumerators = new HashMap<String, Collection<CsmEnumerator>>();
        }
        return this.libEnumerators.get(name);
    }

    public void putLibEnumerators(String name, Collection<CsmEnumerator> value) {
        if (this.isCleaned()) {
            return;
        }
        if (this.libEnumerators == null) {
            this.libEnumerators = new HashMap<String, Collection<CsmEnumerator>>();
        }
        this.libEnumerators.put(name, value);
    }

    public List<CsmVariable> getFileLocalIncludeVariables(String name) {
        List<CsmUID<CsmVariable>> vars;
        if (this.isCleaned()) {
            return null;
        }
        if (this.fileLocalVars == null) {
            this.fillFileLocalIncludeVariables();
        }
        if ((vars = this.fileLocalVars.get(name)) == null || vars.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<CsmVariable> res = new ArrayList<CsmVariable>(vars.size());
        for (CsmUID<CsmVariable> uid : vars) {
            CsmVariable v = (CsmVariable)uid.getObject();
            if (v == null) continue;
            res.add(v);
        }
        return res;
    }

    public CsmObject findInnerFileDeclaration(int offset) {
        Offsets key;
        int res;
        if (this.isCleaned()) {
            return null;
        }
        if (this.fileDeclarationsOffsets == null) {
            this.fileDeclarationsOffsets = new ArrayList<Offsets>();
            this.fileObjectOffsets = new ArrayList<Offsets>();
            this.fillFileOffsets();
        }
        if ((res = Collections.binarySearch(this.fileDeclarationsOffsets, key = new Offsets(offset))) >= 0) {
            Offsets next;
            if (res < this.fileDeclarationsOffsets.size() - 1 && (next = this.fileDeclarationsOffsets.get(res + 1)).compareTo(key) == 0) {
                return next.object;
            }
            return this.fileDeclarationsOffsets.get(res).object;
        }
        return null;
    }

    public CsmObject findInnerFileObject(int offset) {
        Offsets key;
        int res;
        if (this.isCleaned()) {
            return null;
        }
        if (this.fileDeclarationsOffsets == null) {
            this.fileDeclarationsOffsets = new ArrayList<Offsets>();
            this.fileObjectOffsets = new ArrayList<Offsets>();
            this.fillFileOffsets();
        }
        if ((res = Collections.binarySearch(this.fileObjectOffsets, key = new Offsets(offset))) >= 0) {
            Offsets next;
            if (res < this.fileObjectOffsets.size() - 1 && (next = this.fileObjectOffsets.get(res + 1)).compareTo(key) == 0) {
                return next.object;
            }
            return this.fileObjectOffsets.get(res).object;
        }
        return null;
    }

    public CsmMacro findIncludedMacro(String name) {
        CsmUID<CsmMacro> uid;
        if (this.isCleaned()) {
            return null;
        }
        if (this.projectMacros == null) {
            this.projectMacros = new HashMap<CharSequence, CsmUID<CsmMacro>>();
            this.fillProjectMacros();
        }
        if ((uid = this.projectMacros.get(CharSequences.create((CharSequence)name))) != null) {
            return (CsmMacro)uid.getObject();
        }
        return null;
    }

    private synchronized void fillFileLocalIncludeVariables() {
        if (this.fileLocalVars != null) {
            return;
        }
        this.fileLocalVars = new HashMap<String, List<CsmUID<CsmVariable>>>();
        CsmDeclaration.Kind[] kinds = new CsmDeclaration.Kind[]{CsmDeclaration.Kind.VARIABLE, CsmDeclaration.Kind.VARIABLE_DEFINITION};
        CsmSelect.CsmFilter filter = CsmContextUtilities.createFilter(kinds, null, true, true, false);
        ArrayList<CsmVariable> allVars = new ArrayList<CsmVariable>(10);
        CsmProjectContentResolver.fillFileLocalVariablesByFilter(filter, this.csmFile, allVars);
        for (CsmVariable var : allVars) {
            String name = ((Object)var.getName()).toString();
            List<CsmUID<CsmVariable>> list = this.fileLocalVars.get(name);
            if (list == null) {
                list = new ArrayList<CsmUID<CsmVariable>>();
                this.fileLocalVars.put(name, list);
            }
            list.add((CsmUID<CsmVariable>)UIDs.get((Object)var));
        }
    }

    private void fillFileOffsets() {
        for (CsmOffsetableDeclaration declaration : this.csmFile.getDeclarations()) {
            this.fileDeclarationsOffsets.add(new Offsets(declaration));
        }
        for (CsmOffsetableDeclaration declaration : this.csmFile.getIncludes()) {
            this.fileObjectOffsets.add(new Offsets((CsmInclude)declaration));
        }
        for (CsmOffsetableDeclaration declaration : this.csmFile.getMacros()) {
            this.fileObjectOffsets.add(new Offsets((CsmMacro)declaration));
        }
        Collections.sort(this.fileObjectOffsets);
    }

    private void fillProjectMacros() {
        this.gatherIncludeMacros(this.csmFile, new HashSet<CsmFile>());
    }

    private void gatherIncludeMacros(CsmFile file, Set<CsmFile> visitedFiles) {
        if (visitedFiles.contains(file)) {
            return;
        }
        visitedFiles.add(file);
        for (CsmInclude inc : file.getIncludes()) {
            CsmFile incFile = inc.getIncludeFile();
            if (incFile == null) continue;
            this.getFileLocalMacros(incFile);
            this.gatherIncludeMacros(incFile, visitedFiles);
        }
    }

    private void getFileLocalMacros(CsmFile file) {
        for (CsmMacro macro : file.getMacros()) {
            CharSequence name = macro.getName();
            CsmUID<CsmMacro> uid = this.projectMacros.get(name);
            if (uid != null) continue;
            this.projectMacros.put(name, (CsmUID<CsmMacro>)UIDs.get((Object)macro));
        }
    }

    private static class Offsets
    implements Comparable<Offsets> {
        private int startOffset;
        private int endOffset;
        private CsmObject object;

        Offsets(CsmOffsetableDeclaration declaration) {
            this.startOffset = declaration.getStartOffset();
            this.endOffset = declaration.getEndOffset();
            this.object = declaration;
        }

        Offsets(CsmMacro macros) {
            this.startOffset = macros.getStartOffset();
            this.endOffset = macros.getEndOffset();
            this.object = macros;
        }

        Offsets(CsmInclude include) {
            this.startOffset = include.getStartOffset();
            this.endOffset = include.getEndOffset();
            this.object = include;
        }

        Offsets(int offset) {
            this.startOffset = offset;
            this.endOffset = offset;
        }

        @Override
        public int compareTo(Offsets o) {
            if (this.object != null && o.object == null ? this.startOffset <= o.startOffset && o.startOffset < this.endOffset : this.object == null && o.object != null && o.startOffset <= this.startOffset && this.startOffset < o.endOffset) {
                return 0;
            }
            return this.startOffset - o.startOffset;
        }
    }
}

