/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.parsing;

import oracle.toplink.essentials.expressions.Expression;
import oracle.toplink.essentials.internal.parsing.EscapeNode;
import oracle.toplink.essentials.internal.parsing.GenerationContext;
import oracle.toplink.essentials.internal.parsing.ParseTreeContext;
import oracle.toplink.essentials.internal.parsing.SimpleConditionalExpressionNode;
import oracle.toplink.essentials.internal.parsing.TypeHelper;

public class LikeNode
extends SimpleConditionalExpressionNode {
    private EscapeNode escape = null;

    public void validate(ParseTreeContext context) {
        TypeHelper typeHelper = context.getTypeHelper();
        if (this.left != null) {
            this.left.validate(context);
            this.left.validateParameter(context, typeHelper.getStringType());
        }
        if (this.right != null) {
            this.right.validate(context);
            this.right.validateParameter(context, typeHelper.getStringType());
        }
        if (this.escape != null) {
            this.escape.validate(context);
        }
        this.setType(typeHelper.getBooleanType());
    }

    public Expression generateExpression(GenerationContext context) {
        Expression whereClause = this.getLeft().generateExpression(context);
        whereClause = !this.hasEscape() ? whereClause.like(this.getRight().generateExpression(context)) : whereClause.like(this.getRight().generateExpression(context), this.getEscapeNode().generateExpression(context));
        return whereClause;
    }

    public boolean hasEscape() {
        return this.getEscapeNode() != null;
    }

    public EscapeNode getEscapeNode() {
        return this.escape;
    }

    public void setEscapeNode(EscapeNode node) {
        this.escape = node;
    }
}

