/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.sessions;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.sql.Connection;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import oracle.toplink.essentials.exceptions.DatabaseException;
import oracle.toplink.essentials.internal.security.PrivilegedAccessHelper;
import oracle.toplink.essentials.internal.security.PrivilegedNewInstanceFromClass;
import oracle.toplink.essentials.sessions.DefaultConnector;

public class DirectConnector
extends DefaultConnector {
    protected Driver cachedInstance;

    public DirectConnector() {
    }

    public DirectConnector(String driverClassName, String driverURLHeader, String databaseURL) {
        super(driverClassName, driverURLHeader, databaseURL);
    }

    public Connection connect(Properties properties) throws DatabaseException {
        try {
            return this.instantiateDriver(this.loadDriver()).connect(this.getConnectionString(), properties);
        }
        catch (SQLException exception) {
            throw DatabaseException.sqlException(exception);
        }
    }

    protected Driver instantiateDriver(Class driverClass) throws DatabaseException {
        if (this.cachedInstance != null) {
            return this.cachedInstance;
        }
        try {
            if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                try {
                    this.cachedInstance = (Driver)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(driverClass));
                }
                catch (PrivilegedActionException exception) {
                    Exception throwableException = exception.getException();
                    if (throwableException instanceof InstantiationException) {
                        throw DatabaseException.configurationErrorNewInstanceInstantiationException((InstantiationException)throwableException, driverClass);
                    }
                    throw DatabaseException.configurationErrorNewInstanceIllegalAccessException((IllegalAccessException)throwableException, driverClass);
                }
            } else {
                this.cachedInstance = (Driver)PrivilegedAccessHelper.newInstanceFromClass(driverClass);
            }
            return this.cachedInstance;
        }
        catch (InstantiationException ie) {
            throw DatabaseException.configurationErrorNewInstanceInstantiationException(ie, driverClass);
        }
        catch (IllegalAccessException iae) {
            throw DatabaseException.configurationErrorNewInstanceIllegalAccessException(iae, driverClass);
        }
    }
}

