/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javacard.ri.card;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import org.netbeans.modules.javacard.ri.card.RICard;

final class ConditionImpl
implements Condition {
    private volatile int steps;
    private final RICard card;
    private final Object lock = new Object();
    private volatile boolean done;

    ConditionImpl(int steps, RICard card) {
        this(steps, card, false);
    }

    ConditionImpl() {
        this(0, null, true);
    }

    private ConditionImpl(int steps, RICard card, boolean done) {
        this.card = card;
        this.steps = steps;
        this.done = done;
    }

    synchronized void countdown() {
        --this.steps;
        this.card.log("ConditionImpl " + this + " countdown " + this.steps);
        if (this.steps == 0) {
            this.signalAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void await() throws InterruptedException {
        if (this.done) {
            return;
        }
        this.card.log("ConditionImpl " + this + " await in " + Thread.currentThread());
        Object object = this.lock;
        synchronized (object) {
            this.lock.wait();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void awaitUninterruptibly() {
        if (this.done) {
            return;
        }
        this.card.log("ConditionImpl " + this + " awaitUninterruptibly " + Thread.currentThread());
        try {
            Object object = this.lock;
            synchronized (object) {
                this.await();
            }
        }
        catch (InterruptedException e) {
            this.awaitUninterruptibly();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long awaitNanos(long nanosTimeout) throws InterruptedException {
        if (this.done) {
            return 0L;
        }
        Object object = this.lock;
        synchronized (object) {
            this.lock.wait(0L, (int)nanosTimeout);
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean await(long time, TimeUnit unit) throws InterruptedException {
        if (this.done) {
            return true;
        }
        long millis = unit.convert(time, TimeUnit.MILLISECONDS);
        Object object = this.lock;
        synchronized (object) {
            this.lock.wait(millis);
        }
        return this.card.getState().isRunning();
    }

    @Override
    public boolean awaitUntil(Date deadline) throws InterruptedException {
        if (this.done) {
            return true;
        }
        long time = deadline.getTime() - System.currentTimeMillis();
        this.await(time, TimeUnit.MILLISECONDS);
        return this.card.getState().isRunning();
    }

    @Override
    public void signal() {
        this.signalAll();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void signalAll() {
        this.done = true;
        this.card.log("ConditionImpl " + this + " signalAll ");
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
    }
}

