/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.ws.policy.jaxws.xmlstreamwriter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum XmlStreamWriterMethodType {
    WRITE_START_DOCUMENT("writeStartDocument", true),
    WRITE_END_DOCUMENT("writeEndDocument", true),
    WRITE_START_ELEMENT("writeStartElement", true),
    WRITE_END_ELEMENT("writeEndElement", true),
    WRITE_EMPTY_ELEMENT("writeEmptyElement", true),
    WRITE_ATTRIBUTE("writeAttribute", true),
    WRITE_CHARACTERS("writeCharacters", true),
    WRITE_PROCESSING_INSTRUCTION("writeProcessingInstruction", true),
    WRITE_ENTITY_REFERENCE("writeEntityRef", true),
    WRITE_CDATA("writeCData", true),
    WRITE_COMMENT("writeComment", true),
    WRITE_DTD("writeDTD", true),
    WRITE_DEFAULT_NAMESPACE("writeDefaultNamespace", true),
    WRITE_NAMESPACE("writeNamespace", true),
    GET_NAMESPACE_CONTEXT("getNamespaceContext", false),
    GET_PREFIX("getPrefix", false),
    GET_PROPERTY("getProperty", false),
    SET_DEFAULT_NAMESPACE("setDefaultNamespace", true),
    SET_NAMESPACE_CONTEXT("setNamespaceContext", true),
    SET_PREFIX("setPrefix", true),
    CLOSE("close", false),
    FLUSH("flush", true),
    UNKNOWN("", true);

    private String methodName;
    private boolean filterable;

    static XmlStreamWriterMethodType getMethodType(String methodName) {
        if (methodName != null && methodName.length() > 0) {
            for (XmlStreamWriterMethodType type : XmlStreamWriterMethodType.values()) {
                if (!type.methodName.equals(methodName)) continue;
                return type;
            }
        }
        return UNKNOWN;
    }

    private XmlStreamWriterMethodType(String methodName, boolean isFilterable) {
        this.methodName = methodName;
        this.filterable = isFilterable;
    }

    public String getMethodName() {
        return this.methodName;
    }

    public boolean isFilterable() {
        return this.filterable;
    }
}

